/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_change.refactoring_detection;

import com.teamscale.index.code_change.MatchRegion;
import eu.cqse.check.framework.typetracker.TypedVariable;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;

public class RenameDetector
implements Serializable {
    private static final long serialVersionUID = -4620758697396239970L;
    private final PairList<String, String> classRenames = new PairList();
    private final PairList<String, String> methodRenames = new PairList();
    private transient SetMap<String, String> methodRenamesMap;
    private transient SetMap<String, String> classRenamesMap;
    private final Stack<Map<TypedVariable, TypedVariable>> variableRenames = new Stack();

    public boolean detectRenames(List<MatchRegion> regions) {
        boolean newRenamingsDetected = this.detectClassRenames(regions);
        this.computeMaps();
        return newRenamingsDetected |= this.detectMethodRenames(regions);
    }

    private boolean detectClassRenames(List<MatchRegion> regions) {
        boolean newRenamings = false;
        PairList<ClassId, ClassId> classRenamings = RenameDetector.getClassRenamingsFromMatchedMethods(regions);
        for (Pair classRenaming : classRenamings) {
            String oldName = ((ClassId)classRenaming.getFirst()).plainClassName;
            String newName = ((ClassId)classRenaming.getSecond()).plainClassName;
            this.classRenames.add((Object)oldName, (Object)newName);
            newRenamings |= !oldName.equals(newName);
        }
        return newRenamings;
    }

    private static PairList<ClassId, ClassId> getClassRenamingsFromMatchedMethods(List<MatchRegion> regions) {
        HashMap<ClassId, CounterSet> methodMoveCounter = new HashMap<ClassId, CounterSet>();
        for (MatchRegion newRegion : regions) {
            MatchRegion oldRegion = newRegion.getMatch();
            if (!newRegion.isMatched() || oldRegion.getParentName() == null || newRegion.getParentName() == null) continue;
            ClassId oldClass = new ClassId(oldRegion);
            ClassId newClass = new ClassId(newRegion);
            CounterSet successorCounter = (CounterSet)methodMoveCounter.get(oldClass);
            if (successorCounter == null) {
                successorCounter = new CounterSet();
                methodMoveCounter.put(oldClass, successorCounter);
            }
            successorCounter.inc((Object)newClass);
        }
        PairList renameList = new PairList();
        for (Map.Entry matchedMethodsPerClass : methodMoveCounter.entrySet()) {
            ClassId newClassId = (ClassId)((CounterSet)matchedMethodsPerClass.getValue()).getKeysByValueDescending().get(0);
            ClassId oldClassId = (ClassId)matchedMethodsPerClass.getKey();
            renameList.add((Object)oldClassId, (Object)newClassId);
        }
        return renameList;
    }

    private boolean detectMethodRenames(List<MatchRegion> regions) {
        boolean newRenamings = false;
        for (MatchRegion newRegion : regions) {
            if (!newRegion.isMatched()) continue;
            String oldName = RenameDetector.buildMethodId(newRegion.getMatch());
            String newName = RenameDetector.buildMethodId(newRegion);
            this.methodRenames.add((Object)oldName, (Object)newName);
            newRenamings |= !oldName.equals(newName);
        }
        return newRenamings;
    }

    private static String buildMethodId(MatchRegion region) {
        String methodId = region.getSimpleName();
        if (!region.getLanguage().isCaseSensitive()) {
            return methodId.toLowerCase();
        }
        return methodId;
    }

    private void computeMaps() {
        this.classRenamesMap = new SetMap();
        for (Pair rename : this.classRenames) {
            this.classRenamesMap.add((Object)((String)rename.getFirst()), (Object)((String)rename.getSecond()));
        }
        this.methodRenamesMap = new SetMap();
        for (Pair rename : this.methodRenames) {
            this.methodRenamesMap.add((Object)((String)rename.getFirst()), (Object)((String)rename.getSecond()));
        }
    }

    public void reset() {
        this.variableRenames.clear();
        this.variableRenames.push(new HashMap());
    }

    public void enterScope() {
        HashMap<TypedVariable, TypedVariable> item = new HashMap<TypedVariable, TypedVariable>(this.variableRenames.peek());
        this.variableRenames.push(item);
    }

    public void exitScope() {
        this.variableRenames.pop();
    }

    public boolean isValidVariableRenaming(TypedVariable oldVariable, TypedVariable newVariable) {
        if (this.variableRenames.peek().containsKey(oldVariable)) {
            return this.variableRenames.peek().get(oldVariable) == newVariable;
        }
        this.variableRenames.peek().put(oldVariable, newVariable);
        return true;
    }

    public boolean existsMethodRenamingRuleFor(String oldMethodName) {
        return this.methodRenamesMap.containsCollection((Object)oldMethodName);
    }

    public boolean isValidMethodRenaming(String oldMethodName, String newMethodName) {
        return this.methodRenamesMap.contains((Object)oldMethodName, (Object)newMethodName);
    }

    public boolean existsClassRenamingRuleFor(String oldClassName) {
        return this.classRenamesMap.containsCollection((Object)oldClassName);
    }

    public boolean isValidClassRenaming(String oldClassName, String newClassName) {
        return this.classRenamesMap.contains((Object)oldClassName, (Object)newClassName);
    }

    private static class ClassId {
        private String uniformPath;
        private String plainClassName;

        private ClassId(MatchRegion region) {
            this.uniformPath = region.getUniformPath();
            this.plainClassName = region.getParentName();
            if (!region.getLanguage().isCaseSensitive()) {
                this.uniformPath = this.uniformPath.toLowerCase();
                this.plainClassName = this.plainClassName.toLowerCase();
            }
        }

        public int hashCode() {
            return Objects.hash(this.uniformPath, this.plainClassName);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClassId other = (ClassId)obj;
            return Objects.equals(this.uniformPath, other.uniformPath) && Objects.equals(this.plainClassName, other.plainClassName);
        }
    }
}

