/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones.align;

import com.teamscale.index.code_clones.align.EAlignerStatementType;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.resource.text.filter.util.StringOffsetTransformer;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.LineOffsetConverter;

class AlignerStatement {
    private static final Set<ETokenType> ARTIFICIAL_TOKEN_TYPES = EnumSet.of(ETokenType.SEMICOLON, ETokenType.RBRACE, ETokenType.RPAREN);
    private int rawStartOffset = -1;
    private int rawEndOffset = -1;
    private int rawStartLine = -1;
    private int rawEndLine = -1;
    private int nonArtificialStatementIndex = -1;
    private final int depth;
    private final boolean hasPosition;
    private final boolean artificial;
    private final EAlignerStatementType statementType;

    public AlignerStatement(List<IToken> tokens, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter, int depth, boolean mayBeArtificial, EAlignerStatementType statementType) {
        this.depth = depth;
        this.statementType = statementType;
        if (tokens.isEmpty()) {
            CCSMAssert.isTrue((boolean)mayBeArtificial, (String)"Only artificial statements may be empty.");
            this.hasPosition = false;
        } else {
            this.hasPosition = true;
            IToken firstToken = tokens.get(0);
            this.rawStartOffset = offsetTransformer.getUnfilteredOffset(firstToken.getOffset());
            this.rawStartLine = rawLineOffsetConverter.getLine(this.rawStartOffset);
            IToken lastToken = (IToken)CollectionUtils.getLast(tokens);
            this.rawEndOffset = offsetTransformer.getUnfilteredOffset(lastToken.getEndOffset());
            this.rawEndLine = rawLineOffsetConverter.getLine(this.rawEndOffset);
        }
        this.artificial = mayBeArtificial && AlignerStatement.decideArtificial(tokens);
    }

    private static boolean decideArtificial(List<IToken> tokens) {
        return tokens.size() <= 2 || CollectionUtils.allMatch(tokens, token -> ARTIFICIAL_TOKEN_TYPES.contains(token.getType()));
    }

    public int getRawStartOffset() {
        return this.rawStartOffset;
    }

    public int getRawEndOffset() {
        return this.rawEndOffset;
    }

    public int getRawStartLine() {
        return this.rawStartLine;
    }

    public int getRawEndLine() {
        return this.rawEndLine;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getNonArtificialStatementIndex() {
        return this.nonArtificialStatementIndex;
    }

    public void setNonArtificialStatementIndex(int nonArtificialStatementIndex) {
        this.nonArtificialStatementIndex = nonArtificialStatementIndex;
    }

    public boolean hasPosition() {
        return this.hasPosition;
    }

    public boolean isArtificial() {
        return this.artificial;
    }

    public EAlignerStatementType getStatementType() {
        return this.statementType;
    }

    public String toString() {
        return this.rawStartLine + "-" + this.rawEndLine;
    }
}

