/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.migration.IJsonMigration;
import com.teamscale.core.migration.IJsonMigrator;
import com.teamscale.core.migration.JsonMigrator;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.index.configuration.EAnalysisProfileVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;

public class AnalysisProfileMigrationCollector {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final GlobalStorageSystem globalStorageSystem;

    public AnalysisProfileMigrationCollector(GlobalStorageSystem globalStorageSystem) {
        this.globalStorageSystem = Objects.requireNonNull(globalStorageSystem, "globalStorageSystem");
    }

    public List<List<? extends IJsonMigration>> collectMigrations(String analysisProfileJson, EAnalysisProfileVersion fromVersionExclusive) {
        ArrayList<List<? extends IJsonMigration>> migrations = new ArrayList<List<? extends IJsonMigration>>();
        List<EAnalysisProfileVersion> includedMigrations = AnalysisProfileMigrationCollector.collectProfileVersions(fromVersionExclusive);
        if (includedMigrations.isEmpty()) {
            return migrations;
        }
        String json = analysisProfileJson;
        for (EAnalysisProfileVersion version : includedMigrations) {
            json = this.processVersion(version, json, migrations);
        }
        return migrations;
    }

    private String processVersion(EAnalysisProfileVersion version, String json, List<List<? extends IJsonMigration>> result) {
        try {
            IJsonMigrator migrator = version.getMigrator(json, EAnalysisProfileVersion.context(this.globalStorageSystem));
            if (migrator instanceof JsonMigrator) {
                JsonMigrator jsonMigrator = (JsonMigrator)migrator;
                result.add(new ArrayList(jsonMigrator.getMigrations()));
            }
            json = migrator.migrate(json);
        }
        catch (MigrationException e) {
            this.logger.error("Instance comparison: Error during re-play of migration, ignoring migrations from {}", (Object)version, (Object)e);
        }
        return json;
    }

    private static List<EAnalysisProfileVersion> collectProfileVersions(EAnalysisProfileVersion fromVersionExclusive) {
        List<EAnalysisProfileVersion> values = Arrays.asList(EAnalysisProfileVersion.values());
        return new ArrayList<EAnalysisProfileVersion>(values.subList(fromVersionExclusive.ordinal() + 1, values.size()));
    }
}

