/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dashboard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.KeysOnlyIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.SetMap;
import org.jetbrains.annotations.VisibleForTesting;

@Index(name="dashboard-project-mappings", options={EStorageOption.COMPRESSED, EStorageOption.NO_ROLLBACK})
public class ProjectDashboardsMappingIndex
implements IGlobalIndex {
    protected static final String INDEX_NAME = "dashboard-project-mappings";
    private static final String KEY_SEPARATOR = "#!#";
    private final KeysOnlyIndex delegateIndex;

    public ProjectDashboardsMappingIndex(IStore store) {
        this.delegateIndex = new KeysOnlyIndex(store);
    }

    public void addProjectDashboardMappings(SetMap<UUID, PublicProjectId> dashboardNamesToProjects) throws StorageException {
        ArrayList<String> keys = new ArrayList<String>();
        for (Map.Entry dashboardNameToProjects : dashboardNamesToProjects) {
            keys.addAll(ProjectDashboardsMappingIndex.getKeysForDashboardAndProjects((UUID)dashboardNameToProjects.getKey(), (Set)dashboardNameToProjects.getValue()));
        }
        this.delegateIndex.storeKeys(keys);
    }

    void addProjectDashboardMappings(UUID dashboardId, Set<PublicProjectId> projectsInDashboard) throws StorageException {
        List<String> keys = ProjectDashboardsMappingIndex.getKeysForDashboardAndProjects(dashboardId, projectsInDashboard);
        this.delegateIndex.storeKeys(keys);
    }

    void addProjectDashboardMapping(PublicProjectId projectId, UUID dashboardId) throws StorageException {
        this.addProjectDashboardMappings(dashboardId, Collections.singleton(projectId));
    }

    public Set<UUID> getDashboardsForProject(PublicProjectId projectId) throws StorageException {
        return this.delegateIndex.streamKeysStartingWith(String.valueOf(projectId) + KEY_SEPARATOR).map(rawKey -> ProjectDashboardsMappingIndex.extractDashboardFromKey(rawKey, projectId)).collect(Collectors.toSet());
    }

    private static UUID extractDashboardFromKey(String key, PublicProjectId projectId) {
        return UUID.fromString(key.substring(projectId.toString().length() + KEY_SEPARATOR.length()));
    }

    void removeMappings(UUID dashboardId, Set<PublicProjectId> referencedProjects) throws StorageException {
        this.delegateIndex.removeKeys(ProjectDashboardsMappingIndex.getKeysForDashboardAndProjects(dashboardId, referencedProjects));
    }

    private static List<String> getKeysForDashboardAndProjects(UUID dashboardId, Set<PublicProjectId> projects) {
        return CollectionUtils.map(projects, project -> ProjectDashboardsMappingIndex.buildKey(project, dashboardId));
    }

    private static String buildKey(PublicProjectId projectId, UUID dashboardId) {
        return String.valueOf(projectId) + KEY_SEPARATOR + String.valueOf(dashboardId);
    }

    void removeMappingsForDashboard(UUID dashboardId) throws StorageException {
        List allKeys = this.delegateIndex.listKeys();
        this.delegateIndex.removeKeys(allKeys.stream().filter(key -> key.endsWith(KEY_SEPARATOR + String.valueOf(dashboardId))).collect(Collectors.toList()));
    }

    @VisibleForTesting
    public List<String> listKeys() throws StorageException {
        return this.delegateIndex.listKeys();
    }
}

