/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.sourcecode.util.SourceCodeMessageUtils;
import org.conqat.lib.commons.collections.ListMap;

public class JumpLabelManager {
    public static final String AFTER_JUMP_LABEL_PREFIX = "after\u0000";
    private final Map<String, ControlFlowNode> jumpTargetNodes = new HashMap<String, ControlFlowNode>();
    private final ListMap<String, ControlFlowNode> jumpSourceNodes = new ListMap();
    private static final Logger LOGGER = LogManager.getLogger();
    private final String uniformPath;
    private final Set<String> allLabels = new HashSet<String>();

    public JumpLabelManager(String uniformPath) {
        this.uniformPath = uniformPath;
    }

    public void addJumpTargetNode(String label, ControlFlowNode node) {
        this.jumpTargetNodes.put(label, node);
    }

    public void addJumpNode(ControlFlowNode node, String targetLabel) {
        this.jumpSourceNodes.add((Object)targetLabel, (Object)node);
    }

    public void registerLabel(String labelName) {
        this.allLabels.add(labelName);
    }

    public List<String> getAllLabelsInCurrentFunction() {
        return new ArrayList<String>(this.allLabels);
    }

    public void connectAllNodesAndClear() {
        for (String label : this.jumpSourceNodes.getKeys()) {
            List sources = (List)this.jumpSourceNodes.getCollection((Object)label);
            ControlFlowNode target = this.jumpTargetNodes.get(label);
            if (target == null) {
                LOGGER.warn(SourceCodeMessageUtils.createMessage((String)("Trying to jump to a label that does not exist: " + label), ((ControlFlowNode)sources.get(0)).getTokens(), null) + " in file " + this.uniformPath);
                continue;
            }
            for (ControlFlowNode source : sources) {
                ControlFlowNode.link(source, target);
            }
        }
        this.jumpTargetNodes.clear();
        this.jumpSourceNodes.clear();
    }
}

