/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.filters.cs;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.controlflowgraph.VariableWrite;
import com.teamscale.index.dataflow.controlflowgraph.utils.ControlFlowUtils;
import com.teamscale.index.dataflow.filters.IFalsePositiveFilter;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.jspecify.annotations.Nullable;

public class CsAsyncMethodFilter
implements IFalsePositiveFilter {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public boolean isFiltered(String variable, ControlFlowNode statement, ControlFlowGraph cfg, List<ShallowEntity> fileEntities, TokenElementInfo element) throws ConQATException {
        Optional<ShallowEntity> containingBlock = ControlFlowUtils.getEntityOfStatement(cfg, statement, "method");
        if (containingBlock.isEmpty()) {
            return false;
        }
        if (!TokenStreamUtils.contains((List)containingBlock.get().ownStartTokens(), (ETokenType)ETokenType.ASYNC)) {
            return false;
        }
        return CsAsyncMethodFilter.isIntermediateAwaitStatement(cfg, statement, variable, element.getUniformPath());
    }

    private static boolean isIntermediateAwaitStatement(ControlFlowGraph cfg, ControlFlowNode statement, String variable, String uniformPath) {
        int indexOfLastStatementBefore;
        List<ControlFlowNode> controlFlowNodes = cfg.listDepthFirst();
        List<ControlFlowNode> writingToVar = controlFlowNodes.stream().filter(node -> CsAsyncMethodFilter.hasWrittenToVariable(node, variable)).toList();
        if (writingToVar.isEmpty()) {
            return false;
        }
        ControlFlowNode lastWriter = CsAsyncMethodFilter.getLastStatementBeforeStatement(writingToVar, statement);
        if (lastWriter == null) {
            return false;
        }
        int indexOfLastWriter = controlFlowNodes.indexOf(lastWriter);
        if (indexOfLastWriter > (indexOfLastStatementBefore = controlFlowNodes.indexOf(statement))) {
            LOGGER.error("Found inconsistent control flow graph for {}.", (Object)uniformPath);
            return false;
        }
        List<ControlFlowNode> intermediate = controlFlowNodes.subList(controlFlowNodes.indexOf(lastWriter), controlFlowNodes.indexOf(statement) + 1);
        return intermediate.stream().filter(ControlFlowNode::isAwaitNode).anyMatch(node -> CsAsyncMethodFilter.isVariableUsedInFunctionCall(node, variable));
    }

    private static boolean hasWrittenToVariable(ControlFlowNode node, String variable) {
        List<VariableWrite> writes = node.getReadWriteInfo().getAllWrites();
        return writes.stream().anyMatch(write -> write.getChangedVariable().equals(variable));
    }

    private static @Nullable ControlFlowNode getLastStatementBeforeStatement(List<ControlFlowNode> nodes, ControlFlowNode untilStatement) {
        Optional firstUntilToken = untilStatement.getTokens().stream().findFirst();
        if (firstUntilToken.isEmpty()) {
            return null;
        }
        int untilOffset = ((IToken)firstUntilToken.get()).getOffset();
        return nodes.stream().filter(node -> {
            Optional firstToken = node.getTokens().stream().findFirst();
            return firstToken.map(token -> token.getOffset() < untilOffset).orElse(false);
        }).reduce((first, second) -> second).orElse(null);
    }

    private static boolean isVariableUsedInFunctionCall(ControlFlowNode node, String variable) {
        return node.getTokens().stream().filter(token -> token.getType() == ETokenType.IDENTIFIER).map(IToken::getText).anyMatch(variable::equals);
    }
}

