/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.taintpropagation.analysisglobal;

import com.teamscale.index.configuration.ETaintAnalysisOptions;
import com.teamscale.index.dataflow.taintpropagation.analysisglobal.TaintPathsMap;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.MethodCallInputValueReference;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.MethodCallReference;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.MethodCallReturnValueReference;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.MethodTaintGraph;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.MethodTaintGraphWithPaths;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintAnalysisUtils;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphField;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphParameter;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphReferenceBase;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphSink;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;

public class MethodTaintGraphAnalyzer {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<String, Set<String>> calledMethodsMap;
    private final CommitDescriptor commit;
    private final EnumSet<ETaintAnalysisOptions> options;
    private final int maxPathsBetweenStatements;

    public MethodTaintGraphAnalyzer(Map<String, Set<String>> calledMethodsMap, CommitDescriptor commit, EnumSet<ETaintAnalysisOptions> options, int maxPathsBetweenStatements) {
        this.maxPathsBetweenStatements = maxPathsBetweenStatements;
        this.calledMethodsMap = calledMethodsMap;
        this.commit = commit;
        this.options = options;
    }

    public void processMethodTaintGraph(MethodTaintGraph currentMethodTaintGraph, Map<String, MethodTaintGraphWithPaths> enrichedMethodTaintGraphs) {
        String methodId = currentMethodTaintGraph.getMethodIdentifier();
        try {
            TreeSet<TaintGraphReferenceBase> methodOutReferences = new TreeSet<TaintGraphReferenceBase>(currentMethodTaintGraph.getInfluenceGraph().keySet());
            MethodTaintGraphAnalyzer.assertMethodOutReferenceTypes(methodOutReferences, TaintGraphReferenceBase.EReferenceType.SINK, TaintGraphReferenceBase.EReferenceType.METHOD_CALL_INPUT, TaintGraphReferenceBase.EReferenceType.RETURN_VALUE, TaintGraphReferenceBase.EReferenceType.FIELD, TaintGraphReferenceBase.EReferenceType.PARAMETER);
            TaintPathsMap pathsFromToMap = new TaintPathsMap(this.maxPathsBetweenStatements);
            this.handleMethodCallInputs(currentMethodTaintGraph, enrichedMethodTaintGraphs, methodOutReferences, pathsFromToMap);
            HashMap<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>> influenceMap = new HashMap<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>>();
            for (TaintGraphReferenceBase outReference : methodOutReferences) {
                this.handleMethodOutReference(outReference, currentMethodTaintGraph, enrichedMethodTaintGraphs, pathsFromToMap);
                if (pathsFromToMap.containsPathsTo(outReference)) continue;
                influenceMap.put(outReference, Collections.emptySet());
            }
            influenceMap.putAll(pathsFromToMap.getInfluenceMap());
            enrichedMethodTaintGraphs.put(methodId, new MethodTaintGraphWithPaths(methodId, influenceMap, pathsFromToMap.finalizeAndGetCleanedUnmodifiableMap(), this.commit.getTimestamp()));
            if (TaintAnalysisUtils.detailedTaintAnalysisLoggingEnabled()) {
                LOGGER.debug("\tfinished processing of {}", (Object)methodId);
            }
            if (pathsFromToMap.isPathsThresholdReached()) {
                LOGGER.info("Ignored paths during analysis of method taint graph {} (more than {} paths)", (Object)methodId, (Object)this.maxPathsBetweenStatements);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception while analyzing {}", (Object)methodId, (Object)e);
        }
    }

    private static void assertMethodOutReferenceTypes(Set<TaintGraphReferenceBase> references, TaintGraphReferenceBase.EReferenceType ... allowedTypes) throws AssertionError {
        EnumSet<TaintGraphReferenceBase.EReferenceType> allowedTypesSet = EnumSet.noneOf(TaintGraphReferenceBase.EReferenceType.class);
        allowedTypesSet.addAll(Arrays.asList(allowedTypes));
        CCSMAssert.isFalse((boolean)references.stream().anyMatch(entry -> !allowedTypesSet.contains((Object)entry.getType())), (String)("found some unexpected taint graph reference type in TaintGraph\n " + String.valueOf(references)));
    }

    private void handleMethodOutReference(TaintGraphReferenceBase outReference, MethodTaintGraph currentMethodTaintGraph, Map<String, MethodTaintGraphWithPaths> enrichedMethodTaintGraphs, TaintPathsMap pathsFromToMap) {
        TreeSet<PropagationState> states = new TreeSet<PropagationState>();
        if (currentMethodTaintGraph.getInfluenceGraph().containsKey(outReference)) {
            states.addAll(PropagationState.generateStates((Collection<? extends TaintGraphReferenceBase>)currentMethodTaintGraph.getInfluenceGraph().get(outReference), outReference));
        }
        HashSet<PropagationState> processedStates = new HashSet<PropagationState>();
        while (!states.isEmpty()) {
            PropagationState currentState = Objects.requireNonNull((PropagationState)states.pollFirst());
            if (states.contains(currentState)) {
                CCSMAssert.fail((String)"states still contains the currently processed state!");
            }
            if (pathsFromToMap.containsPathsTo(currentState.influence)) {
                pathsFromToMap.addPath(currentState.toPair(), Collections.emptyList());
                processedStates.add(currentState);
                continue;
            }
            Set<PropagationState> newStates = this.processInfluence(currentMethodTaintGraph, enrichedMethodTaintGraphs, pathsFromToMap, currentState);
            for (PropagationState newState : newStates) {
                if (processedStates.contains(newState)) continue;
                states.add(newState);
            }
            processedStates.add(currentState);
        }
    }

    private Set<PropagationState> processInfluence(MethodTaintGraph currentMethodTaintGraph, Map<String, MethodTaintGraphWithPaths> enrichedMethodTaintGraphs, TaintPathsMap pathsFromToMap, PropagationState state) {
        switch (state.getInfluence().getType()) {
            case METHOD_CALL_RETURN: {
                return this.handleCallReturnReference(state, currentMethodTaintGraph, enrichedMethodTaintGraphs, pathsFromToMap);
            }
            case SOURCE: 
            case RFC_SOURCE: 
            case PARAMETER: {
                if (pathsFromToMap.containsKey(state.toPair())) break;
                pathsFromToMap.addPath(state.toPair(), Collections.emptyList());
                break;
            }
            case FIELD: {
                return MethodTaintGraphAnalyzer.handleField(state, currentMethodTaintGraph, pathsFromToMap);
            }
            case SINK: 
            case RETURN_VALUE: {
                break;
            }
            case METHOD_CALL_INPUT: {
                return MethodTaintGraphAnalyzer.handleMethodCallInputReference(state, currentMethodTaintGraph, pathsFromToMap);
            }
            default: {
                if (!TaintAnalysisUtils.detailedTaintAnalysisLoggingEnabled()) break;
                LOGGER.warn("missed some possible type in TaintAnalysisRunner loop: {}", (Object)state.getClass().getSimpleName());
            }
        }
        return CollectionUtils.emptySet();
    }

    private static Set<PropagationState> handleMethodCallInputReference(PropagationState state, MethodTaintGraph currentMethodTaintGraph, TaintPathsMap pathsFromToMap) {
        CCSMAssert.isInstanceOf((Object)state.getInfluence(), MethodCallInputValueReference.class);
        Set<TaintGraphReferenceBase> influencesOnCallInput = currentMethodTaintGraph.getInfluenceGraph().get(state.getInfluence());
        if (!pathsFromToMap.containsKey(state.toPair())) {
            pathsFromToMap.addPath(state.toPair(), Collections.emptyList());
        }
        if (influencesOnCallInput != null) {
            return PropagationState.generateStates(influencesOnCallInput, state.getInfluence());
        }
        return CollectionUtils.emptySet();
    }

    private static Set<PropagationState> handleField(PropagationState state, MethodTaintGraph currentMethodTaintGraph, TaintPathsMap pathsFromToMap) {
        CCSMAssert.isInstanceOf((Object)state.getInfluence(), TaintGraphField.class);
        Set<TaintGraphReferenceBase> influencesOnField = currentMethodTaintGraph.getInfluenceGraph().get(state.getInfluence());
        if (!pathsFromToMap.containsKey(state.toPair())) {
            pathsFromToMap.addPath(state.toPair(), Collections.emptyList());
        }
        if (influencesOnField != null && !influencesOnField.isEmpty()) {
            return PropagationState.generateStates(influencesOnField, state.getInfluence());
        }
        return CollectionUtils.emptySet();
    }

    private Set<PropagationState> handleCallReturnReference(PropagationState state, MethodTaintGraph currentMethodTaintGraph, Map<String, MethodTaintGraphWithPaths> enrichedMethodTaintGraphs, TaintPathsMap pathsFromToMap) {
        CCSMAssert.isInstanceOf((Object)state.getInfluence(), MethodCallReturnValueReference.class);
        Set<List<TaintGraphReferenceBase>> influencePathsOnMethodCallReturn = this.getInfluencesOnMethodCallReturn((MethodCallReturnValueReference)state.getInfluence(), currentMethodTaintGraph.getMethodIdentifier(), pathsFromToMap, enrichedMethodTaintGraphs);
        HashSet<PropagationState> newStates = new HashSet<PropagationState>();
        for (List<TaintGraphReferenceBase> influencePathOnMethodCallReturn : influencePathsOnMethodCallReturn) {
            Set<TaintGraphReferenceBase> influencesOnInput;
            TaintGraphReferenceBase pathStart = influencePathOnMethodCallReturn.getFirst();
            if (pathStart.getType() != TaintGraphReferenceBase.EReferenceType.METHOD_CALL_INPUT || (influencesOnInput = currentMethodTaintGraph.getInfluenceGraph().get(pathStart)) == null || influencesOnInput.isEmpty()) continue;
            newStates.addAll(PropagationState.generateStates(influencesOnInput, pathStart));
        }
        if (!influencePathsOnMethodCallReturn.isEmpty()) {
            pathsFromToMap.addPath(state.toPair(), Collections.emptyList());
        }
        return newStates;
    }

    private void handleMethodCallInputs(MethodTaintGraph currentMethodTaintGraph, Map<String, MethodTaintGraphWithPaths> enrichedMethodTaintGraphs, Set<TaintGraphReferenceBase> methodOutReferences, TaintPathsMap pathsFromToMap) {
        Set callInputs = methodOutReferences.stream().filter(ref -> ref.getType() == TaintGraphReferenceBase.EReferenceType.METHOD_CALL_INPUT).map(MethodCallInputValueReference.class::cast).collect(Collectors.toCollection(TreeSet::new));
        for (MethodCallInputValueReference callInput : callInputs) {
            Set<List<TaintGraphReferenceBase>> sinkPaths = this.getSinkPathsInfluencedBy(callInput, currentMethodTaintGraph.getMethodIdentifier(), enrichedMethodTaintGraphs);
            for (List sinkPath : sinkPaths.stream().sorted(CollectionUtils.getListComparator()).toList()) {
                TaintGraphSink sink = (TaintGraphSink)CollectionUtils.getLast((List)sinkPath);
                pathsFromToMap.addPath(callInput, sink, sinkPath.subList(0, sinkPath.size() - 1));
            }
            if (!sinkPaths.isEmpty()) continue;
            methodOutReferences.remove(callInput);
        }
    }

    private Set<List<TaintGraphReferenceBase>> getSinkPathsInfluencedBy(MethodCallInputValueReference callInputReference, String currentMethodId, Map<String, MethodTaintGraphWithPaths> enrichedMethodTaintGraphs) {
        HashSet<List<TaintGraphReferenceBase>> sinkPaths = new HashSet<List<TaintGraphReferenceBase>>();
        Set<MethodTaintGraph> calleeGraphs = this.getPossibleCallTargetGraphs(callInputReference.getMethodCallReference(), currentMethodId, enrichedMethodTaintGraphs);
        for (MethodTaintGraph calleeGraph : calleeGraphs) {
            if (calleeGraph == null) continue;
            if (calleeGraph instanceof MethodTaintGraphWithPaths) {
                Set<List<TaintGraphReferenceBase>> influencedCalleeSinkPaths = ((MethodTaintGraphWithPaths)calleeGraph).getSinkPathsDirectlyInfluencedBy(callInputReference);
                sinkPaths.addAll(influencedCalleeSinkPaths);
                continue;
            }
            Set<TaintGraphSink> influencedCalleeSinks = calleeGraph.getSinksDirectlyInfluencedBy(callInputReference);
            for (TaintGraphSink sink : influencedCalleeSinks) {
                sinkPaths.add(Collections.singletonList(sink));
            }
        }
        return sinkPaths;
    }

    private Set<List<TaintGraphReferenceBase>> getInfluencesOnMethodCallReturn(MethodCallReturnValueReference returnValue, String currentMethodId, TaintPathsMap pathsFromToMap, Map<String, MethodTaintGraphWithPaths> enrichedMethodTaintGraphs) {
        TreeSet<List<TaintGraphReferenceBase>> influencePaths = new TreeSet<List<TaintGraphReferenceBase>>(CollectionUtils.getListComparator());
        Set<MethodTaintGraph> calleeGraphs = this.getPossibleCallTargetGraphs(returnValue.getMethodCallReference(), currentMethodId, enrichedMethodTaintGraphs);
        if (!this.options.contains((Object)ETaintAnalysisOptions.ASSUME_UNKNOWN_METHODS_CLEAR_TAINTS) && calleeGraphs.isEmpty()) {
            for (TaintGraphReferenceBase influence : returnValue.getInfluencingParametersIfNoImplementingMethodKnown()) {
                if (influence.getType() == TaintGraphReferenceBase.EReferenceType.METHOD_CALL_INPUT) {
                    ((MethodCallInputValueReference)influence).setCalleeUnknown(true);
                }
                pathsFromToMap.addPath(influence, returnValue, (List<TaintGraphReferenceBase>)CollectionUtils.emptyList());
                influencePaths.add(Collections.singletonList(influence));
            }
        }
        List<MethodTaintGraph> sortedCallees = calleeGraphs.stream().sorted(Comparator.comparing(MethodTaintGraph::getMethodIdentifier)).toList();
        for (MethodTaintGraph calleeGraph : sortedCallees) {
            for (List<TaintGraphReferenceBase> path : MethodTaintGraphAnalyzer.collectInfluencePathsFromCalleeGraph(returnValue, calleeGraph)) {
                pathsFromToMap.addPath(path.getFirst(), returnValue, CollectionUtils.getRest(path));
                influencePaths.add(path);
            }
        }
        return influencePaths;
    }

    private static List<List<TaintGraphReferenceBase>> collectInfluencePathsFromCalleeGraph(MethodCallReturnValueReference returnValue, MethodTaintGraph calleeGraph) {
        HashSet<List<TaintGraphReferenceBase>> influencePaths = new HashSet<List<TaintGraphReferenceBase>>();
        Set<List<TaintGraphReferenceBase>> localInputPaths = MethodTaintGraphAnalyzer.computeLocalInputPaths(returnValue, calleeGraph);
        for (List<TaintGraphReferenceBase> localInputPath : localInputPaths) {
            if (localInputPath.isEmpty()) continue;
            influencePaths.add(localInputPath);
        }
        return influencePaths.stream().sorted(CollectionUtils.getListComparator()).collect(Collectors.toList());
    }

    private static Set<List<TaintGraphReferenceBase>> computeLocalInputPaths(MethodCallReturnValueReference returnValue, MethodTaintGraph calleeGraph) {
        Optional<Set<TaintGraphReferenceBase>> optionalCalleeInfluences = calleeGraph.getDirectReturnValueInfluences(returnValue);
        HashSet<List<TaintGraphReferenceBase>> localInputPaths = new HashSet<List<TaintGraphReferenceBase>>();
        if (optionalCalleeInfluences.isEmpty()) {
            Optional<MethodCallInputValueReference> optionalCallerInputBeforeCall = returnValue.getCallerInputReferenceBeforeCall();
            if (optionalCallerInputBeforeCall.isPresent()) {
                localInputPaths.add(Collections.singletonList((TaintGraphReferenceBase)optionalCallerInputBeforeCall.get()));
            } else {
                localInputPaths.add(Collections.emptyList());
            }
        } else {
            Set<TaintGraphReferenceBase> calleeInfluences = optionalCalleeInfluences.get();
            if (calleeInfluences.isEmpty()) {
                localInputPaths.add(Collections.emptyList());
            } else {
                localInputPaths.addAll(MethodTaintGraphAnalyzer.getCalleePathFromInputsToReturnValue(returnValue, calleeGraph, calleeInfluences));
                CCSMAssert.isTrue((boolean)localInputPaths.stream().allMatch(path -> EnumSet.of(TaintGraphReferenceBase.EReferenceType.METHOD_CALL_INPUT, TaintGraphReferenceBase.EReferenceType.SOURCE, TaintGraphReferenceBase.EReferenceType.RFC_SOURCE).contains((Object)((TaintGraphReferenceBase)path.getFirst()).getType())), (String)"local path does not start with an Input or a Source.");
            }
        }
        return localInputPaths;
    }

    private static Set<List<TaintGraphReferenceBase>> getCalleePathFromInputsToReturnValue(MethodCallReturnValueReference returnValue, MethodTaintGraph calleeGraph, Set<TaintGraphReferenceBase> calleeInfluences) {
        calleeInfluences.removeIf(reference -> reference.getType() == TaintGraphReferenceBase.EReferenceType.RFC_SOURCE);
        HashSet<List<TaintGraphReferenceBase>> localInputPaths = new HashSet<List<TaintGraphReferenceBase>>();
        if (calleeGraph instanceof MethodTaintGraphWithPaths) {
            MethodTaintGraphAnalyzer.getCalleePathFromInputsToReturnValue(returnValue, (MethodTaintGraphWithPaths)calleeGraph, calleeInfluences, localInputPaths);
        } else {
            List<TaintGraphReferenceBase> callerInputs = returnValue.getMethodCallReference().getCallerInputParametersFor(new ArrayList<TaintGraphReferenceBase>(calleeInfluences));
            for (TaintGraphReferenceBase input : callerInputs) {
                ArrayList<TaintGraphReferenceBase> inputPath = new ArrayList<TaintGraphReferenceBase>();
                inputPath.add(input);
                inputPath.add(returnValue);
                localInputPaths.add(inputPath);
            }
        }
        return localInputPaths;
    }

    private static void getCalleePathFromInputsToReturnValue(MethodCallReturnValueReference returnValue, MethodTaintGraphWithPaths calleeGraph, Set<TaintGraphReferenceBase> calleeInfluences, Set<List<TaintGraphReferenceBase>> localInputPaths) {
        Optional<TaintGraphReferenceBase> calleeReferenceToReturnValue = calleeGraph.getLocalReferenceToCallReturnValue(returnValue);
        if (calleeReferenceToReturnValue.isEmpty()) {
            return;
        }
        for (TaintGraphReferenceBase calleeInfluence : calleeInfluences) {
            for (List<TaintGraphReferenceBase> calleePath : calleeGraph.getPathsFromTo(calleeInfluence, calleeReferenceToReturnValue.get())) {
                List<TaintGraphReferenceBase> callerInputs = returnValue.getMethodCallReference().getCallerInputParametersFor(Collections.singletonList(calleeInfluence));
                if (!callerInputs.isEmpty()) {
                    ArrayList<TaintGraphReferenceBase> inputPath = new ArrayList<TaintGraphReferenceBase>();
                    inputPath.add(callerInputs.getFirst());
                    inputPath.addAll(calleePath);
                    localInputPaths.add(inputPath);
                    continue;
                }
                if (calleeInfluence.getType() == TaintGraphReferenceBase.EReferenceType.PARAMETER && ((TaintGraphParameter)calleeInfluence).isOptional()) continue;
                LOGGER.warn("Did not find input reference for {} at call {}", (Object)calleeInfluence, (Object)returnValue.getMethodCallReference());
            }
        }
    }

    private Set<MethodTaintGraph> getPossibleCallTargetGraphs(MethodCallReference methodCallReference, String currentMethodId, Map<String, MethodTaintGraphWithPaths> enrichedMethodTaintGraphs) {
        Set<String> calledMethods = this.calledMethodsMap.get(currentMethodId);
        if (calledMethods == null) {
            LOGGER.debug("found no called methods for {}", (Object)currentMethodId);
            return Collections.emptySet();
        }
        List<Object> targets = calledMethods.stream().filter(calledIdentifier -> calledIdentifier.endsWith(methodCallReference.getCalledMethodIdentifier().toLowerCase())).collect(Collectors.toList());
        if (targets.isEmpty()) {
            targets = calledMethods.stream().filter(calledIdentifier -> calledIdentifier.endsWith("." + methodCallReference.getMethodName().toLowerCase())).toList();
        }
        return targets.stream().map(enrichedMethodTaintGraphs::get).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static class PropagationState
    implements Comparable<PropagationState> {
        private final TaintGraphReferenceBase influence;
        private final TaintGraphReferenceBase influencedReference;

        public PropagationState(TaintGraphReferenceBase influence, TaintGraphReferenceBase influencedReference) {
            this.influence = influence;
            this.influencedReference = influencedReference;
        }

        public TaintGraphReferenceBase getInfluence() {
            return this.influence;
        }

        public TaintGraphReferenceBase getInfluencedReference() {
            return this.influencedReference;
        }

        static Set<PropagationState> generateStates(Collection<? extends TaintGraphReferenceBase> influences, TaintGraphReferenceBase influencedReference) {
            HashSet<PropagationState> states = new HashSet<PropagationState>();
            for (TaintGraphReferenceBase taintGraphReferenceBase : influences) {
                states.add(new PropagationState(taintGraphReferenceBase, influencedReference));
            }
            return states;
        }

        public String toString() {
            return this.toPair().toString();
        }

        private Pair<TaintGraphReferenceBase, TaintGraphReferenceBase> toPair() {
            return new Pair((Object)this.influence, (Object)this.influencedReference);
        }

        @Override
        public int compareTo(PropagationState other) {
            int influencedRefComparison = this.influencedReference.compareTo(other.influencedReference);
            if (influencedRefComparison != 0) {
                return influencedRefComparison;
            }
            return this.influence.compareTo(other.influence);
        }
    }
}

