/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.taintpropagation.analysislocal;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.taintpropagation.analysislocal.TaintInfluenceMap;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.MethodCallInputValueReference;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.MethodCallReference;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintAnalysisUtils;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphField;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphReferenceBase;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableMap;

public class MethodTaintGraphGenerationAnalysisState {
    private Map<String, TaintGraphReferenceBase> currentReferences;
    private ControlFlowNode node;
    private final String methodIdentifier;

    public String getMethodIdentifier() {
        return this.methodIdentifier;
    }

    private MethodTaintGraphGenerationAnalysisState(Map<String, TaintGraphReferenceBase> currentReferences, ControlFlowNode node, String methodIdentifer) {
        this.currentReferences = currentReferences;
        this.node = node;
        this.methodIdentifier = methodIdentifer;
    }

    public MethodTaintGraphGenerationAnalysisState(ControlFlowNode node, String methodIdentifier) {
        this(new HashMap<String, TaintGraphReferenceBase>(), node, methodIdentifier);
    }

    public static MethodTaintGraphGenerationAnalysisState cloneFrom(MethodTaintGraphGenerationAnalysisState other) {
        return new MethodTaintGraphGenerationAnalysisState(new HashMap<String, TaintGraphReferenceBase>(other.currentReferences), other.node, other.methodIdentifier);
    }

    public static MethodTaintGraphGenerationAnalysisState cloneFrom(MethodTaintGraphGenerationAnalysisState other, ControlFlowNode node) {
        MethodTaintGraphGenerationAnalysisState newState = MethodTaintGraphGenerationAnalysisState.cloneFrom(other);
        newState.node = node;
        return newState;
    }

    static MethodTaintGraphGenerationAnalysisState join(List<MethodTaintGraphGenerationAnalysisState> states, TaintInfluenceMap influenceMap) {
        if (states.isEmpty()) {
            return null;
        }
        MethodTaintGraphGenerationAnalysisState joinedState = new MethodTaintGraphGenerationAnalysisState(states.get((int)0).node, states.get((int)0).methodIdentifier);
        for (MethodTaintGraphGenerationAnalysisState inState : states) {
            joinedState.addNewReferences(inState, influenceMap);
        }
        return joinedState;
    }

    public boolean addNewReferences(MethodTaintGraphGenerationAnalysisState inState, TaintInfluenceMap influenceMap) {
        boolean newInfo = false;
        for (Map.Entry<String, TaintGraphReferenceBase> inStateReferenceEntry : inState.currentReferences.entrySet()) {
            TaintGraphReferenceBase inStateCurrentReference = inStateReferenceEntry.getValue();
            if (!this.containsReferenceFor(inStateReferenceEntry.getKey())) {
                newInfo = true;
                this.putReferenceFor(inStateReferenceEntry.getKey(), inStateCurrentReference);
                continue;
            }
            newInfo |= this.joinReferencesWith(inStateReferenceEntry, inStateCurrentReference, influenceMap);
        }
        return newInfo;
    }

    private boolean joinReferencesWith(Map.Entry<String, TaintGraphReferenceBase> inStateReferenceEntry, TaintGraphReferenceBase inStateCurrentReference, TaintInfluenceMap influenceMap) {
        boolean newInfoFromInState = false;
        TaintGraphReferenceBase currentReference = this.getReferenceFor(inStateReferenceEntry.getKey());
        if (!influenceMap.containsInfluenceOn(inStateCurrentReference)) {
            if (influenceMap.containsInfluenceOn(currentReference)) {
                influenceMap.getInfluencesOn(currentReference).add(inStateCurrentReference);
            }
        } else if (!currentReference.equals(inStateCurrentReference) && !influenceMap.isInfluencedByAll(currentReference, influenceMap.getInfluencesOn(inStateCurrentReference))) {
            newInfoFromInState = true;
            if (!(currentReference.getClass().equals(inStateCurrentReference.getClass()) || TaintAnalysisUtils.isFieldOrReturnValueForField(currentReference) && TaintAnalysisUtils.isFieldOrReturnValueForField(inStateCurrentReference))) {
                if (inStateCurrentReference.getType() == TaintGraphReferenceBase.EReferenceType.LOCAL) {
                    this.putReferenceFor(inStateReferenceEntry.getKey(), inStateCurrentReference);
                }
            } else {
                TaintGraphReferenceBase newReference = currentReference.cloneWithNewSSA(this.node.getId() + "_join", null);
                Set<TaintGraphReferenceBase> currentRefInfluences = influenceMap.getInfluencesOrEmpty(currentReference);
                if (currentRefInfluences.isEmpty() && currentReference.getType() == TaintGraphReferenceBase.EReferenceType.PARAMETER) {
                    currentRefInfluences = Collections.singleton(currentReference);
                }
                influenceMap.addInfluenceOn(newReference, currentRefInfluences);
                influenceMap.addInfluenceOn(newReference, influenceMap.getInfluencesOrEmpty(inStateCurrentReference));
                this.putReferenceFor(inStateReferenceEntry.getKey(), newReference);
            }
        }
        return newInfoFromInState;
    }

    public UnmodifiableMap<String, TaintGraphReferenceBase> getUnmodifiableReferenceMap() {
        return CollectionUtils.asUnmodifiable(this.currentReferences);
    }

    public void putReferenceFor(String referenceName, TaintGraphReferenceBase reference) {
        this.currentReferences.put(referenceName, reference);
    }

    public boolean containsReferenceFor(String referenceName) {
        return this.currentReferences.containsKey(referenceName);
    }

    public TaintGraphReferenceBase getReferenceFor(String referenceName) {
        return this.currentReferences.get(referenceName);
    }

    public Set<TaintGraphField> getFieldReferences() {
        return this.currentReferences.entrySet().stream().map(entry -> (TaintGraphReferenceBase)entry.getValue()).filter(reference -> reference.getType() == TaintGraphReferenceBase.EReferenceType.FIELD).map(field -> (TaintGraphField)field).collect(Collectors.toSet());
    }

    public String toString() {
        return String.valueOf(this.currentReferences);
    }

    public int hashCode() {
        return Objects.hash(this.node, this.currentReferences);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MethodTaintGraphGenerationAnalysisState)) {
            return false;
        }
        MethodTaintGraphGenerationAnalysisState other = (MethodTaintGraphGenerationAnalysisState)obj;
        return this.node.equals(other.node) && this.currentReferences.equals(other.currentReferences);
    }

    public Set<MethodCallReference> getMethodCallReferences() {
        return this.currentReferences.values().stream().filter(key -> key.getType() == TaintGraphReferenceBase.EReferenceType.METHOD_CALL_INPUT).map(key -> (MethodCallInputValueReference)key).map(MethodCallInputValueReference::getMethodCallReference).collect(Collectors.toSet());
    }

    public int getCFGNodeId() {
        return this.node.getId();
    }
}

