/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class TypeDependencies
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="type")
    private final String type;
    @JsonProperty(value="dependencies")
    private final Map<String, List<ElementLocation>> dependencies;

    public TypeDependencies(String type, ListMap<String, ElementLocation> dependencies) {
        CCSMAssert.isFalse((boolean)StringUtils.isEmpty((String)type), (String)"type must not be empty");
        CCSMAssert.isNotNull(dependencies);
        this.type = type;
        this.dependencies = new HashMap<String, List<ElementLocation>>();
        for (String dependency : dependencies.getKeys()) {
            this.dependencies.put(dependency, (List)dependencies.getCollection((Object)dependency));
        }
    }

    public String getType() {
        return this.type;
    }

    public UnmodifiableSet<String> getDependencies() {
        return CollectionUtils.asUnmodifiable(this.dependencies.keySet());
    }

    public Map<String, List<ElementLocation>> getDependencyLocations() {
        return new HashMap<String, List<ElementLocation>>(this.dependencies);
    }

    public String toString() {
        return this.type + " -> " + String.valueOf(this.dependencies);
    }
}

