/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies;

import com.teamscale.index.dependencies.ITypeIndex;
import com.teamscale.index.dependencies.TypeIndex;
import com.teamscale.index.dependencies.TypeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.ListMap;
import org.jspecify.annotations.Nullable;

public class TypeIndexCache
implements ITypeIndex {
    private final TypeIndex typeIndex;
    private @Nullable ListMap<String, String> cachedTypeLookupMap = null;
    private @Nullable ListMap<String, String> cachedTypeLookupMapParameterized = null;
    private @Nullable Set<String> cachedAllTypeNames = null;
    private @Nullable Set<String> cachedAllFiles = null;
    private @Nullable Map<String, ? extends TypeInfo> cachedUniformPathToTypesMap = null;
    private @Nullable Map<String, TypeInfo> cachedUniformPathToTypesMapParameterized = null;
    private @Nullable ListMap<String, String> cachedPrefixToFileMap = null;

    public TypeIndexCache(TypeIndex typeIndex) {
        this.typeIndex = typeIndex;
    }

    @Override
    public Set<String> getAllTypeNames() throws StorageException {
        if (this.cachedAllTypeNames == null) {
            this.cachedAllTypeNames = this.typeIndex.getAllTypeNames();
        }
        return this.cachedAllTypeNames;
    }

    @Override
    public ListMap<String, String> getTypeFileLookupMap() throws StorageException {
        if (this.cachedTypeLookupMap == null) {
            this.cachedTypeLookupMap = this.typeIndex.getTypeFileLookupMap();
            this.cachedTypeLookupMapParameterized = new ListMap(this.cachedTypeLookupMap);
        }
        return this.cachedTypeLookupMap;
    }

    @Override
    public List<List<String>> getFilesForTypes(Collection<String> types) throws StorageException {
        if (this.cachedTypeLookupMap != null) {
            ArrayList<List<String>> result = new ArrayList<List<String>>();
            for (String type : types) {
                result.add((List)this.cachedTypeLookupMap.getCollectionOrEmpty((Object)type));
            }
            return result;
        }
        if (this.cachedTypeLookupMapParameterized == null) {
            this.cachedTypeLookupMapParameterized = new ListMap();
            return this.populateTypeLookupCache(types);
        }
        if (this.cachedTypeLookupMapParameterized.getKeys().containsAll(types)) {
            ArrayList<List<String>> result = new ArrayList<List<String>>();
            for (String type : types) {
                result.add((List)this.cachedTypeLookupMapParameterized.getCollectionOrEmpty((Object)type));
            }
            return result;
        }
        return this.populateTypeLookupCache(types);
    }

    private List<List<String>> populateTypeLookupCache(Collection<String> types) throws StorageException {
        List<List<String>> files = this.typeIndex.getFilesForTypes(types);
        List<String> typeList = types.stream().toList();
        for (int i = 0; i < types.size(); ++i) {
            this.cachedTypeLookupMapParameterized.addAll((Object)typeList.get(i), (Collection)files.get(i));
        }
        return files;
    }

    @Override
    public Collection<String> getAllFiles() throws StorageException {
        if (this.cachedAllFiles == null) {
            this.cachedAllFiles = this.typeIndex.getAllFiles();
        }
        return this.cachedAllFiles;
    }

    @Override
    public Collection<String> getFilesWithPathPrefix(String prefix) throws StorageException {
        if (this.cachedPrefixToFileMap == null) {
            this.cachedPrefixToFileMap = new ListMap();
            Collection files = this.typeIndex.getFilesWithPathPrefix(prefix);
            this.cachedPrefixToFileMap.addAll((Object)prefix, files);
            return files;
        }
        if (this.cachedPrefixToFileMap.containsCollection((Object)prefix)) {
            return this.cachedPrefixToFileMap.getCollectionOrEmpty((Object)prefix);
        }
        Collection files = this.typeIndex.getFilesWithPathPrefix(prefix);
        this.cachedPrefixToFileMap.addAll((Object)prefix, files);
        return files;
    }

    @Override
    public Map<String, ? extends TypeInfo> getUniformPathToTypesMap() throws StorageException {
        if (this.cachedUniformPathToTypesMap == null) {
            this.cachedUniformPathToTypesMap = this.typeIndex.getUniformPathToTypesMap();
            this.cachedUniformPathToTypesMapParameterized = new HashMap<String, TypeInfo>(this.cachedUniformPathToTypesMap);
        }
        return this.cachedUniformPathToTypesMap;
    }

    @Override
    public TypeInfo getTypeInfo(String uniformPath) throws StorageException {
        if (this.cachedUniformPathToTypesMap != null) {
            return this.cachedUniformPathToTypesMap.get(uniformPath);
        }
        if (this.cachedUniformPathToTypesMapParameterized == null) {
            TypeInfo typeInfo = this.typeIndex.getTypeInfo(uniformPath);
            this.cachedUniformPathToTypesMapParameterized = new HashMap<String, TypeInfo>();
            this.cachedUniformPathToTypesMapParameterized.put(uniformPath, typeInfo);
            return typeInfo;
        }
        if (this.cachedUniformPathToTypesMapParameterized.containsKey(uniformPath)) {
            return this.cachedUniformPathToTypesMapParameterized.get(uniformPath);
        }
        TypeInfo typeInfo = this.typeIndex.getTypeInfo(uniformPath);
        this.cachedUniformPathToTypesMapParameterized.put(uniformPath, typeInfo);
        return typeInfo;
    }
}

