/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.simulink;

import com.teamscale.index.dependencies.simulink.LazyModelLoader;
import com.teamscale.index.resource.SimulinkDataDictionaryIndex;
import com.teamscale.index.resource.SimulinkModelInfoIndex;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;
import org.conqat.lib.simulink.builder.SimulinkDataDictionaryParser;
import org.conqat.lib.simulink.builder.SimulinkModelBuildingException;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.types.SimulinkDataTypeUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;

public final class SimulinkParsingAndDependencyUtils {
    static String getSimulinkType(String uniformPath) {
        return StringUtils.removeLastPart((String)uniformPath, (char)'.');
    }

    static String getReferencedPath(String blockId, SimulinkModelInfoIndex modelInfoIndex, boolean convertToType) throws StorageException {
        List<String> uniformPaths = modelInfoIndex.getUniformPathsForBlockId(blockId);
        if (uniformPaths.isEmpty()) {
            return null;
        }
        if (convertToType) {
            return SimulinkParsingAndDependencyUtils.getSimulinkType(uniformPaths.get(0));
        }
        return uniformPaths.get(0);
    }

    static List<SimulinkBlock> getNextBlocksOutsideSubSystem(SimulinkBlock outPortInsideSubSystem) {
        String outPortNumber = outPortInsideSubSystem.getParameter("Port");
        SimulinkOutPort correspondingSubSystemOutPort = outPortInsideSubSystem.getParent().getOutPort(outPortNumber);
        if (correspondingSubSystemOutPort == null) {
            return Collections.emptyList();
        }
        UnmodifiableSet propagatedSignals = correspondingSubSystemOutPort.getLines();
        if (propagatedSignals.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<SimulinkBlock> dstBlocks = new ArrayList<SimulinkBlock>();
        for (SimulinkLine signal : propagatedSignals) {
            SimulinkInPort dstPort = signal.getDstPort();
            if (dstPort == null) continue;
            SimulinkBlock dstBlock = dstPort.getBlock();
            if (dstBlock.isOfType("SubSystem")) {
                Optional<SimulinkBlock> nextBlock = SimulinkParsingAndDependencyUtils.getNextBlockInsideSubSystem(signal);
                nextBlock.ifPresent(dstBlocks::add);
                continue;
            }
            dstBlocks.add(dstBlock);
        }
        return dstBlocks;
    }

    static SimulinkBlock getPreviousBlockOutsideSubSystem(SimulinkBlock inPortInsideSubSystem) {
        String inPortNumber = inPortInsideSubSystem.getParameter("Port");
        SimulinkInPort correspondingSubSystemInPort = inPortInsideSubSystem.getParent().getInPort(inPortNumber);
        if (correspondingSubSystemInPort == null) {
            return null;
        }
        SimulinkLine incomingLine = correspondingSubSystemInPort.getLine();
        if (incomingLine == null) {
            return null;
        }
        SimulinkOutPort srcPort = incomingLine.getSrcPort();
        if (srcPort == null) {
            return null;
        }
        SimulinkBlock srcBlock = srcPort.getBlock();
        if (srcBlock.isOfType("SubSystem")) {
            Optional<SimulinkBlock> nextBlock = SimulinkParsingAndDependencyUtils.getPreviousBlockInsideSubSystem(incomingLine);
            return nextBlock.orElse(null);
        }
        return srcBlock;
    }

    static Optional<SimulinkBlock> getNextBlockInsideSubSystem(SimulinkLine signalWithSubSystemDst) {
        SimulinkInPort dstPort = signalWithSubSystemDst.getDstPort();
        if (dstPort == null) {
            return Optional.empty();
        }
        String portIndex = dstPort.getIndex();
        return dstPort.getBlock().getSubBlocks().stream().filter(block -> SimulinkUtils.isInport((SimulinkBlock)block) && Objects.equals(block.getParameter("Port"), portIndex)).findFirst();
    }

    private static Optional<SimulinkBlock> getPreviousBlockInsideSubSystem(SimulinkLine signalWithSubSystemSrc) {
        SimulinkOutPort srcPort = signalWithSubSystemSrc.getSrcPort();
        if (srcPort == null) {
            return Optional.empty();
        }
        String portIndex = srcPort.getIndex();
        return srcPort.getBlock().getSubBlocks().stream().filter(block -> block.isOfType("Outport") && block.getParameter("Port").equals(portIndex)).findFirst();
    }

    static boolean isDisabledLibrary(SimulinkBlock block) {
        return block.isOfType("SubSystem") && !StringUtils.emptyIfNull((String)block.getParameter("AncestorBlock")).isEmpty();
    }

    public static SimulinkDataDictionary parseDataDictionaryFromData(String uniformPath, byte[] bytes) throws IOException, SimulinkModelBuildingException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
            SimulinkDataDictionary simulinkDataDictionary;
            try (SimulinkDataDictionaryParser dictionaryParser = new SimulinkDataDictionaryParser((InputStream)inputStream, uniformPath);){
                simulinkDataDictionary = dictionaryParser.parse();
            }
            return simulinkDataDictionary;
        }
    }

    static SimulinkBlock getBlockReferencedBy(SimulinkBlock referenceBlock, SimulinkModelInfoIndex simulinkModelInfoIndex, LazyModelLoader modelLoader) throws StorageException {
        String referencedModelPath;
        Optional<SimulinkModel> model;
        String sourceBlockId = referenceBlock.getSourceBlockName();
        if (SimulinkParsingAndDependencyUtils.isDisabledLibrary(referenceBlock)) {
            sourceBlockId = referenceBlock.getParameter("AncestorBlock");
        }
        if (sourceBlockId == null) {
            return null;
        }
        if (sourceBlockId.startsWith("$bdroot/")) {
            sourceBlockId = referenceBlock.getReferencedBlockInfo().getBlockName();
        }
        if (!(model = modelLoader.getModelByUniformPath(referencedModelPath = SimulinkParsingAndDependencyUtils.getReferencedPath(sourceBlockId, simulinkModelInfoIndex, false))).isPresent()) {
            return null;
        }
        SimulinkBlock sourceBlock = (SimulinkBlock)model.get();
        String[] sourceBlockPath = sourceBlockId.split("/");
        for (int i = 1; i < sourceBlockPath.length && sourceBlock != null; sourceBlock = sourceBlock.getSubBlock(sourceBlockPath[i]), ++i) {
        }
        return sourceBlock;
    }

    static Set<SimulinkDataDictionaryIndex.ShallowSimulinkBusElement> updatePropagatedSignals(SimulinkBlock busCreatorBlock, Set<SimulinkDataDictionaryIndex.ShallowSimulinkBusElement> signalsFromLibrary, SimulinkDataDictionaryIndex simulinkDataDictionaryIndex) throws StorageException {
        String busName = StringUtils.stripPrefix((String)SimulinkDataTypeUtils.getUnresolvedOutputDataType((SimulinkBlock)busCreatorBlock), (String)"Bus: ").trim();
        List<SimulinkDataDictionaryIndex.ShallowSimulinkBusElement> allowedToPass = null;
        allowedToPass = "Inherit: auto".equals(busName) ? new ArrayList<SimulinkDataDictionaryIndex.ShallowSimulinkBusElement>(signalsFromLibrary) : simulinkDataDictionaryIndex.getSignalsOnBus(busName);
        if (allowedToPass == null || allowedToPass.isEmpty()) {
            signalsFromLibrary.clear();
        } else {
            ArrayList<SimulinkDataDictionaryIndex.ShallowSimulinkBusElement> signalsCopy = new ArrayList<SimulinkDataDictionaryIndex.ShallowSimulinkBusElement>(signalsFromLibrary);
            signalsFromLibrary = allowedToPass.stream().filter(signalsCopy::contains).collect(Collectors.toSet());
        }
        return signalsFromLibrary;
    }

    static String getSignalOutDataTypeForBlock(SimulinkBlock block, String lineSrcPortIndex) {
        String dataType = SimulinkDataTypeUtils.getUnresolvedOutputDataType((SimulinkBlock)block);
        if (block.isOfType("BusSelector")) {
            String signals = block.getParameter("OutputSignals");
            if (signals != null) {
                return signals.split(",")[Integer.parseInt(lineSrcPortIndex) - 1];
            }
        } else if (dataType != null && (!dataType.equals("Inherit: auto") || block.isOfType("Reference"))) {
            return StringUtils.stripPrefix((String)dataType, (String)"Bus: ").trim();
        }
        return null;
    }

    private SimulinkParsingAndDependencyUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

