/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.event_announcement;

import com.teamscale.index.event_announcement.EventAnnouncement;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.date.DateTimeUtils;

@Index(name="event-announcement-index", options={EStorageOption.BACKUP})
public class EventAnnouncementIndex
implements IGlobalIndex {
    private final ValueIndex<EventAnnouncement> delegate;
    private final IStore store;

    public EventAnnouncementIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
        this.store = store;
    }

    public List<EventAnnouncement> getEventAnnouncements() throws StorageException {
        return CollectionUtils.sort((Collection)this.delegate.getAllEntries().getSecondList());
    }

    public List<EventAnnouncement> getCurrentEvents() throws StorageException {
        return CollectionUtils.filter(this.getEventAnnouncements(), announcement -> DateTimeUtils.zonedNow().isBefore(announcement.getEndTime()));
    }

    public void storeEventAnnouncement(EventAnnouncement event) throws StorageException {
        this.delegate.setValue(event.eventId(), (Object)event);
    }

    public void removeEvent(String eventId) throws StorageException {
        this.delegate.removeValue(eventId);
    }

    public void wipeIndex() throws StorageException {
        StorageUtils.clearStore((IStore)this.store);
    }

    public String generateUnusedEventId() throws StorageException {
        int attempts = 15;
        do {
            UUID eventId;
            if (this.delegate.getValue(String.valueOf(eventId = UUID.randomUUID())) != null) continue;
            return eventId.toString();
        } while (--attempts > 0);
        throw new IllegalStateException("Something went wrong trying to generate a new event ID");
    }
}

