/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.tools;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.options.CommandLineBase;
import org.conqat.lib.commons.options.Option;

public class RollbackLoopAnalyzer
extends CommandLineBase<Exception> {
    private static final Pattern COMMITS_PATTERN = Pattern.compile("\\[(?<commits>.+?)\\]");
    private static final Pattern TO_COMMITS_PATTERN = Pattern.compile(" to " + COMMITS_PATTERN.pattern());
    private static final Pattern ROLLBACK_REQUESTED_TO_PATTERN = Pattern.compile("Rollback requested to:$");
    private static final Pattern TO_COMMIT_PATTERN = Pattern.compile(" to\\s+(?<commit>[^\\s]+?)\\s");
    private Path eventLogExportFilePath;
    private int maxCommitsToPrint = 5;

    public static void main(String[] args) throws Exception {
        RollbackLoopAnalyzer.execute(RollbackLoopAnalyzer::new, (String[])args);
    }

    @Option(longName="file-path", shortName=102, description="The path to the event log export file.")
    public void setEventLogExportFilePath(String path) {
        this.eventLogExportFilePath = Paths.get(path, new String[0]);
        if (Files.notExists(this.eventLogExportFilePath, new LinkOption[0])) {
            throw new IllegalArgumentException("Could not find the event log export file: " + String.valueOf(this.eventLogExportFilePath));
        }
    }

    @Option(longName="max-commits", shortName=99, description="The maximum number of commits that are printed as output. Default: 5")
    public void setMaxCommits(int maxCommits) {
        if (maxCommits <= 0) {
            throw new IllegalArgumentException("max-commits must be positive: " + maxCommits);
        }
        this.maxCommitsToPrint = maxCommits;
    }

    protected void run() throws Exception {
        RollbackLoopAnalyzer.exitIfTrue((this.eventLogExportFilePath == null ? 1 : 0) != 0, (String)"You need to provide a log file to analyze!");
        ListMap<CommitDescriptor, String> commitsToLines = this.computeCommitsToLinesMap();
        RollbackLoopAnalyzer.retainRepeatedCommits(commitsToLines);
        ArrayList sortedCommits = CollectionUtils.sort((Collection)commitsToLines.getKeys());
        RollbackLoopAnalyzer.printInfo((String)"Oldest loop commits: ");
        for (CommitDescriptor commitDescriptor : sortedCommits.subList(0, Math.min(this.maxCommitsToPrint, sortedCommits.size()))) {
            RollbackLoopAnalyzer.printInfo((String)String.valueOf(commitDescriptor));
            for (String line : (List)commitsToLines.getCollectionOrEmpty((Object)commitDescriptor)) {
                RollbackLoopAnalyzer.printInfo((String)("\t- " + line));
            }
        }
    }

    private static void retainRepeatedCommits(ListMap<CommitDescriptor, String> commitsToLines) {
        Iterator iterator = commitsToLines.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (((List)entry.getValue()).size() >= 2) continue;
            iterator.remove();
        }
    }

    private ListMap<CommitDescriptor, String> computeCommitsToLinesMap() throws IOException {
        ListMap commitsToLines = new ListMap();
        List<String> lines = Files.readAllLines(this.eventLogExportFilePath);
        for (int i = 0; i < lines.size(); ++i) {
            Pattern pattern = TO_COMMITS_PATTERN;
            String line = lines.get(i);
            Matcher matcher = pattern.matcher(line);
            if (matcher.find()) {
                commitsToLines.addAll(RollbackLoopAnalyzer.extractCommits(line, matcher));
                continue;
            }
            pattern = ROLLBACK_REQUESTED_TO_PATTERN;
            matcher = pattern.matcher(line);
            if (matcher.find() && (matcher = (pattern = COMMITS_PATTERN).matcher(lines.get(i + 1))).find()) {
                commitsToLines.addAll(RollbackLoopAnalyzer.extractCommits(line, matcher));
                continue;
            }
            pattern = TO_COMMIT_PATTERN;
            matcher = pattern.matcher(line);
            if (!matcher.find()) continue;
            String commitString = matcher.group("commit");
            commitsToLines.add((Object)RollbackLoopAnalyzer.parseCommit(commitString), (Object)line);
        }
        return commitsToLines;
    }

    private static CommitDescriptor parseCommit(String commitString) {
        String[] split = commitString.split("@");
        return new CommitDescriptor(split[0], Long.parseLong(split[1]));
    }

    private static ListMap<CommitDescriptor, String> extractCommits(String line, Matcher matcher) {
        ListMap commitsToLines = new ListMap();
        String commitsString = matcher.group("commits");
        Object[] commits = commitsString.split("\\s*,\\s*");
        List commitDescriptors = CollectionUtils.map((Object[])commits, RollbackLoopAnalyzer::parseCommit);
        commitDescriptors.forEach(commit -> commitsToLines.add(commit, (Object)line));
        return commitsToLines;
    }
}

