/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.update;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.index.UniformPathSerializer;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.capability.IAbbreviationStoreCapability;
import org.conqat.engine.persistence.store.util.ConvenientStore;
import org.conqat.engine.persistence.store.util.IStorageAbbreviator;
import org.conqat.engine.persistence.store.util.StorageAbbreviation;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.SetMapCollector;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Index(name="external-metrics-last-update", options={EStorageOption.BRANCHED, EStorageOption.ABBREVIATE_STRINGS}, valueClasses={Long.class})
public class ExternalMetricsLastUpdateIndex
implements IProjectIndex {
    public static final String INDEX_NAME = "external-metrics-last-update";
    private final ConvenientStore store;
    private final IStorageAbbreviator abbreviator;

    public ExternalMetricsLastUpdateIndex(IStore store) {
        this.store = new ConvenientStore(store, false);
        this.abbreviator = ((IAbbreviationStoreCapability)store.getCapability(IAbbreviationStoreCapability.class).orElseThrow()).abbreviator();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void setMetricInPartitionLastUpdated(PairList<PartitionAndPath, String> metricsForPartitionAndPath, long timestamp) throws StorageException {
        int i;
        List<UniformPath> uniformPaths = metricsForPartitionAndPath.getFirstList().stream().map(PartitionAndPath::toUniformPath).toList();
        List<UniformPath> distinctPaths = uniformPaths.stream().distinct().toList();
        List<byte[]> keysAsBytes = this.getKeysForPaths(distinctPaths);
        @Nullable List values = this.store.get(keysAsBytes);
        HashMap<UniformPath, byte[]> entriesByUniformPath = new HashMap<UniformPath, byte[]>();
        for (i = 0; i < values.size(); ++i) {
            if (values.get(i) == null) continue;
            entriesByUniformPath.put(distinctPaths.get(i), (byte[])values.get(i));
        }
        for (i = 0; i < metricsForPartitionAndPath.size(); ++i) {
            String partition = ((PartitionAndPath)metricsForPartitionAndPath.getFirst(i)).getPartition();
            String metricId = (String)metricsForPartitionAndPath.getSecond(i);
            UniformPath uniformPath = uniformPaths.get(i);
            LastUpdateInfo lastUpdateInfo = this.getOrCreateLastUpdateInfo(uniformPath, entriesByUniformPath);
            lastUpdateInfo.setLastUpdate(metricId, partition, timestamp);
            entriesByUniformPath.put(uniformPath, lastUpdateInfo.toByteArray(this.abbreviator));
        }
        PairList entriesToPut = new PairList();
        for (Map.Entry entry : entriesByUniformPath.entrySet()) {
            entriesToPut.add((Object)this.abbreviateSegments((UniformPath)entry.getKey()), (Object)((byte[])entry.getValue()));
        }
        this.store.put(entriesToPut);
    }

    private @NonNull LastUpdateInfo getOrCreateLastUpdateInfo(UniformPath uniformPath, Map<UniformPath, byte[]> entriesByUniformPath) throws StorageException {
        if (!entriesByUniformPath.containsKey(uniformPath)) {
            return new LastUpdateInfo();
        }
        return LastUpdateInfo.fromByteArray(entriesByUniformPath.get(uniformPath), this.abbreviator);
    }

    private List<byte[]> getKeysForPaths(List<UniformPath> distinctPaths) throws StorageException {
        ArrayList<byte[]> keysAsBytes = new ArrayList<byte[]>();
        for (UniformPath path : distinctPaths) {
            byte[] bytes = this.abbreviateSegments(path);
            keysAsBytes.add(bytes);
        }
        return keysAsBytes;
    }

    public void removeDeletedMetrics(SetMap<PartitionAndPath, String> pathToMetricIdsToDelete) throws StorageException {
        List<byte[]> keysForPaths;
        List existingEntries;
        if (pathToMetricIdsToDelete.isEmpty()) {
            return;
        }
        SetMap pathToPartitionInInput = (SetMap)pathToMetricIdsToDelete.getKeys().stream().collect(SetMapCollector.collect(PartitionAndPath::toUniformPath, PartitionAndPath::getPartition));
        ArrayList<UniformPath> inputPaths = new ArrayList<UniformPath>((Collection<UniformPath>)pathToPartitionInInput.getKeys());
        StoreEntriesToUpdateOrRemove updateOrRemove = this.computeEntriesToUpdateOrRemove(pathToMetricIdsToDelete, inputPaths, existingEntries = this.store.get(keysForPaths = this.getKeysForPaths(inputPaths)), (SetMap<UniformPath, String>)pathToPartitionInInput);
        if (!updateOrRemove.keysOfEntriesToRemove().isEmpty()) {
            this.store.remove(updateOrRemove.keysOfEntriesToRemove());
        }
        if (!updateOrRemove.entriesToUpdate().isEmpty()) {
            this.store.put(PairList.fromMap(updateOrRemove.entriesToUpdate()));
        }
    }

    private StoreEntriesToUpdateOrRemove computeEntriesToUpdateOrRemove(SetMap<PartitionAndPath, String> pathToMetricIdsToDelete, List<UniformPath> inputPaths, List<byte @Nullable []> existingEntries, SetMap<UniformPath, String> pathToPartitionInInput) throws StorageException {
        ArrayList<byte[]> keysOfEntriesToRemove = new ArrayList<byte[]>();
        HashMap<byte[], byte[]> entriesToUpdate = new HashMap<byte[], byte[]>();
        for (int i = 0; i < inputPaths.size(); ++i) {
            UniformPath inputPath = inputPaths.get(i);
            byte[] existingEntry = existingEntries.get(i);
            if (existingEntry == null) continue;
            LastUpdateInfo lastUpdateInfo = LastUpdateInfo.fromByteArray(existingEntry, this.abbreviator);
            for (String partition : (Set)pathToPartitionInInput.getCollectionOrElse((Object)inputPath, Collections.emptySet())) {
                Set metricIdsToDelete = (Set)pathToMetricIdsToDelete.getCollectionOrElse((Object)new PartitionAndPath(partition, inputPath), Collections.emptySet());
                metricIdsToDelete.forEach(metricId -> lastUpdateInfo.removeUpdate((String)metricId, partition));
            }
            byte[] currentKey = this.abbreviateSegments(inputPath);
            if (lastUpdateInfo.isEmpty()) {
                keysOfEntriesToRemove.add(currentKey);
                continue;
            }
            entriesToUpdate.put(currentKey, lastUpdateInfo.toByteArray(this.abbreviator));
        }
        return new StoreEntriesToUpdateOrRemove(keysOfEntriesToRemove, entriesToUpdate);
    }

    public void removeEntries(List<MetricIdPathAndPartition> metricIdPathAndPartitionsToDelete) throws StorageException {
        SetMap entriesToDelete = new SetMap();
        metricIdPathAndPartitionsToDelete.forEach(wrapper -> entriesToDelete.add((Object)new PartitionAndPath(wrapper.partition, wrapper.path), (Object)wrapper.metricId));
        this.removeDeletedMetrics((SetMap<PartitionAndPath, String>)entriesToDelete);
    }

    private byte @NonNull [] abbreviateSegments(UniformPath uniformPath) throws StorageException {
        return (byte[])UniformPathSerializer.segmentAbbreviatingSerializer((IStorageAbbreviator)this.abbreviator).serialize((Object)uniformPath);
    }

    public Set<PartitionUpdateEntry> getLastPartitionUpdates(String metricId, UniformPath prefix) throws StorageException {
        PairList entriesStartingWith = this.store.getEntriesStartingWith(this.abbreviateSegments(prefix));
        HashMap<String, Long> oldestUpdateByPartition = new HashMap<String, Long>();
        for (Pair entry2 : entriesStartingWith) {
            LastUpdateInfo valuesForPath = LastUpdateInfo.fromByteArray((byte[])entry2.getSecond(), this.abbreviator);
            for (String partition : valuesForPath.getPartitionsForMetric(metricId)) {
                Long partitionTimestamp = valuesForPath.getTimestamp(metricId, partition);
                if (partitionTimestamp == null) continue;
                oldestUpdateByPartition.merge(partition, partitionTimestamp, Math::min);
            }
        }
        return oldestUpdateByPartition.entrySet().stream().map(entry -> new PartitionUpdateEntry((String)entry.getKey(), (Long)entry.getValue())).collect(Collectors.toSet());
    }

    private static class LastUpdateInfo {
        private final TwoDimHashMap<String, String, PartitionUpdateEntry> metricIdAndPartitionToEntry = new TwoDimHashMap();

        private LastUpdateInfo() {
        }

        private void setLastUpdate(String metricId, String partition, long timestamp) {
            this.metricIdAndPartitionToEntry.putValue((Object)metricId, (Object)partition, (Object)new PartitionUpdateEntry(partition, timestamp));
        }

        private PartitionUpdateEntry getUpdateEntry(String metricId, String partition) {
            return (PartitionUpdateEntry)this.metricIdAndPartitionToEntry.getValue((Object)metricId, (Object)partition);
        }

        private @Nullable Long getTimestamp(String metricId, String partition) {
            PartitionUpdateEntry entry = this.getUpdateEntry(metricId, partition);
            if (entry != null) {
                return entry.timestamp();
            }
            return null;
        }

        private Set<String> getPartitionsForMetric(String metricId) {
            return this.metricIdAndPartitionToEntry.getSecondKeys((Object)metricId);
        }

        private void removeUpdate(String metricId, String partition) {
            this.metricIdAndPartitionToEntry.remove((Object)metricId, (Object)partition);
        }

        private boolean isEmpty() {
            return this.metricIdAndPartitionToEntry.isEmpty();
        }

        private byte[] toByteArray(IStorageAbbreviator abbreviator) throws StorageException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.writeBytes(ByteArrayUtils.intToByteArray((int)this.metricIdAndPartitionToEntry.getFirstKeys().size()));
            for (String metricId : this.metricIdAndPartitionToEntry.getFirstKeys()) {
                byteArrayOutputStream.writeBytes(abbreviator.abbreviate(metricId).toByteArray());
                byteArrayOutputStream.writeBytes(ByteArrayUtils.intToByteArray((int)this.metricIdAndPartitionToEntry.getSecondKeys((Object)metricId).size()));
                for (String partition : this.metricIdAndPartitionToEntry.getSecondKeys((Object)metricId)) {
                    byteArrayOutputStream.writeBytes(abbreviator.abbreviate(partition).toByteArray());
                    byteArrayOutputStream.writeBytes(ByteArrayUtils.longToByteArray((long)this.getUpdateEntry(metricId, partition).timestamp()));
                }
            }
            return byteArrayOutputStream.toByteArray();
        }

        private static LastUpdateInfo fromByteArray(byte[] bytes, IStorageAbbreviator abbreviator) throws StorageException {
            int entries = ByteArrayUtils.readIntFromStartOfArray((byte[])bytes);
            int offset = 4;
            LastUpdateInfo lastUpdateInfo = new LastUpdateInfo();
            for (int i = 0; i < entries; ++i) {
                String metricId = abbreviator.unabbreviate(StorageAbbreviation.readFrom((byte[])bytes, (int)offset));
                int numPartitionEntries = ByteArrayUtils.getIntFromByteArray((byte[])bytes, (int)(offset + 4));
                offset += 8;
                for (int b = 0; b < numPartitionEntries; ++b) {
                    String partition = abbreviator.unabbreviate(StorageAbbreviation.readFrom((byte[])bytes, (int)offset));
                    long timestamp = ByteArrayUtils.getLongFromByteArray((byte[])bytes, (int)(offset + 4));
                    lastUpdateInfo.setLastUpdate(metricId, partition, timestamp);
                    offset += 12;
                }
            }
            return lastUpdateInfo;
        }
    }

    private record StoreEntriesToUpdateOrRemove(List<byte[]> keysOfEntriesToRemove, Map<byte[], byte[]> entriesToUpdate) {
    }

    public record PartitionUpdateEntry(String partition, long timestamp) implements Serializable
    {
    }

    public record MetricIdPathAndPartition(String metricId, UniformPath path, String partition) {
    }
}

