/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings;

import com.google.common.collect.Lists;
import com.teamscale.index.findings.CppIncludeHandler;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.element_details.IncludePathDetail;
import com.teamscale.index.resource.element_details.InitialMacroDefinitionsDetail;
import com.teamscale.index.resource.element_details.TargetTripleElementDetail;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.persistence.store.StorageException;
import org.jspecify.annotations.Nullable;

public record CppToolAnalysisTokenElementDetails(Map<String, IncludePathDetail> includePathDetails, Map<String, InitialMacroDefinitionsDetail> initialMacroDefinitionsDetails, Map<String, TargetTripleElementDetail> targetTripleDetails) {
    public static CppToolAnalysisTokenElementDetails loadDetailsForBasicTokenElements(Collection<BasicTokenElementInfo> elements, TokenElementIndex tokenElementIndex) throws StorageException {
        CppToolAnalysisTokenElementDetails details = new CppToolAnalysisTokenElementDetails(new HashMap<String, IncludePathDetail>(), new HashMap<String, InitialMacroDefinitionsDetail>(), new HashMap<String, TargetTripleElementDetail>());
        List<String> uniformPaths = elements.stream().map(BasicTokenElementInfo::getUniformPath).toList();
        for (List pathsPartition : Lists.partition(uniformPaths, (int)500)) {
            List<TokenElementInfo> tokenElements = tokenElementIndex.getTokenElements(pathsPartition);
            tokenElements.removeIf(Objects::isNull);
            for (TokenElementInfo element : tokenElements) {
                details.addInfoFromElement(element);
            }
        }
        return details;
    }

    public static CppToolAnalysisTokenElementDetails extractFromTokenElements(Collection<TokenElementInfo> elements) {
        CppToolAnalysisTokenElementDetails details = new CppToolAnalysisTokenElementDetails(new HashMap<String, IncludePathDetail>(), new HashMap<String, InitialMacroDefinitionsDetail>(), new HashMap<String, TargetTripleElementDetail>());
        for (TokenElementInfo element : elements) {
            details.addInfoFromElement(element);
        }
        return details;
    }

    public static CppToolAnalysisTokenElementDetails extractFromTokenElement(TokenElementInfo element) {
        CppToolAnalysisTokenElementDetails details = new CppToolAnalysisTokenElementDetails(new HashMap<String, IncludePathDetail>(), new HashMap<String, InitialMacroDefinitionsDetail>(), new HashMap<String, TargetTripleElementDetail>());
        details.addInfoFromElement(element);
        return details;
    }

    private void addInfoFromElement(TokenElementInfo element) {
        Optional targetTripleElementDetail;
        Optional initialMacroDefinitionsDetail;
        Optional<IncludePathDetail> includePathDetail = CppIncludeHandler.getIncludePathDetail(element);
        if (includePathDetail.isPresent()) {
            this.includePathDetails.put(element.getUniformPath(), includePathDetail.get());
        }
        if ((initialMacroDefinitionsDetail = element.getFirstDetailOfType(InitialMacroDefinitionsDetail.class)).isPresent()) {
            this.initialMacroDefinitionsDetails.put(element.getUniformPath(), (InitialMacroDefinitionsDetail)((Object)initialMacroDefinitionsDetail.get()));
        }
        if ((targetTripleElementDetail = element.getFirstDetailOfType(TargetTripleElementDetail.class)).isPresent()) {
            this.targetTripleDetails.put(element.getUniformPath(), (TargetTripleElementDetail)((Object)targetTripleElementDetail.get()));
        }
    }

    public @Nullable IncludePathDetail getIncludePathDetail(String uniformPath) {
        return this.includePathDetails.get(uniformPath);
    }

    public @Nullable InitialMacroDefinitionsDetail getInitialMacroDefinitionsDetail(String uniformPath) {
        return this.initialMacroDefinitionsDetails.get(uniformPath);
    }

    public @Nullable TargetTripleElementDetail getTargetTripleDetail(String uniformPath) {
        return this.targetTripleDetails.get(uniformPath);
    }
}

