/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.calculation;

import com.teamscale.index.findings.calculation.ExcludedFindingsCount;
import com.teamscale.index.findings.calculation.FindingsCalculationInfo;
import com.teamscale.index.findings.calculation.FindingsSummaryCalculator;
import com.teamscale.index.tracking.ExtendedTrackedFinding;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.index.shared.FindingsSummaryInfo;
import org.conqat.engine.persistence.store.StorageException;

public record FilteredFindingsList(List<ExtendedTrackedFinding> filteredFindingsWithoutCategoryFilter, ExcludedFindingsCount excludedFindingsCount, List<ExtendedTrackedFinding> filteredFindings) {
    public static final FilteredFindingsList EMPTY = new FilteredFindingsList(Collections.emptyList(), ExcludedFindingsCount.EMPTY, Collections.emptyList());

    public FindingsSummaryInfo calculateFindingsSummaryInfo(FindingsCalculationInfo calculationInfo) throws StorageException {
        return this.calculateFindingsSummaryInfo(calculationInfo, false, false);
    }

    public FindingsSummaryInfo calculateFindingsSummaryInfo(FindingsCalculationInfo calculationInfo, boolean reportCategoriesWithoutFindings, boolean reportRulesWithoutFindings) throws StorageException {
        return FindingsSummaryCalculator.createFindingsSummary(this.filteredFindingsWithoutCategoryFilter, reportCategoriesWithoutFindings, reportRulesWithoutFindings, calculationInfo);
    }

    public static FilteredFindingsList merge(FilteredFindingsList ... lists) {
        ExcludedFindingsCount mergedExcludedFindingsCount = Arrays.stream(lists).map(FilteredFindingsList::excludedFindingsCount).reduce(ExcludedFindingsCount::merge).orElse(ExcludedFindingsCount.EMPTY);
        List<ExtendedTrackedFinding> mergedFilteredFindingsWithoutCategoryFilter = Arrays.stream(lists).flatMap(list -> list.filteredFindingsWithoutCategoryFilter.stream()).toList();
        List<ExtendedTrackedFinding> mergedFilteredFindings = Arrays.stream(lists).flatMap(list -> list.filteredFindings.stream()).toList();
        return new FilteredFindingsList(mergedFilteredFindingsWithoutCategoryFilter, mergedExcludedFindingsCount, mergedFilteredFindings);
    }
}

