/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.gitbridge.abap;

import com.teamscale.index.repository.sap.abapsystem.SapVersion;
import java.time.Instant;
import java.util.Optional;

public class UpdateResult {
    private final boolean isCoverageDataOutdatedOrMissing;
    private final Instant commitTime;
    private final SapVersion sapVersion;

    public Optional<SapVersion> getSapVersion() {
        return Optional.ofNullable(this.sapVersion);
    }

    public static UpdateResult nothingUpdated() {
        return new UpdateResult(false, null, null);
    }

    public UpdateResult withSapVersion(SapVersion sapVersion) {
        return new UpdateResult(this.isCoverageDataOutdatedOrMissing, this.commitTime, sapVersion);
    }

    public static UpdateResult create(boolean isCoverageDataOutdatedOrMissing, Instant commitTime) {
        return new UpdateResult(isCoverageDataOutdatedOrMissing, commitTime, null);
    }

    public static UpdateResult create(boolean isCoverageDataOutdatedOrMissing) {
        return new UpdateResult(isCoverageDataOutdatedOrMissing, null, null);
    }

    public boolean isAnyCommitPerformed() {
        return this.commitTime != null;
    }

    public boolean isCoverageDataOutdatedOrMissing() {
        return this.isCoverageDataOutdatedOrMissing;
    }

    public Optional<Instant> getCommitTime() {
        return Optional.ofNullable(this.commitTime);
    }

    private UpdateResult(boolean isCoverageDataOutdatedOrMissing, Instant commitTime, SapVersion sapVersion) {
        this.isCoverageDataOutdatedOrMissing = isCoverageDataOutdatedOrMissing;
        this.commitTime = commitTime;
        this.sapVersion = sapVersion;
    }
}

