/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.rtc;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.index.issues.BugTrackerException;
import com.teamscale.index.issues.IssueHistoryIndex;
import com.teamscale.index.issues.IssueIndex;
import com.teamscale.index.issues.IssueIndexBase;
import com.teamscale.index.issues.IssueTrackerSynchronizerBase;
import com.teamscale.index.issues.rtc.RtcSynchronizerBase;
import com.teamscale.index.issues.rtc.client.model.RtcWorkItem;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;

@AnalysisStep(hints={EAnalysisStepParameter.IGNORE_FOR_ROLLBACK})
public class RtcIssueSynchronizer
extends RtcSynchronizerBase<TeamscaleIssue> {
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private IssueHistoryIndex issueHistoryIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private IssueIndex issueIndex;
    @StepParameter(value="item-type", optional=true)
    private final Set<String> itemTypes = new HashSet<String>();

    public IssueHistoryIndex getIssueHistoryIndex() {
        return this.issueHistoryIndex;
    }

    @Override
    protected IssueIndexBase<TeamscaleIssue> getWorkItemIndex() {
        return this.issueIndex;
    }

    @Override
    protected IssueTrackerSynchronizerBase.WorkItemUpdateResult retrieveUpdatedItems(long lastScanTimestamp, long startTimestamp, long onlyItemsChangedAfterTimestamp) throws BugTrackerException, StorageException {
        try {
            List<RtcWorkItem> workItems = this.client.fetchModifiedWorkItems(new ArrayList<String>(this.projects), Math.max(lastScanTimestamp, onlyItemsChangedAfterTimestamp), (PairList<String, Boolean>)this.customFields, this.getItemTypes(), this.additionalFieldFilter, Collections.emptyList());
            List issues = this.retrieveIssueHistory(workItems, lastScanTimestamp, startTimestamp, Collections.emptyList());
            return this.resultBuilder().addItems(issues).build();
        }
        catch (ServiceCallException e) {
            throw new BugTrackerException("Could not retrieve updated work items", e);
        }
    }

    @Override
    protected TeamscaleIssue createIssue(RtcWorkItem workItem, String connectorId, long overrideModificationTimestamp) {
        return RtcIssueSynchronizer.createTeamscaleIssue(workItem, connectorId, overrideModificationTimestamp);
    }

    public static TeamscaleIssue createTeamscaleIssue(RtcWorkItem workItem, String connectorId, long overrideModificationTimestamp) {
        UnmodifiableList additionalFieldNames = workItem.getAllCustomAttributes().getFirstList();
        UnmodifiableList additionalFieldValues = workItem.getAllCustomAttributes().getSecondList();
        long modificationTimestamp = workItem.getModificationTimestamp();
        if (overrideModificationTimestamp > 0L) {
            modificationTimestamp = overrideModificationTimestamp;
        }
        Pair<String, String> state = workItem.getState();
        return new TeamscaleIssue(new TeamscaleIssueId(connectorId, Long.toString(workItem.getId())), workItem.getSummary(), workItem.getOwner(), workItem.getCreator(), workItem.getDescription(), workItem.getCreationTimestamp(), modificationTimestamp, (String)state.getFirst(), "closed".equals(state.getSecond()), workItem.getHref(), (List)additionalFieldNames, (List)additionalFieldValues, workItem.getParentId());
    }

    @Override
    protected Set<String> getItemTypes() {
        return this.itemTypes;
    }
}

