/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.notifications;

import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.mail.MailNotificationOption;
import com.teamscale.core.mail.MailSender;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.options.ShadowModeOption;
import com.teamscale.core.runtime.impl.rollback.PostRevisionAnalysisTriggerBase;
import com.teamscale.index.notifications.NotificationContext;
import com.teamscale.index.notifications.NotifierBase;
import com.teamscale.index.notifications.findings.FindingsNotifier;
import com.teamscale.index.notifications.metrics.MetricNotifier;
import com.teamscale.index.notifications.project.ProjectNotifier;
import com.teamscale.index.user.UserAliasLookup;
import com.teamscale.wia.WiaUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

public class NotificationTrigger
extends PostRevisionAnalysisTriggerBase {
    private static final Logger LOGGER = LogManager.getLogger();

    public void execute() throws StorageException {
        CommitDescriptor commit = this.jobDescriptor.getSchedulingCommit();
        if (WiaUtils.isWorkItemConnectorCommit((CommitDescriptor)commit)) {
            return;
        }
        LOGGER.debug("Executing NotificationTrigger on commit {}", (Object)commit);
        GlobalStorageSystem globalPartition = this.indexLayer.openGlobalStorageSystem();
        ServerOptionIndex serverOptionIndex = (ServerOptionIndex)globalPartition.openGlobalIndex(ServerOptionIndex.class);
        MailNotificationOption mailOptions = MailSender.getNotificationOption((ServerOptionIndex)serverOptionIndex);
        if (!mailOptions.isMailsActivated || ShadowModeOption.isShadowModeEnabled((GlobalStorageSystem)globalPartition)) {
            LOGGER.debug("Returning from NotificationTrigger silently because it is currently deactivated");
            return;
        }
        NotificationContext notificationContext = NotificationContext.createNotificationContext(this.jobDescriptor, this.indexLayer);
        if (notificationContext != null) {
            this.executeNotifiers(notificationContext);
        }
    }

    private void executeNotifiers(NotificationContext notificationContext) throws StorageException {
        ArrayList<NotifierBase> notifiers = new ArrayList<NotifierBase>();
        UserAliasLookup userAliasLookup = UserAliasLookup.createInstance(this.indexLayer.openGlobalStorageSystem());
        notifiers.add(new FindingsNotifier(notificationContext, userAliasLookup));
        notifiers.add(new ProjectNotifier(notificationContext, userAliasLookup));
        notifiers.add(new MetricNotifier(notificationContext, userAliasLookup));
        for (NotifierBase notifier : notifiers) {
            try {
                notifier.checkRulesAndNotify();
            }
            catch (StorageException e) {
                LOGGER.error("Error while executing notifier", (Throwable)e);
            }
        }
    }

    public boolean canCauseSchedulingConflicts() {
        return false;
    }

    public Set<String> getReadStores() {
        return CollectionUtils.unionSet((Collection)super.getReadStores(), (Collection[])new Collection[]{Arrays.asList("repository-log", "commit-alerts", "finding-churn-list")});
    }

    public ETriggerConcurrency getConcurrency() {
        return ETriggerConcurrency.PARALLEL;
    }
}

