/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.query;

import com.teamscale.index.issues.WorkItemHistoryIndexAggregation;
import com.teamscale.index.query.QueryableEntityUtils;
import com.teamscale.index.query.StoredQueryDescriptor;
import com.teamscale.index.query.StoredQueryIndex;
import com.teamscale.wia.TeamscaleIssue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.conqat.engine.persistence.index.keyed.IKeyedObjectIndex;
import org.conqat.engine.persistence.index.keyed.query.QueryEngine;
import org.conqat.engine.persistence.index.keyed.query.error.ExpectedTypeNotFoundException;
import org.conqat.engine.persistence.index.keyed.query.error.QueryCompilationException;
import org.conqat.engine.persistence.index.keyed.query.error.QueryParsingException;
import org.conqat.engine.persistence.index.keyed.query.lexer.EQueryTokenType;
import org.conqat.engine.persistence.index.keyed.query.lexer.IQueryPreprocessor;
import org.conqat.engine.persistence.index.keyed.query.lexer.QueryToken;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

public class IssueQueryReferencePreprocessor
implements IQueryPreprocessor {
    private static final EQueryTokenType ISSUE_QUERY_KEYWORD = EQueryTokenType.ISSUE_QUERY;
    private static final List<EQueryTokenType> EXPECTED_FORMAT = List.of(ISSUE_QUERY_KEYWORD, EQueryTokenType.PAREN_OPEN, EQueryTokenType.LITERAL, EQueryTokenType.COMMA, EQueryTokenType.LITERAL, EQueryTokenType.PAREN_CLOSE);
    private final QueryableEntityUtils.QueryContext context;

    public IssueQueryReferencePreprocessor(QueryableEntityUtils.QueryContext context) {
        this.context = context;
    }

    public List<QueryToken> preprocessQuery(List<QueryToken> tokens) throws QueryParsingException {
        ArrayList<QueryToken> result = new ArrayList<QueryToken>();
        for (int i = 0; i < tokens.size(); ++i) {
            if (tokens.get(i).getType() == ISSUE_QUERY_KEYWORD) {
                this.verifySyntax(tokens, i);
                QueryToken queryName = tokens.get(i + 2);
                QueryToken fieldName = tokens.get(i + 4);
                try {
                    result.addAll(this.expandNamedQuery(queryName, fieldName, i));
                    i += EXPECTED_FORMAT.size() - 1;
                    continue;
                }
                catch (StorageException e) {
                    throw new QueryParsingException("Failed to expand issue_query: " + queryName.getText(), (Throwable)e, new QueryToken[0]);
                }
            }
            result.add(tokens.get(i));
        }
        return result;
    }

    private void verifySyntax(List<QueryToken> tokens, int index) throws QueryParsingException {
        if (tokens.size() < index + EXPECTED_FORMAT.size()) {
            throw new QueryParsingException("Expected a valid issue_query expression (e.g. issue_query(all, Requirements)), but did not receive a proper query. Expected format: issue_query(<issueQueryName>, <issueFieldName>)", new QueryToken[]{(QueryToken)CollectionUtils.getLast(tokens)});
        }
        for (int i = 0; i < EXPECTED_FORMAT.size(); ++i) {
            QueryToken token = tokens.get(index + i);
            EQueryTokenType expectedToken = EXPECTED_FORMAT.get(i);
            if (token.getType() == expectedToken) continue;
            throw new ExpectedTypeNotFoundException(expectedToken, token);
        }
    }

    private List<QueryToken> expandNamedQuery(QueryToken queryNameToken, QueryToken fieldNameToken, int position) throws StorageException, QueryParsingException {
        ArrayList<QueryToken> result = new ArrayList<QueryToken>();
        result.add(new QueryToken(EQueryTokenType.BRACKET_OPEN, "[", (long)position));
        result.addAll(IssueQueryReferencePreprocessor.getQueryExpansion(queryNameToken, fieldNameToken, position, this.context.withQueryType(StoredQueryIndex.EStoredQueryType.ISSUE).withTimestamp(this.context.getEndTime())));
        result.add(new QueryToken(EQueryTokenType.BRACKET_CLOSE, "]", (long)position));
        return result;
    }

    private static List<QueryToken> getQueryExpansion(QueryToken queryNameToken, QueryToken fieldNameToken, int position, QueryableEntityUtils.QueryContext issueContext) throws StorageException, QueryParsingException {
        StoredQueryDescriptor query = IssueQueryReferencePreprocessor.getQuery(queryNameToken, issueContext);
        IssueQueryReferencePreprocessor.verifyFieldExists(fieldNameToken, issueContext);
        WorkItemHistoryIndexAggregation<TeamscaleIssue> issueAggregation = WorkItemHistoryIndexAggregation.forIssues(issueContext.projectStorageSystem(), HistoryAccessOption.readTimestamp((String)issueContext.branch(), (long)issueContext.endTime()));
        List<String> matchingIssues = IssueQueryReferencePreprocessor.queryIssues(queryNameToken, issueContext, issueAggregation, query);
        List<String> referencedValues = IssueQueryReferencePreprocessor.getReferencedValues(matchingIssues, fieldNameToken.getText(), issueAggregation);
        return referencedValues.stream().map(referencedValue -> new QueryToken(EQueryTokenType.LITERAL, referencedValue, (long)position)).toList();
    }

    private static StoredQueryDescriptor getQuery(QueryToken queryNameToken, QueryableEntityUtils.QueryContext issueContext) throws QueryParsingException, StorageException {
        String queryName = queryNameToken.getText();
        return issueContext.queryIndex().getQuery(queryName).orElseThrow(() -> new QueryParsingException("Issue query \"" + queryName + "\" does not exist.", new QueryToken[]{queryNameToken}));
    }

    private static @NonNull List<String> queryIssues(QueryToken queryName, QueryableEntityUtils.QueryContext issueContext, IKeyedObjectIndex<TeamscaleIssue> issueHistoryIndex, StoredQueryDescriptor query) throws QueryParsingException, StorageException {
        if (issueContext.onlyQueryValidation()) {
            return Collections.emptyList();
        }
        try {
            return QueryEngine.selectIds(issueHistoryIndex, (String)query.getQuery(), (QueryEngine.IQueryContext)issueContext);
        }
        catch (QueryCompilationException e) {
            throw new QueryParsingException("Failed to compile issue_query: " + query.getQuery(), (Throwable)e, new QueryToken[]{queryName});
        }
    }

    private static void verifyFieldExists(QueryToken fieldNameToken, QueryableEntityUtils.QueryContext issueContext) throws StorageException, QueryParsingException {
        UnmodifiableList knownIssueFields = WorkItemHistoryIndexAggregation.forIssues(issueContext.projectStorageSystem(), HistoryAccessOption.readTimestamp((String)issueContext.branch(), (long)issueContext.endTime())).getKnownColumns().getFirstList();
        String fieldName = fieldNameToken.getText();
        if (knownIssueFields.stream().noneMatch(fieldName::equalsIgnoreCase)) {
            throw new QueryParsingException("Unknown issue field \"%s\". Possible values: %s".formatted(fieldName, knownIssueFields), new QueryToken[]{fieldNameToken});
        }
    }

    private static List<@NonNull String> getReferencedValues(List<String> matchingIssues, String referencedField, WorkItemHistoryIndexAggregation<TeamscaleIssue> issueHistoryIndex) throws StorageException {
        ArrayList<String> values = new ArrayList<String>(matchingIssues.size());
        Function valueAccessor = issueHistoryIndex.getDescriber().getValueAccessor(referencedField);
        for (String issueId : matchingIssues) {
            TeamscaleIssue issue = issueHistoryIndex.getById(issueId);
            String value = (String)valueAccessor.apply(issue);
            if (StringUtils.isEmpty((String)value)) continue;
            values.add(value);
        }
        return values;
    }
}

