/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.query;

import com.teamscale.index.query.StoredQueryDescriptor;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.IChangeTrackingIndex;
import org.conqat.engine.persistence.index.IProjectIndexWithDynamicName;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.LastChangeTrackingValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Index(name="(dynamic)", options={EStorageOption.COMPRESSED, EStorageOption.BACKUP, EStorageOption.NO_ROLLBACK})
public class StoredQueryIndex
implements IProjectIndexWithDynamicName,
IChangeTrackingIndex {
    private final LastChangeTrackingValueIndex<StoredQueryDescriptor> delegate;
    private String indexName;

    public StoredQueryIndex(IStore store) {
        this.delegate = new LastChangeTrackingValueIndex(store);
    }

    public static StoredQueryIndex openIndex(ProjectStorageSystem projectStorageSystem, EStoredQueryType storedQueryType) throws StorageException {
        return (StoredQueryIndex)projectStorageSystem.openProjectIndex(StoredQueryIndex.class, storedQueryType.indexName, null);
    }

    public OptionalLong getLastChangeTimestamp() throws StorageException {
        return this.delegate.getLastChangeTimestamp();
    }

    public List<String> getAllQueryNames() throws StorageException {
        return this.delegate.getAllKeys();
    }

    public List<StoredQueryDescriptor> getAllQueries() throws StorageException {
        return this.delegate.getAllEntries().extractSecondList();
    }

    public List<String> getQueryNamesStartingWith(String prefix) throws StorageException {
        return this.delegate.getKeysStartingWith(prefix);
    }

    public Optional<StoredQueryDescriptor> getQuery(String name) throws StorageException {
        return Optional.ofNullable((StoredQueryDescriptor)this.delegate.getValue(name));
    }

    public void storeQuery(StoredQueryDescriptor queryDescriptor) throws StorageException {
        this.delegate.setValue(queryDescriptor.getName(), (Serializable)queryDescriptor);
    }

    public void removeQuery(String queryName) throws StorageException {
        this.delegate.removeValue(queryName);
    }

    public void setName(String indexName) {
        this.indexName = indexName;
    }

    public String getName() {
        return this.indexName;
    }

    public EStoredQueryType getStoredQueryType() {
        return EStoredQueryType.NAME_TO_TYPE.get(this.indexName);
    }

    public static enum EStoredQueryType {
        ISSUE("issue-queries", UniformPath.EType.ISSUE_QUERY),
        TEST("test-queries", UniformPath.EType.TEST_QUERY),
        SPEC_ITEM("spec-item-queries", UniformPath.EType.SPEC_ITEM_QUERY);

        private static final Map<String, EStoredQueryType> NAME_TO_TYPE;
        private final String indexName;
        private final UniformPath.EType uniformPathType;

        private EStoredQueryType(String indexName, UniformPath.EType uniformPathType) {
            this.indexName = indexName;
            this.uniformPathType = uniformPathType;
        }

        public String getIndexName() {
            return this.indexName;
        }

        public UniformPath.EType getUniformPathType() {
            return this.uniformPathType;
        }

        static {
            NAME_TO_TYPE = Arrays.stream(EStoredQueryType.values()).collect(Collectors.toUnmodifiableMap(EStoredQueryType::getIndexName, Function.identity()));
        }
    }
}

