/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.GlobalIndexAccess;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.dependencies.TypeIndex;
import com.teamscale.index.dependencies.TypeIndexCache;
import com.teamscale.index.project.ExternalFindingsGroupDescriptionIndex;
import com.teamscale.index.report.ReportParserFactory;
import com.teamscale.index.report.parser.IAbapScovHandlingParser;
import com.teamscale.index.report.parser.IReportParser;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.resource.BinaryElementIndex;
import com.teamscale.index.resource.ReportContentIndexBase;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementIndexCache;
import com.teamscale.index.resource.TokenElementLineInfoIndex;
import com.teamscale.index.resource.path_lookup.IMatchingPathsLookup;
import com.teamscale.index.resource.path_lookup.PathLookupIndex;
import com.teamscale.index.testgap.abap.AbapScovMethodMappingIndex;
import java.util.concurrent.ExecutionException;
import org.conqat.engine.core.logging.RateLimiting;
import org.conqat.engine.persistence.store.StorageException;

public abstract class AnalysisReportIntegratorBase
extends ChangeProcessorAnalysisStep {
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private PathLookupIndex pathLookupIndex;
    private IMatchingPathsLookup matchingPathsLookup;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TypeIndex typeIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private BasicTokenElementIndex basicTokenElementIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="content")
    protected TokenElementIndex tokenElementIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private TokenElementLineInfoIndex tokenElementLineInfoIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private BinaryElementIndex binaryElementIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private AbapScovMethodMappingIndex mappingIndex;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ExternalFindingsGroupDescriptionIndex externalFindingsGroupDescriptionIndex;
    private final RateLimiting pathLookupRateLimit = new RateLimiting(100);
    private TypeIndexCache typeIndexCache;

    public void execute() throws StorageException, ExecutionException {
        this.matchingPathsLookup = this.pathLookupIndex.createLoggingPreloadedLookup(this.pathLookupRateLimit);
        this.typeIndexCache = new TypeIndexCache(this.typeIndex);
        this.executeReportIntegration();
    }

    protected abstract void executeReportIntegration() throws StorageException, ExecutionException;

    protected IReportParser createAndInitParser(ReportContentIndexBase.ReportContent content, TokenElementIndexCache tokenElementIndexCache, boolean disablePlausibilityCheckForPathMapping) {
        this.pathLookupRateLimit.reset();
        IReportParser parser = ReportParserFactory.createParser(content.format);
        parser.init(this.basicTokenElementIndex, tokenElementIndexCache, this.tokenElementLineInfoIndex, this.binaryElementIndex, this.matchingPathsLookup, this.typeIndexCache, this.externalFindingsGroupDescriptionIndex, content.connectorId, null, disablePlausibilityCheckForPathMapping, (x$0, x$1, x$2) -> this.executeInParallelBatches(x$0, x$1, x$2), null);
        if (parser instanceof IAbapScovHandlingParser) {
            ((IAbapScovHandlingParser)parser).setAbapScovMethodMappingIndex(this.mappingIndex);
        }
        return parser;
    }
}

