/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.result.processor;

import com.google.common.base.Preconditions;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.metrics.MetricsIndex;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.schema.MetricSchemaIndex;
import com.teamscale.core.metrics.schema.MetricSchemaIndexUtils;
import com.teamscale.core.metrics.values.EMetricValueType;
import com.teamscale.index.external.ExternalProcessStepInfo;
import com.teamscale.index.external.result.ExternalAnalysisResultProcessStepInfo;
import com.teamscale.index.external.update.ExternalMetricsLastUpdateIndex;
import com.teamscale.index.external.update.TokenElementIndexesUpdater;
import com.teamscale.index.report.result.processor.ExternalAnalysisResultProcessorBase;
import com.teamscale.index.report.result.processor.ProcessStepPartitionAndPathToMetricIdMappingIndex;
import com.teamscale.index.repository.history.EChangeEntryOrigin;
import com.teamscale.index.repository.history.EElementHistoryChangeType;
import com.teamscale.index.repository.history.ElementHistoryEntry;
import com.teamscale.index.repository.history.ElementHistoryIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.jspecify.annotations.Nullable;

public class ExternalAnalysisResultProcessStepInfoProcessor
extends ExternalAnalysisResultProcessorBase<ExternalAnalysisResultProcessStepInfo> {
    private static final Logger LOGGER = LogManager.getLogger();
    @IndexAccess(value=EIndexAccessMode.READ_WRITE, indexName="process-artifacts")
    private TokenElementIndex processArtifactIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE, indexName="process-metrics")
    private MetricsIndex processMetricsIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="process-metric-schema")
    private MetricSchemaIndex processArtifactSchemaIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ProcessStepPartitionAndPathToMetricIdMappingIndex processStepPartitionAndPathToMetricIdMappingIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ExternalMetricsLastUpdateIndex externalMetricsLastUpdateIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ElementHistoryIndex elementHistoryIndex;
    private final PairList<String, TokenElementInfo> artifactContent = new PairList();
    private final Map<String, PairList<String, Serializable>> customMetricsById = new HashMap<String, PairList<String, Serializable>>();
    private final PairList<PartitionAndPath, String> metricForPartitionAndPath = new PairList();
    private Map<String, MetricDirectorySchemaEntry> schema;

    @Override
    public boolean isRelevantPath(UniformPath uniformPath) {
        return uniformPath.isNonCodePath();
    }

    @Override
    public Class<ExternalAnalysisResultProcessStepInfo> getResultClass() {
        return ExternalAnalysisResultProcessStepInfo.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean extract(String partition, UniformPath uniformPath, ExternalAnalysisResultProcessStepInfo analysisResult, CommitDescriptor resultsCommit, CommitDescriptor resultsForCommit, BasicTokenElementInfo element) {
        ExternalProcessStepInfo processInfo = analysisResult.getData();
        if (processInfo == null) {
            LOGGER.warn("Missing process info for {}", (Object)uniformPath);
            return false;
        }
        TokenElementInfo tokenElementInfo = ExternalAnalysisResultProcessStepInfoProcessor.buildTextElement(uniformPath, processInfo.getDescription());
        PairList<String, TokenElementInfo> pairList = this.artifactContent;
        synchronized (pairList) {
            this.artifactContent.add((Object)uniformPath.toString(), (Object)tokenElementInfo);
        }
        Map<String, Object> customMetrics = processInfo.getAllMetrics();
        if (customMetrics.isEmpty()) {
            return true;
        }
        return this.collectMetricValuesById(customMetrics, this.getOrLoadSchemaFromIndex(), uniformPath, partition);
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }

    private Map<String, MetricDirectorySchemaEntry> getOrLoadSchemaFromIndex() {
        try {
            if (this.schema == null) {
                this.schema = MetricSchemaIndexUtils.readSchema((MetricSchemaIndex)this.processArtifactSchemaIndex);
            }
            return this.schema;
        }
        catch (StorageException e) {
            LOGGER.error("Could not read metric schema", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean collectMetricValuesById(Map<String, Object> customMetrics, Map<String, MetricDirectorySchemaEntry> schema, UniformPath uniformPath, String partition) {
        boolean addedEntries = false;
        for (Map.Entry<String, Object> customMetric : customMetrics.entrySet()) {
            String metricId = customMetric.getKey();
            Object metricValue = customMetric.getValue();
            MetricDirectorySchemaEntry schemaEntry = schema.get(metricId);
            if (schemaEntry == null) {
                LOGGER.warn("Metric must be configured in schema: {}", (Object)metricId);
                continue;
            }
            Serializable serializableValue = ExternalAnalysisResultProcessStepInfoProcessor.ensureSerializableFormat(metricValue, schemaEntry, metricId);
            Map<String, PairList<String, Serializable>> map = this.customMetricsById;
            synchronized (map) {
                this.customMetricsById.computeIfAbsent(metricId, x -> new PairList()).add((Object)uniformPath.toString(), (Object)serializableValue);
            }
            map = this.metricForPartitionAndPath;
            synchronized (map) {
                this.metricForPartitionAndPath.add((Object)new PartitionAndPath(partition, uniformPath.toString()), (Object)metricId);
            }
            addedEntries = true;
        }
        return addedEntries;
    }

    private static TokenElementInfo buildTextElement(UniformPath uniformPath, @Nullable String description) {
        return TokenElementInfo.createWithLocalPreprocessing(uniformPath, ELanguage.TEXT, StringUtils.normalizeLineSeparatorsPlatformIndependent((String)StringUtils.emptyIfNull((String)description)));
    }

    private static Serializable ensureSerializableFormat(Object value, MetricDirectorySchemaEntry schemaEntry, String metricName) throws IllegalStateException {
        Preconditions.checkNotNull((Object)value, (String)"Metric must not be null: %s", (Object)metricName);
        return switch (schemaEntry.getValueType()) {
            default -> throw new MatchException(null, null);
            case EMetricValueType.NUMERIC -> {
                Preconditions.checkState((boolean)(value instanceof Number), (String)"Expected numeric metric: %s", (Object)value);
                yield Double.valueOf(((Number)value).doubleValue());
            }
            case EMetricValueType.ASSESSMENT -> {
                Preconditions.checkState((boolean)(value instanceof Assessment), (String)"Expected assessment metric: %s", (Object)value);
                yield (Assessment)value;
            }
            case EMetricValueType.TIMESTAMP -> throw new IllegalStateException("Timestamp metrics are not supported yet: " + metricName);
            case EMetricValueType.STRING -> throw new IllegalStateException("String metrics are not supported yet: " + metricName);
            case EMetricValueType.COUNTER_SET -> throw new IllegalStateException("Counter set metrics are not supported yet: " + metricName);
            case EMetricValueType.DATE_ONLY -> throw new IllegalStateException("Date-only metrics are not supported yet: " + metricName);
        };
    }

    @Override
    public void persist(CommitDescriptor commit) throws StorageException {
        if (this.artifactContent.isEmpty()) {
            return;
        }
        this.processArtifactIndex.setTokenElements(this.artifactContent);
        for (Map.Entry<String, PairList<String, Serializable>> customMetric : this.customMetricsById.entrySet()) {
            String metricId = customMetric.getKey();
            PairList<String, Serializable> metricValues = customMetric.getValue();
            this.processMetricsIndex.setMetricValues(metricValues, metricId);
        }
        new TokenElementIndexesUpdater(this.processArtifactIndex, this.elementHistoryIndex, EChangeEntryOrigin.EXTERNAL_UPLOAD).calculateAndStoreAddedOrChangedHistory(commit, this.artifactContent);
        this.processStepPartitionAndPathToMetricIdMappingIndex.addPartitionPathToMetricIdMappings(this.metricForPartitionAndPath);
        this.externalMetricsLastUpdateIndex.setMetricInPartitionLastUpdated(this.metricForPartitionAndPath, commit.getTimestamp());
    }

    @Override
    public void processDeleted(Collection<PartitionAndPath> deletedPartitionAndPaths, CommitDescriptor commit) throws StorageException {
        SetMap<PartitionAndPath, String> metricIdsThatNeedToBeDeleted = this.computeMetricIdsThatNeedToBeUpdated();
        this.processStepPartitionAndPathToMetricIdMappingIndex.removeDeletedMetrics(metricIdsThatNeedToBeDeleted);
        this.externalMetricsLastUpdateIndex.removeDeletedMetrics(metricIdsThatNeedToBeDeleted);
        SetMap<String, UniformPath> pathsToDeleteByMetric = ExternalAnalysisResultProcessStepInfoProcessor.computePathsToDeleteByMetric(metricIdsThatNeedToBeDeleted);
        this.deleteMetricsForFilesWithoutUpdates(deletedPartitionAndPaths, pathsToDeleteByMetric);
        for (Map.Entry entry : pathsToDeleteByMetric.entrySet()) {
            this.processMetricsIndex.removeEntriesForUniformPaths((Collection)entry.getValue(), new String[]{(String)entry.getKey()});
        }
        this.removeElementsWithoutAnyMetricsLeft(deletedPartitionAndPaths, commit);
    }

    private void removeElementsWithoutAnyMetricsLeft(Collection<PartitionAndPath> deletedPartitionAndPaths, CommitDescriptor commit) throws StorageException {
        ArrayList<String> deletedProcessInfos = ExternalAnalysisResultProcessStepInfoProcessor.getDeletedProcessInfos(deletedPartitionAndPaths);
        this.processStepPartitionAndPathToMetricIdMappingIndex.removeAllMetricsFor(deletedPartitionAndPaths);
        Set<String> uniformPathsWithValues = this.processStepPartitionAndPathToMetricIdMappingIndex.hasEntriesForUniformPath(deletedProcessInfos);
        deletedProcessInfos.removeIf(uniformPathsWithValues::contains);
        this.processArtifactIndex.removeTokenElements(deletedProcessInfos);
        PairList historyEntriesToAdd = new PairList();
        for (String deletedProcessInfo : deletedProcessInfos) {
            historyEntriesToAdd.add((Object)deletedProcessInfo, (Object)new ElementHistoryEntry(EElementHistoryChangeType.DELETE, commit, EChangeEntryOrigin.EXTERNAL_UPLOAD));
        }
        this.elementHistoryIndex.setHistoryEntries((PairList<String, ElementHistoryEntry>)historyEntriesToAdd);
    }

    private SetMap<PartitionAndPath, String> computeMetricIdsThatNeedToBeUpdated() throws StorageException {
        SetMap<PartitionAndPath, String> metricIdsThatNeedToBeDeleted = this.processStepPartitionAndPathToMetricIdMappingIndex.getMetricIdsByPath((List<PartitionAndPath>)this.metricForPartitionAndPath.getFirstList());
        for (Pair entry : this.metricForPartitionAndPath) {
            metricIdsThatNeedToBeDeleted.remove((Object)((PartitionAndPath)entry.getFirst()), (Object)((String)entry.getSecond()));
        }
        return metricIdsThatNeedToBeDeleted;
    }

    private static SetMap<String, UniformPath> computePathsToDeleteByMetric(SetMap<PartitionAndPath, String> metricIdsThatNeedToBeDeletedByPartitionAndPath) {
        SetMap pathsToDeleteByMetric = new SetMap();
        for (Map.Entry entry : metricIdsThatNeedToBeDeletedByPartitionAndPath.entrySet()) {
            Set metricIdsThatNeedToBeDeleted = (Set)entry.getValue();
            for (String metricId : metricIdsThatNeedToBeDeleted) {
                UniformPath deletedPath = UniformPathCompatibilityUtil.convert((String)((PartitionAndPath)entry.getKey()).getUniformPath());
                pathsToDeleteByMetric.add((Object)metricId, (Object)deletedPath);
            }
        }
        return pathsToDeleteByMetric;
    }

    private static ArrayList<String> getDeletedProcessInfos(Collection<PartitionAndPath> deletedPartitionAndPaths) {
        return deletedPartitionAndPaths.stream().map(PartitionAndPath::toUniformPath).map(UniformPath::toString).distinct().collect(Collectors.toCollection(ArrayList::new));
    }

    private void deleteMetricsForFilesWithoutUpdates(Collection<PartitionAndPath> deletedPartitionAndPaths, SetMap<String, UniformPath> pathsToDeleteByMetric) throws StorageException {
        if (deletedPartitionAndPaths.isEmpty()) {
            return;
        }
        SetMap<PartitionAndPath, String> metricIds = this.processStepPartitionAndPathToMetricIdMappingIndex.getMetricIdsByPath(new ArrayList<PartitionAndPath>(deletedPartitionAndPaths));
        ArrayList<ExternalMetricsLastUpdateIndex.MetricIdPathAndPartition> metricIdPathAndPartitionsToDelete = new ArrayList<ExternalMetricsLastUpdateIndex.MetricIdPathAndPartition>();
        for (Map.Entry entry : metricIds) {
            for (String metricId : (Set)entry.getValue()) {
                pathsToDeleteByMetric.add((Object)metricId, (Object)UniformPathCompatibilityUtil.convert((String)((PartitionAndPath)entry.getKey()).getUniformPath()));
                metricIdPathAndPartitionsToDelete.add(new ExternalMetricsLastUpdateIndex.MetricIdPathAndPartition(metricId, ((PartitionAndPath)entry.getKey()).toUniformPath(), ((PartitionAndPath)entry.getKey()).getPartition()));
            }
        }
        this.externalMetricsLastUpdateIndex.removeEntries(metricIdPathAndPartitionsToDelete);
    }

    @Override
    public void reset() {
        this.artifactContent.clear();
        this.customMetricsById.clear();
        this.metricForPartitionAndPath.clear();
    }
}

