/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.index.repository.CommitResolutionException;
import com.teamscale.index.repository.MergeAncestorExplorer;
import com.teamscale.index.repository.MergeBaseInfo;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class MergeBaseResolver {
    private static final Logger LOGGER = LogManager.getLogger();
    @VisibleForTesting
    public static final long BACKOFF_TIMESPAN = TimeUnit.DAYS.toMillis(7L);
    private final Map<CommitDescriptor, ParentedCommitDescriptor> parentedCommits = new HashMap<CommitDescriptor, ParentedCommitDescriptor>();
    private final MergeAncestorExplorer mergeAncestorExplorer;

    private MergeBaseResolver(MergeAncestorExplorer mergeAncestorExplorer) {
        this.mergeAncestorExplorer = mergeAncestorExplorer;
    }

    public static Optional<MergeBaseInfo> computeMergeBaseInfo(CommitDescriptor inputSourceCommit, CommitDescriptor inputTargetCommit, CommitDescriptorIndex commitIndex) throws StorageException, CommitResolutionException {
        try {
            return MergeBaseResolver.computeMergeBaseInfo(inputSourceCommit, inputTargetCommit, commitIndex, MergeAncestorExplorer.getMergeAncestorExplorerWithAcceptAllFilters());
        }
        catch (RepositoryException e) {
            LOGGER.error("A RepositoryException occurred while computing the MergeBaseInfo without filtering for partial merges.", (Throwable)e);
            return Optional.empty();
        }
    }

    public static Optional<MergeBaseInfo> computeMergeBaseInfo(CommitDescriptor inputSourceCommit, CommitDescriptor inputTargetCommit, CommitDescriptorIndex commitIndex, MergeAncestorExplorer mergeAncestorExplorer) throws StorageException, RepositoryException, CommitResolutionException {
        ParentedCommitDescriptor sourceCommit = MergeBaseResolver.resolveCommit(inputSourceCommit, commitIndex).orElseThrow(() -> new CommitResolutionException(inputSourceCommit));
        ParentedCommitDescriptor targetCommit = MergeBaseResolver.resolveCommit(inputTargetCommit, commitIndex).orElseThrow(() -> new CommitResolutionException(inputTargetCommit));
        MergeBaseResolver mergeBaseResolver = new MergeBaseResolver(mergeAncestorExplorer);
        mergeBaseResolver.loadRelevantCommits(sourceCommit, targetCommit, commitIndex);
        mergeBaseResolver.assertNoCyclesInLoadedCommits();
        return mergeBaseResolver.computeMergeParentInfo((CommitDescriptor)sourceCommit, (CommitDescriptor)targetCommit);
    }

    private static Optional<ParentedCommitDescriptor> resolveCommit(CommitDescriptor commit, CommitDescriptorIndex commitIndex) {
        try {
            Optional firstActualCommitBeforeOrAt = commitIndex.getFirstActualCommitBeforeOrAt(commit, 0L);
            if (firstActualCommitBeforeOrAt.isEmpty()) {
                LOGGER.error("No commit on branch '{}' up to timestamp '{}' could be resolved.", (Object)commit.getBranchName(), (Object)commit.getTimestamp());
            }
            return firstActualCommitBeforeOrAt.flatMap(c -> MergeBaseResolver.getParentedCommit(commitIndex, c));
        }
        catch (StorageException e) {
            LOGGER.error("Could not resolve commit '{}'", (Object)commit, (Object)e);
            return Optional.empty();
        }
    }

    private static Optional<ParentedCommitDescriptor> getParentedCommit(CommitDescriptorIndex commitIndex, CommitDescriptor commit) {
        try {
            ParentedCommitDescriptor resolvedCommit = commitIndex.getCommit(commit);
            if (resolvedCommit == null) {
                LOGGER.error("Could not resolve parented commit for '{}'", (Object)commit);
            }
            return Optional.ofNullable(resolvedCommit);
        }
        catch (StorageException e) {
            LOGGER.error("Could not resolve commit '{}'", (Object)commit, (Object)e);
            return Optional.empty();
        }
    }

    private void assertNoCyclesInLoadedCommits() {
        ArrayList<ParentedCommitDescriptor> cycleCommits = new ArrayList<ParentedCommitDescriptor>();
        for (ParentedCommitDescriptor commit : this.parentedCommits.values()) {
            if (!commit.getParentCommits().stream().anyMatch(parent -> parent.getTimestamp() >= commit.getTimestamp())) continue;
            cycleCommits.add(commit);
        }
        if (!cycleCommits.isEmpty()) {
            CCSMAssert.fail((String)("Computation of merge-base aborted because there is a or more cycle in the commit graph involving these commits: \n" + StringUtils.concat((Iterable)CollectionUtils.map(cycleCommits, ParentedCommitDescriptor::toStringWithParents), (String)"\n")));
        }
    }

    private void loadRelevantCommits(ParentedCommitDescriptor sourceCommit, ParentedCommitDescriptor targetCommit, CommitDescriptorIndex commitIndex) throws StorageException {
        this.parentedCommits.put((CommitDescriptor)sourceCommit, sourceCommit);
        this.parentedCommits.put((CommitDescriptor)targetCommit, targetCommit);
        HashSet<CommitDescriptor> sourceTree = new HashSet<CommitDescriptor>();
        HashSet<CommitDescriptor> targetTree = new HashSet<CommitDescriptor>();
        Set<Object> sourceTreeFrontier = new HashSet<ParentedCommitDescriptor>(Collections.singleton(sourceCommit));
        Set<Object> targetTreeFrontier = new HashSet<ParentedCommitDescriptor>(Collections.singleton(targetCommit));
        while (!sourceTreeFrontier.isEmpty()) {
            if ((sourceTreeFrontier = this.advanceTree(sourceTreeFrontier, sourceTree, MergeBaseResolver.getTimestampOrZeroIfNull(MergeBaseResolver.oldest(targetTreeFrontier)) - BACKOFF_TIMESPAN, commitIndex)).isEmpty()) {
                return;
            }
            targetTreeFrontier = this.advanceTree(targetTreeFrontier, targetTree, MergeBaseResolver.getTimestampOrZeroIfNull(MergeBaseResolver.oldest(sourceTreeFrontier)) - 1L, commitIndex);
            sourceTreeFrontier.removeAll(targetTreeFrontier);
            sourceTreeFrontier.removeAll(targetTree);
        }
    }

    private static long getTimestampOrZeroIfNull(CommitDescriptor commit) {
        if (commit != null) {
            return commit.getTimestamp();
        }
        return 0L;
    }

    private Set<CommitDescriptor> advanceTree(Set<CommitDescriptor> frontierNodes, Set<CommitDescriptor> treeNodes, long breakTimestamp, CommitDescriptorIndex commitIndex) throws StorageException {
        if (breakTimestamp < 0L) {
            breakTimestamp = 0L;
        }
        HashSet<CommitDescriptor> newFrontier = new HashSet<CommitDescriptor>();
        ArrayDeque<CommitDescriptor> worklist = new ArrayDeque<CommitDescriptor>(frontierNodes);
        while (!worklist.isEmpty()) {
            CommitDescriptor frontierNode = (CommitDescriptor)worklist.poll();
            if (treeNodes.contains(frontierNode)) continue;
            treeNodes.add(frontierNode);
            Set<CommitDescriptor> advancedFrontier = this.advanceFrontierNode(frontierNode, breakTimestamp, newFrontier, treeNodes, commitIndex);
            if (advancedFrontier.isEmpty()) {
                newFrontier.add(frontierNode);
            }
            worklist.addAll(advancedFrontier);
        }
        return newFrontier;
    }

    private Set<CommitDescriptor> advanceFrontierNode(CommitDescriptor frontierNode, long breakTimestamp, HashSet<CommitDescriptor> newFrontier, Set<CommitDescriptor> treeNodes, CommitDescriptorIndex commitIndex) throws StorageException {
        HashSet<CommitDescriptor> newWorklistItems = new HashSet<CommitDescriptor>(MergeBaseResolver.getParentsOnOtherBranch(this.cacheParentedCommit(frontierNode, commitIndex)));
        List<ParentedCommitDescriptor> commitsInTimeframe = MergeBaseResolver.getAllCommitsOnBranchExcludingBounds(frontierNode.getBranchName(), breakTimestamp, frontierNode.getTimestamp(), commitIndex);
        if (!commitsInTimeframe.isEmpty()) {
            CommitDescriptor oldestInTimeframe = MergeBaseResolver.oldest(commitsInTimeframe);
            for (ParentedCommitDescriptor commitOnBranch : commitsInTimeframe) {
                this.cacheParentedCommit((CommitDescriptor)commitOnBranch, commitIndex);
                newWorklistItems.addAll(MergeBaseResolver.getParentsOnOtherBranch(commitOnBranch));
                if (commitOnBranch != oldestInTimeframe) {
                    treeNodes.add((CommitDescriptor)commitOnBranch);
                    continue;
                }
                newFrontier.add(oldestInTimeframe);
            }
        } else {
            Optional nextParent = commitIndex.getFirstActualCommitBeforeOrAt(new CommitDescriptor(frontierNode.getBranchName(), frontierNode.getTimestamp() - 1L), 0L);
            if (nextParent.isPresent()) {
                newFrontier.add((CommitDescriptor)nextParent.get());
                newWorklistItems.addAll(MergeBaseResolver.getParentsOnOtherBranch(this.cacheParentedCommit((CommitDescriptor)nextParent.get(), commitIndex)));
            }
        }
        return newWorklistItems;
    }

    private ParentedCommitDescriptor cacheParentedCommit(CommitDescriptor commit, CommitDescriptorIndex commitIndex) throws StorageException {
        ParentedCommitDescriptor storedCommit = this.parentedCommits.get(commit);
        if (storedCommit != null) {
            return storedCommit;
        }
        ParentedCommitDescriptor parentedCommit = commit instanceof ParentedCommitDescriptor ? (ParentedCommitDescriptor)commit : commitIndex.getCommit(commit);
        this.parentedCommits.put(commit, parentedCommit);
        return parentedCommit;
    }

    private static CommitDescriptor oldest(Collection<? extends CommitDescriptor> commits) {
        if (commits.isEmpty()) {
            return null;
        }
        return Collections.min(commits, CommitDescriptor.BY_TIMESTAMP_COMPARATOR);
    }

    private static List<ParentedCommitDescriptor> getAllCommitsOnBranchExcludingBounds(String branchName, long fromTimestamp, long toTimestamp, CommitDescriptorIndex commitIndex) throws StorageException {
        if (++fromTimestamp > --toTimestamp) {
            return Collections.emptyList();
        }
        return commitIndex.getCommits(commitIndex.getAllCommitsOnBranchBetweenInclusive(new CommitDescriptor(branchName, fromTimestamp), new CommitDescriptor(branchName, toTimestamp)));
    }

    private static List<CommitDescriptor> getParentsOnOtherBranch(ParentedCommitDescriptor commit) {
        return CollectionUtils.filter((Collection)commit.getParentCommits(), parent -> !parent.getBranchName().equals(commit.getBranchName()));
    }

    private Optional<MergeBaseInfo> computeMergeParentInfo(CommitDescriptor sourceCommit, CommitDescriptor targetCommit) throws RepositoryException {
        Set<CommitDescriptor> ancestorsOfTarget = this.mergeAncestorExplorer.exploreAncestorsOfTargetCommit(targetCommit, Collections.singleton(sourceCommit), this.parentedCommits);
        Set<CommitDescriptor> ancestorsOfSource = this.mergeAncestorExplorer.exploreAncestorsOfSourceCommit(sourceCommit, ancestorsOfTarget, this.parentedCommits);
        if (!CollectionUtils.anyMatch(ancestorsOfSource, ancestorsOfTarget::contains)) {
            return Optional.empty();
        }
        if (ancestorsOfTarget.contains(sourceCommit) || ancestorsOfSource.size() == 1) {
            return Optional.of(new MergeBaseInfo(sourceCommit, null, null, Collections.emptySet()));
        }
        Set<ParentedCommitDescriptor> ancestorsOfSourceButNotOfTarget = this.getCachedParentedCommits(CollectionUtils.differenceSet(ancestorsOfSource, (Collection[])new Collection[]{ancestorsOfTarget}));
        MergeBaseCommits mergeBase = MergeBaseResolver.computeMergeBase(ancestorsOfSourceButNotOfTarget);
        return Optional.of(new MergeBaseInfo(mergeBase.getMergeBaseCommit(), mergeBase.getBranchPointCommit().orElse(null), mergeBase.getOldestNonMergeChildInSourceHistory().orElse(null), ancestorsOfSourceButNotOfTarget));
    }

    private static MergeBaseCommits computeMergeBase(Set<ParentedCommitDescriptor> ancestorsOfSourceButNotOfTarget) {
        CommitDescriptor mergeBase = CollectionUtils.unionSetAll((Collection)CollectionUtils.map(ancestorsOfSourceButNotOfTarget, ParentedCommitDescriptor::getParentCommits)).stream().filter(commit -> !ancestorsOfSourceButNotOfTarget.contains(commit)).max(CommitDescriptor.BY_TIMESTAMP_COMPARATOR).get();
        Set<ParentedCommitDescriptor> nonMergeChildrenInSourceHistory = MergeBaseResolver.computeNonMergeChildrenOfCommit(mergeBase, ancestorsOfSourceButNotOfTarget);
        Optional oldestNonMergeChildInSourceHistory = nonMergeChildrenInSourceHistory.stream().max(CommitDescriptor.BY_TIMESTAMP_COMPARATOR);
        Optional<CommitDescriptor> branchPoint = MergeBaseResolver.computeBranchPoint(ancestorsOfSourceButNotOfTarget);
        return new MergeBaseCommits(mergeBase, branchPoint.orElse(null), oldestNonMergeChildInSourceHistory.orElse(null));
    }

    private static Optional<CommitDescriptor> computeBranchPoint(Set<ParentedCommitDescriptor> commits) {
        if (commits.isEmpty()) {
            return Optional.empty();
        }
        ParentedCommitDescriptor oldestCommit = Collections.min(commits);
        return Optional.ofNullable(oldestCommit.getFirstParentCommit());
    }

    private static Set<ParentedCommitDescriptor> computeNonMergeChildrenOfCommit(CommitDescriptor spawnCommit, Set<ParentedCommitDescriptor> ancestorsOfSource) {
        HashSet<ParentedCommitDescriptor> nonMergeChildrenInSourceHistory = new HashSet<ParentedCommitDescriptor>();
        HashSet<ParentedCommitDescriptor> processedChildren = new HashSet<ParentedCommitDescriptor>();
        ArrayDeque childrenToProcess = new ArrayDeque(CollectionUtils.filterToSet(ancestorsOfSource, commit -> commit.getParentCommits().contains((Object)spawnCommit)));
        while (!childrenToProcess.isEmpty()) {
            ParentedCommitDescriptor current = (ParentedCommitDescriptor)childrenToProcess.pop();
            if (!processedChildren.add(current)) continue;
            if (current.isMergeCommit()) {
                Set childrenOfCurrent = CollectionUtils.filterToSet(ancestorsOfSource, commit -> commit.getParentCommits().contains((Object)current));
                childrenToProcess.addAll(childrenOfCurrent);
                continue;
            }
            nonMergeChildrenInSourceHistory.add(current);
        }
        return nonMergeChildrenInSourceHistory;
    }

    private Set<ParentedCommitDescriptor> getCachedParentedCommits(HashSet<CommitDescriptor> shallowCommits) {
        HashSet<ParentedCommitDescriptor> fullCommits = new HashSet<ParentedCommitDescriptor>(shallowCommits.size());
        for (CommitDescriptor commit : shallowCommits) {
            ParentedCommitDescriptor fullCommit = this.parentedCommits.get(commit);
            CCSMAssert.isNotNull((Object)fullCommit, (String)("Cache failure for " + String.valueOf(commit)));
            fullCommits.add(fullCommit);
        }
        return fullCommits;
    }

    private static class MergeBaseCommits {
        private final CommitDescriptor mergeBaseCommit;
        private final CommitDescriptor branchPointCommit;
        private final ParentedCommitDescriptor oldestNonMergeChildInSourceHistory;

        private MergeBaseCommits(CommitDescriptor mergeBaseCommit, CommitDescriptor branchPointCommit, ParentedCommitDescriptor oldestNonMergeChildInSourceHistory) {
            this.mergeBaseCommit = mergeBaseCommit;
            this.branchPointCommit = branchPointCommit;
            this.oldestNonMergeChildInSourceHistory = oldestNonMergeChildInSourceHistory;
        }

        private CommitDescriptor getMergeBaseCommit() {
            return this.mergeBaseCommit;
        }

        private Optional<CommitDescriptor> getBranchPointCommit() {
            return Optional.ofNullable(this.branchPointCommit);
        }

        private Optional<ParentedCommitDescriptor> getOldestNonMergeChildInSourceHistory() {
            return Optional.ofNullable(this.oldestNonMergeChildInSourceHistory);
        }
    }
}

