/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.RepositoryNeedsRollbackException;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.index.model.ProjectBranchingConfiguration;
import com.teamscale.core.analysis.trigger.ChangeRetrieverAnalysisStep;
import com.teamscale.core.analysis.trigger.IPreAnnouncingAnalysisStep;
import com.teamscale.core.analysis.trigger.RichCommitDescriptor;
import com.teamscale.core.committree.CommitSchedulingResult;
import com.teamscale.core.committree.CommitTree;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.committree.CommitTreeNode;
import com.teamscale.core.committree.CommitTreeRevision;
import com.teamscale.core.committree.IChangeRetrieverCommitTree;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.index.repository.ERepositoryChangeType;
import com.teamscale.index.repository.FirstCodeCommitIndex;
import com.teamscale.index.repository.IRepositoryConnection;
import com.teamscale.index.repository.RepositoryChangeEntry;
import com.teamscale.index.repository.RepositoryChangeIndex;
import com.teamscale.index.repository.RepositoryChangeInfo;
import com.teamscale.index.repository.RepositoryChangeRetrieverUtils;
import com.teamscale.index.repository.RepositoryChangeSet;
import com.teamscale.index.repository.RepositoryNeedsRescheduleException;
import com.teamscale.index.repository.RepositoryRevisionIndex;
import com.teamscale.index.repository.TimestampAdjustmentIndex;
import com.teamscale.index.repository.base.CommitTreeExpansionResult;
import com.teamscale.index.repository.committree.AdjustAllCommits;
import com.teamscale.index.repository.committree.AdjustAllCommitsToOriginalTimestamp;
import com.teamscale.index.repository.committree.BranchRenamingCommitTreeFacade;
import com.teamscale.index.repository.committree.ICommitTreeNodeAdjuster;
import com.teamscale.index.repository.history.EChangeEntryOrigin;
import com.teamscale.index.repository.status.ProjectConnectorStatus;
import com.teamscale.index.repository.status.ProjectConnectorStatusIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEvent;
import org.conqat.engine.core.cancel.RescheduleRequestedException;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.engine.core.logging.TeamscaleLogAppender;
import org.conqat.engine.core.pattern.StringTransformation;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class RepositoryChangeRetrieverBase
extends ChangeRetrieverAnalysisStep
implements IPreAnnouncingAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String HIDDEN_ELEMENT_CONNECTOR_PARAMETER = "hidden-element-connector";
    public static final String KEEP_EMPTY_COMMITS_PARAMETER = "keep-empty-commits";
    public static final String BRANCH_RENAME_PATTERN_PARAMETER = "branch-rename-pattern";
    public static final UniformPath EMPTY_CHANGES_DUMMY_PATH = UniformPath.ofSegments((String[])new String[]{"###empty###"});
    @IndexAccess(value=EIndexAccessMode.READ_WRITE, indexName="single-repositorychanges")
    private RepositoryChangeIndex localChangeIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    protected CommitDescriptorIndex commitDescriptorIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE, indexName="commit-tree")
    private CommitTreeIndex commitTreeIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private TimestampAdjustmentIndex timestampAdjustmentIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private FirstCodeCommitIndex firstCodeCommitIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private RepositoryRevisionIndex revisionIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    protected MetaIndex projectMetaIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ProjectConnectorStatusIndex connectorStatusIndex;
    private final PairList<RepositoryRevisionIndex.RevisionAndRepository, CommitDescriptor> seenRevisions = new PairList();
    private final List<RepositoryChangeEntry> changeEntriesToAdd = new ArrayList<RepositoryChangeEntry>();
    @StepParameter(value="hidden-element-connector", optional=true)
    protected boolean hiddenElementConnector = false;
    @StepParameter(value="keep-empty-commits", optional=true)
    private boolean keepEmptyCommits = false;
    @StepParameter(value="branch-rename-pattern", optional=true)
    private final PairList<String, String> branchTransformationInput = new PairList();
    private BranchRenamingCommitTreeFacade branchRenamingFacade;
    private IRepositoryConnection repositoryConnection;

    @TestOnly
    protected BranchRenamingCommitTreeFacade getBranchRenamingFacade() {
        return this.branchRenamingFacade;
    }

    @TestOnly
    protected IRepositoryConnection getRepositoryConnection() {
        return this.repositoryConnection;
    }

    public boolean shouldRescheduleOnError() {
        return this.getSchedulingCommit() != null;
    }

    protected CommitDescriptor executeAndReturnCommitResult() throws StorageException, RepositoryNeedsRescheduleException, RescheduleRequestedException {
        CommitDescriptor originalInputCommit = this.getSchedulingCommit();
        LOGGER.atDebug().log("Scheduled with input commit {}", (Object)this.getSchedulingCommit());
        try {
            this.repositoryConnection = this.createRepositoryConnection();
        }
        catch (RepositoryNeedsRescheduleException e) {
            throw e;
        }
        catch (RepositoryException e) {
            LOGGER.atError().withMarker(LoggingUtils.DOWN_CONNECTOR_STATUS).withThrowable((Throwable)e).log("Could not create repository connection: {}", (Object)e.getMessage());
            LOGGER.atError().log("Repository connection not available (probably a problem during initialization). Resetting commit tree commit {}.", (Object)originalInputCommit);
            this.storeConnectorDownStatus(e);
            return this.resetCommitTreeWithOutputCommit(originalInputCommit, new RepositoryNeedsRollbackException[0]);
        }
        return this.retrieveAndReturnChanges(originalInputCommit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommitDescriptor retrieveAndReturnChanges(CommitDescriptor originalInputCommit) throws StorageException, RepositoryNeedsRescheduleException, RescheduleRequestedException {
        this.storeConnectorInitStatus();
        StringTransformation branchTransformation = this.prepareBranchTransformationPattern();
        try {
            this.branchRenamingFacade = new BranchRenamingCommitTreeFacade(branchTransformation, this.commitTreeIndex);
            RichCommitDescriptor outputCommit = this.findAndProcessNextCommitNode(RepositoryChangeRetrieverBase.isHintsOnly(originalInputCommit));
            this.revisionIndex.setProcessedCommits(this.seenRevisions);
            this.localChangeIndex.addChangedFiles(this.changeEntriesToAdd);
            this.setConnectorStatus();
            RichCommitDescriptor richCommitDescriptor = outputCommit;
            return richCommitDescriptor;
        }
        catch (RepositoryNeedsRollbackException e) {
            CommitDescriptor commitDescriptor = this.resetCommitTreeWithOutputCommit(originalInputCommit, e);
            return commitDescriptor;
        }
        catch (RepositoryNeedsRescheduleException | RescheduleRequestedException e) {
            this.storeConnectorWarningStatus((Exception)e);
            throw e;
        }
        catch (RepositoryException e) {
            LOGGER.atError().withMarker(LoggingUtils.DOWN_CONNECTOR_STATUS).withThrowable((Throwable)e).log(e.getMessage());
            this.storeConnectorDownStatus(e);
            CommitDescriptor commitDescriptor = this.resetCommitTreeWithOutputCommit(originalInputCommit, new RepositoryNeedsRollbackException[0]);
            return commitDescriptor;
        }
        catch (Throwable t) {
            LOGGER.atFatal().log("Had a fatal exception that might hint at a systematic bug. This job will be rescheduled, but might fail again!");
            LOGGER.atError().withThrowable(t).log(t.getMessage());
            this.storeConnectorDownStatus(t);
            CommitDescriptor commitDescriptor = this.resetCommitTreeWithOutputCommit(originalInputCommit, new RepositoryNeedsRollbackException[0]);
            return commitDescriptor;
        }
        finally {
            try {
                this.repositoryConnection.close();
            }
            catch (RepositoryException e) {
                LOGGER.atError().withThrowable((Throwable)e).log("Error while closing repository connection: {}", (Object)e.getMessage());
            }
        }
    }

    private static boolean isHintsOnly(CommitDescriptor originalInputCommit) {
        return originalInputCommit == null;
    }

    private void setConnectorStatus() throws StorageException {
        UnmodifiableList errorsAndWarnings = TeamscaleLogAppender.getErrorsAndWarnings();
        if (errorsAndWarnings.isEmpty()) {
            this.storeConnectorUpStatus();
            return;
        }
        Optional connectorDownLog = CollectionUtils.filter((Collection)errorsAndWarnings, log -> log.getMarker() != null && log.getMarker().equals((Object)LoggingUtils.DOWN_CONNECTOR_STATUS)).stream().findFirst();
        if (connectorDownLog.isPresent()) {
            this.storeConnectorDownStatus(this.getConnectionIdentifier(), ((LogEvent)connectorDownLog.get()).getMessage().getFormattedMessage());
            return;
        }
        this.storeConnectorWarningStatus(this.getConnectionIdentifier(), ((LogEvent)errorsAndWarnings.getFirst()).getMessage().getFormattedMessage());
    }

    protected void storeConnectorDownStatus(Throwable t) throws StorageException {
        this.storeConnectorDownStatus(this.getConnectionIdentifier(), "Error fetching new revisions: " + t.getMessage());
    }

    private void storeConnectorDownStatus(String connectionIdentifier, String errorMessage) throws StorageException {
        this.connectorStatusIndex.storeConnectorStatus(connectionIdentifier, ProjectConnectorStatus.EConnectorStatus.ERROR, errorMessage);
    }

    private void storeConnectorInitStatus() throws StorageException {
        this.connectorStatusIndex.storeConnectorStatus(this.getConnectionIdentifier(), ProjectConnectorStatus.EConnectorStatus.INIT, "Analysis not finished.");
    }

    protected void storeConnectorUpStatus() throws StorageException {
        this.connectorStatusIndex.storeConnectorStatus(this.getConnectionIdentifier(), ProjectConnectorStatus.EConnectorStatus.HEALTHY, null);
    }

    private void storeConnectorWarningStatus(Exception e) throws StorageException {
        this.storeConnectorWarningStatus(this.getConnectionIdentifier(), e.getMessage());
    }

    private void storeConnectorWarningStatus(String connectionIdentifier, String warningMessage) throws StorageException {
        this.connectorStatusIndex.storeConnectorStatus(connectionIdentifier, ProjectConnectorStatus.EConnectorStatus.WARNING, warningMessage);
    }

    private StringTransformation prepareBranchTransformationPattern() {
        StringTransformation branchTransformation = new StringTransformation();
        for (int i = 0; i < this.branchTransformationInput.size(); ++i) {
            try {
                branchTransformation.add((String)this.branchTransformationInput.getFirst(i), (String)this.branchTransformationInput.getSecond(i));
                continue;
            }
            catch (ConQATException e) {
                LOGGER.atError().withThrowable((Throwable)e).log("Skipping invalid branch transformation {} -> {}", this.branchTransformationInput.getFirst(i), this.branchTransformationInput.getSecond(i));
            }
        }
        return branchTransformation;
    }

    protected abstract IRepositoryConnection createRepositoryConnection() throws RepositoryException, StorageException;

    protected abstract String getConnectionIdentifier();

    private CommitDescriptor resetCommitTreeWithOutputCommit(CommitDescriptor originalInputCommit, RepositoryNeedsRollbackException ... previousRollbackExceptions) throws StorageException {
        return RepositoryChangeRetrieverUtils.resetCommitTreeWithOutputCommit(originalInputCommit, this.commitTreeIndex, this.branchRenamingFacade, previousRollbackExceptions);
    }

    @VisibleForTesting
    protected RichCommitDescriptor findAndProcessNextCommitNode(boolean hintsOnly) throws RepositoryException, StorageException, RescheduleRequestedException {
        if (hintsOnly) {
            this.branchRenamingFacade.resetLastExpandedTimestamp();
        }
        ICommitTreeExpanderAndTimestampAdjuster commitTreeExpanderAndTimestampAdjuster = new ICommitTreeExpanderAndTimestampAdjuster(this.repositoryConnection::expandCommitTree, this.getCommitTreeNodeAdjuster());
        if (this.branchRenamingFacade.isForceExpansionPending()) {
            RepositoryChangeRetrieverUtils.expandCommitTree(this.branchRenamingFacade, commitTreeExpanderAndTimestampAdjuster);
            commitTreeExpanderAndTimestampAdjuster.adjustTimestamps(this.branchRenamingFacade.getAllRawNodes());
            this.branchRenamingFacade.persist();
        }
        if (hintsOnly) {
            return this.createHintsOnlyCommitResult();
        }
        CommitTreeNode commitTreeNode = RepositoryChangeRetrieverUtils.extractNextCommitTreeNode(this.branchRenamingFacade, this.getSchedulingCommit(), commitTreeExpanderAndTimestampAdjuster, commitTreeExpanderAndTimestampAdjuster, this.repositoryConnection.getPollingIntervalSeconds());
        if (commitTreeNode == null) {
            return this.createHintsOnlyCommitResult();
        }
        if (this.processAndStoreCommit(commitTreeNode)) {
            RichCommitDescriptor resultCommit = RepositoryChangeRetrieverUtils.extractResultCommitAndPersist(commitTreeNode, this.branchRenamingFacade, commitTreeExpanderAndTimestampAdjuster, this.buildSkipOracle(), commitTreeExpanderAndTimestampAdjuster, this.repositoryConnection.getPollingIntervalSeconds());
            if (this.firstCodeCommitIndex.insertCodeCommit((CommitDescriptor)resultCommit)) {
                resultCommit.setScheduleExternalDataTriggers(true);
            }
            return resultCommit;
        }
        RepositoryChangeRetrieverUtils.extractNextCommitTreeNode(this.branchRenamingFacade, null, commitTreeExpanderAndTimestampAdjuster, commitTreeExpanderAndTimestampAdjuster, this.repositoryConnection.getPollingIntervalSeconds());
        return this.createHintsOnlyCommitResult();
    }

    private void updateRepositoryRevisionIndex(Set<ICommitTreeNode> addedNodes) throws RepositoryException {
        PairList pairList = (PairList)addedNodes.stream().filter(node -> node.getAdjustedTimestamp().isPresent()).map(this::createIndexEntryFromNode).collect(PairList.toPairList());
        try {
            this.revisionIndex.setKnownRepositoryCommits((PairList<RepositoryRevisionIndex.RevisionAndRepository, CommitDescriptor>)pairList);
            HashSet activeRevisions = this.branchRenamingFacade.getAllNodes().stream().map(node -> node.getRevision().getRevision()).collect(Collectors.toCollection(HashSet::new));
            this.revisionIndex.setActiveRevisions(this.getConnectionIdentifier(), activeRevisions);
        }
        catch (StorageException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private Pair<RepositoryRevisionIndex.RevisionAndRepository, CommitDescriptor> createIndexEntryFromNode(ICommitTreeNode node) {
        return new Pair((Object)new RepositoryRevisionIndex.RevisionAndRepository(node.getRevision().getRevision(), this.repositoryConnection.getConnectionIdentifier()), (Object)node.getAdjustedCommitDescriptor());
    }

    private ICommitTreeNodeAdjuster getCommitTreeNodeAdjuster() {
        if (this.repositoryConnection.isCodeRepository()) {
            return new AdjustAllCommits(this.timestampAdjustmentIndex);
        }
        return new AdjustAllCommitsToOriginalTimestamp(this.timestampAdjustmentIndex);
    }

    private RichCommitDescriptor createHintsOnlyCommitResult() throws StorageException, RepositoryException {
        CommitSchedulingResult commitSchedulingResult = this.branchRenamingFacade.extractAndUpdateSchedulableCommits(this.buildSkipOracle());
        this.branchRenamingFacade.persist();
        if (commitSchedulingResult.isEmpty()) {
            return null;
        }
        return RichCommitDescriptor.createHintsOnlyDescriptor((CommitSchedulingResult)commitSchedulingResult);
    }

    private Predicate<CommitTreeNode> buildSkipOracle() throws StorageException, RepositoryException {
        ProjectBranchingConfiguration branchingConfiguration = (ProjectBranchingConfiguration)this.projectMetaIndex.getValue(ProjectBranchingConfiguration.class);
        if (branchingConfiguration == null) {
            return x -> false;
        }
        String defaultBranchHeadRevision = this.getLatestRevisionForDefaultBranch();
        return node -> {
            if (node.getRevision().getRevision().equals(defaultBranchHeadRevision)) {
                return false;
            }
            Optional configuration = branchingConfiguration.getBranchConfiguration(node.getBranchName());
            long startTimestamp = configuration.map(ProjectBranchingConfiguration.BranchConfiguration::getStartTimestamp).orElse(0L);
            long timestamp = node.getAdjustedTimestamp().orElse(node.getOriginalTimestamp());
            return timestamp < startTimestamp;
        };
    }

    protected String getLatestRevisionForDefaultBranch() throws StorageException, RepositoryException {
        CommitTree commitTree = this.commitTreeIndex.loadTree();
        return commitTree.getLatestContainedRevisionForBranch(this.projectMetaIndex.getDefaultBranchName()).orElse(null);
    }

    private boolean processAndStoreCommit(CommitTreeNode commitTreeNode) throws RepositoryException, StorageException {
        boolean hadChanges;
        this.addToSeenRevisions(commitTreeNode);
        List<? extends ICommitTreeNode> nonEmptyParents = RepositoryChangeRetrieverUtils.determineNonEmptyParentsIncludingForkInformation((ICommitTreeNode)commitTreeNode, this.repositoryConnection, this.commitDescriptorIndex, this.branchRenamingFacade);
        if (nonEmptyParents.isEmpty()) {
            this.crawlRootCommit(commitTreeNode);
            hadChanges = true;
        } else {
            hadChanges = this.processChanges(commitTreeNode, nonEmptyParents.getFirst());
        }
        if (hadChanges) {
            commitTreeNode.setProcessed();
        } else {
            commitTreeNode.setEmpty();
        }
        return hadChanges;
    }

    private boolean processChanges(CommitTreeNode commitTreeNode, ICommitTreeNode firstNonEmptyParent) throws RepositoryException {
        CommitTreeRevision revision = commitTreeNode.getRevision();
        LOGGER.atInfo().log("Scanning for changes at revision {} in  {}", (Object)revision, (Object)this.repositoryConnection.getLocationDescription());
        RepositoryChangeSet changeSet = RepositoryChangeRetrieverUtils.determineChangeSet((ICommitTreeNode)commitTreeNode, firstNonEmptyParent, this.branchRenamingFacade, this.repositoryConnection);
        if (changeSet == null || changeSet.isEmpty() && !this.shouldKeepEmptyCommit(commitTreeNode)) {
            return false;
        }
        CommitDescriptor commit = new CommitDescriptor(revision.getBranchName(), commitTreeNode.getAdjustedTimestamp().getAsLong());
        changeSet.setCommit(commit);
        ArrayList<RepositoryChangeEntry> entries = new ArrayList<RepositoryChangeEntry>();
        for (String path : changeSet.getChangePaths()) {
            RepositoryChangeInfo changeInfo = changeSet.getChangeInfo(path);
            if (changeInfo.getOriginCommit() != null) {
                changeInfo = new RepositoryChangeInfo(changeInfo.getOriginPath(), new CommitDescriptor(this.branchRenamingFacade.renameBranch(changeInfo.getOriginCommit().getBranchName()), changeInfo.getOriginCommit().getTimestamp()), changeInfo.getChangeType());
            }
            RepositoryChangeEntry entry = new RepositoryChangeEntry(UniformPathCompatibilityUtil.convert((String)path), revision.getRevision(), commit, changeInfo, EChangeEntryOrigin.REPOSITORY_COMMIT);
            entries.add(entry);
        }
        this.ensureEntriesNotEmptyAndAdd(revision, commit, entries);
        return true;
    }

    private void crawlRootCommit(CommitTreeNode commitTreeNode) throws RepositoryException {
        CommitTreeRevision revision = commitTreeNode.getRevision();
        LOGGER.atInfo().log("Performing full crawl on revision {} in repository {}", (Object)revision, (Object)this.repositoryConnection.getConnectionIdentifier());
        CommitDescriptor commit = new CommitDescriptor(revision.getBranchName(), commitTreeNode.getAdjustedTimestamp().getAsLong());
        Set<String> paths = this.repositoryConnection.crawl(this.branchRenamingFacade.unrenameBranch((ICommitTreeNode)commitTreeNode));
        Set entries = paths.stream().map(path -> new RepositoryChangeEntry(UniformPath.parse((String)path), revision.getRevision(), ERepositoryChangeType.ADD, commit, null, null, EChangeEntryOrigin.INITIAL_COMMIT)).collect(Collectors.toSet());
        this.ensureEntriesNotEmptyAndAdd(revision, commit, new ArrayList<RepositoryChangeEntry>(entries));
    }

    private boolean shouldKeepEmptyCommit(CommitTreeNode commitTreeNode) {
        return this.keepEmptyCommits || commitTreeNode.hasParentOnOtherBranch();
    }

    private void ensureEntriesNotEmptyAndAdd(CommitTreeRevision revision, CommitDescriptor commit, List<RepositoryChangeEntry> entries) {
        if (entries.isEmpty()) {
            entries.add(new RepositoryChangeEntry(EMPTY_CHANGES_DUMMY_PATH, revision.getRevision(), ERepositoryChangeType.ADD, commit, EChangeEntryOrigin.INITIAL_COMMIT));
        }
        this.changeEntriesToAdd.addAll(entries);
    }

    private void addToSeenRevisions(CommitTreeNode commitTreeNode) {
        String revision = commitTreeNode.getRevision().getRevision();
        String repositoryIdentifier = this.repositoryConnection.getConnectionIdentifier();
        CommitDescriptor adjustedCommit = commitTreeNode.getAdjustedCommitDescriptor();
        this.seenRevisions.add((Object)new RepositoryRevisionIndex.RevisionAndRepository(revision, repositoryIdentifier), (Object)adjustedCommit);
    }

    private class ICommitTreeExpanderAndTimestampAdjuster
    implements RepositoryChangeRetrieverUtils.ICommitTreeExpansion,
    ICommitTreeNodeAdjuster {
        private final RepositoryChangeRetrieverUtils.ICommitTreeExpansion delegateCommitTreeExpansion;
        private final ICommitTreeNodeAdjuster delegateCommitTreeNodeAdjuster;
        private final Set<ICommitTreeNode> addedNodes = new HashSet<ICommitTreeNode>();

        private ICommitTreeExpanderAndTimestampAdjuster(RepositoryChangeRetrieverUtils.ICommitTreeExpansion delegateCommitTreeExpansion, ICommitTreeNodeAdjuster delegateCommitTreeNodeAdjuster) {
            this.delegateCommitTreeExpansion = delegateCommitTreeExpansion;
            this.delegateCommitTreeNodeAdjuster = delegateCommitTreeNodeAdjuster;
        }

        @Override
        public CommitTreeExpansionResult apply(IChangeRetrieverCommitTree tree) throws RepositoryException, RescheduleRequestedException {
            CommitTreeExpansionResult expansionResult = this.delegateCommitTreeExpansion.apply(tree);
            this.addedNodes.addAll((Collection<ICommitTreeNode>)expansionResult.addedNodes);
            return expansionResult;
        }

        @Override
        public void adjustTimestamps(List<CommitTreeNode> nodes) throws StorageException {
            this.delegateCommitTreeNodeAdjuster.adjustTimestamps(nodes);
            try {
                RepositoryChangeRetrieverBase.this.updateRepositoryRevisionIndex(this.addedNodes);
            }
            catch (RepositoryException e) {
                throw new StorageException((Throwable)e);
            }
        }
    }
}

