/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.teamscale.core.index.CommitAssociatedObjectBase;
import com.teamscale.index.external.status.EExternalAnalysisResultType;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.RepositoryLogFileEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.UniformPathSerializer;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.rollback.IRollbackableIndex;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.capability.IAbbreviationStoreCapability;
import org.conqat.engine.persistence.store.util.IStorageAbbreviator;
import org.conqat.engine.persistence.store.util.KeyValueCollectingCallback;
import org.conqat.engine.persistence.store.util.StorageAbbreviation;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.jetbrains.annotations.TestOnly;

@Index(name="repository-log-file", options={EStorageOption.COMMIT_ISOLATED, EStorageOption.ABBREVIATE_STRINGS}, valueClasses={RepositoryLogFileEntry.class})
public class RepositoryLogFileIndex
extends IndexBase
implements IRollbackableIndex,
IProjectIndex {
    public static final String INDEX_NAME = "repository-log-file";
    private final IStorageAbbreviator abbreviator;
    private final UniformPathSerializer pathSerializer;

    public RepositoryLogFileIndex(IStore store) {
        super(store);
        this.abbreviator = ((IAbbreviationStoreCapability)store.getCapability(IAbbreviationStoreCapability.class).orElseThrow()).abbreviator();
        this.pathSerializer = UniformPathSerializer.fullAbbreviatingSerializer((IStorageAbbreviator)this.abbreviator);
    }

    public void insertEntries(Collection<RepositoryLogFileEntry> entries) throws StorageException {
        if (entries.isEmpty()) {
            return;
        }
        Map<CommitDescriptor, Map<UniformPath, List<RepositoryLogFileEntry>>> grouped = entries.stream().collect(Collectors.groupingBy(CommitAssociatedObjectBase::getCommit, Collectors.groupingBy(RepositoryLogFileEntry::getUniformPath)));
        this.store.performWithLock(() -> {
            PairList insertions = new PairList();
            for (Map.Entry byCommit : grouped.entrySet()) {
                CommitDescriptor commit = (CommitDescriptor)byCommit.getKey();
                for (Map.Entry byPath : ((Map)byCommit.getValue()).entrySet()) {
                    UniformPath path = (UniformPath)byPath.getKey();
                    byte[] key = this.serializeKey(commit, path);
                    Map<ECommitType, RepositoryLogFileEntry> existing = this.deserializeValue(key, this.store.get(key));
                    EnumMap<ECommitType, RepositoryLogFileEntry> merged = new EnumMap<ECommitType, RepositoryLogFileEntry>(ECommitType.class);
                    merged.putAll(existing);
                    ((List)byPath.getValue()).forEach(e -> merged.put(e.getCommitType(), (RepositoryLogFileEntry)((Object)((Object)e))));
                    insertions.add((Object)key, (Object)RepositoryLogFileIndex.serializeValue(merged));
                }
            }
            this.store.put(insertions);
        });
    }

    private byte[] serializeKeyPrefix(CommitDescriptor commit) throws StorageException {
        return ByteArrayUtils.concat((byte[][])new byte[][]{this.abbreviator.abbreviate(commit.getBranchName()).toByteArray(), ByteArrayUtils.longToByteArray((long)commit.getTimestamp())});
    }

    private byte[] serializeKey(CommitDescriptor commit, UniformPath uniformPath) throws StorageException {
        return ByteArrayUtils.concat((byte[][])new byte[][]{this.serializeKeyPrefix(commit), (byte[])this.pathSerializer.serialize((Object)uniformPath)});
    }

    private static byte[] serializeValue(Map<ECommitType, RepositoryLogFileEntry> entries) throws StorageException {
        return StorageUtils.serializeWith(out -> {
            out.writeInt(entries.size());
            for (RepositoryLogFileEntry fileEntry : entries.values()) {
                out.writeByte(fileEntry.getCommitType().ordinal());
                out.writeBoolean(fileEntry.isDeleted());
                EExternalAnalysisResultType subType = fileEntry.getSubType();
                out.writeByte(subType == null ? -1 : subType.ordinal());
            }
        });
    }

    private Map<ECommitType, RepositoryLogFileEntry> deserializeValue(byte[] key, byte[] value) throws StorageException {
        if (value == null) {
            return Collections.emptyMap();
        }
        String branch = this.abbreviator.unabbreviate(StorageAbbreviation.readFromStart((byte[])key));
        long timestamp = ByteArrayUtils.getLongFromByteArray((byte[])key, (int)4);
        CommitDescriptor commit = new CommitDescriptor(branch, timestamp);
        return this.deserializeValue(key, value, commit);
    }

    private Map<ECommitType, RepositoryLogFileEntry> deserializeValue(byte[] key, byte[] value, CommitDescriptor overwriteCommit) throws StorageException {
        UniformPath path = (UniformPath)this.pathSerializer.deserialize((Object)Arrays.copyOfRange(key, 12, key.length));
        return RepositoryLogFileIndex.deserializeValue(overwriteCommit, path, value);
    }

    private static Map<ECommitType, RepositoryLogFileEntry> deserializeValue(CommitDescriptor commit, UniformPath path, byte[] value) throws StorageException {
        ECommitType[] commitTypes = ECommitType.values();
        EExternalAnalysisResultType[] externalAnalysisResultTypes = EExternalAnalysisResultType.values();
        return (Map)StorageUtils.deserializeWith((byte[])value, in -> {
            int count = in.readInt();
            EnumMap<ECommitType, RepositoryLogFileEntry> result = new EnumMap<ECommitType, RepositoryLogFileEntry>(ECommitType.class);
            for (int i = 0; i < count; ++i) {
                ECommitType commitType = commitTypes[in.readByte()];
                boolean deleted = in.readBoolean();
                byte subTypeOrdinal = in.readByte();
                EExternalAnalysisResultType subType = subTypeOrdinal < 0 ? null : externalAnalysisResultTypes[subTypeOrdinal];
                result.put(commitType, new RepositoryLogFileEntry(commit, path, commitType, subType, deleted));
            }
            return result;
        });
    }

    public ListMap<CommitDescriptor, RepositoryLogFileEntry> getEntriesForCommits(List<? extends CommitDescriptor> commits) throws StorageException {
        List prefixes = CollectionUtils.mapWithException(commits, this::serializeKeyPrefix);
        PairList storeEntries = new PairList();
        this.store.scan(prefixes, (IKeyValueCallback)new KeyValueCollectingCallback(storeEntries));
        ListMap result = new ListMap();
        for (Pair storeEntry : storeEntries) {
            Collection<RepositoryLogFileEntry> logFileEntries = this.deserializeValue((byte[])storeEntry.getFirst(), (byte[])storeEntry.getSecond()).values();
            if (logFileEntries.isEmpty()) continue;
            result.addAll((Object)logFileEntries.iterator().next().getCommit(), logFileEntries);
        }
        return result;
    }

    public Map<ECommitType, RepositoryLogFileEntry> getEntries(CommitDescriptor commit, UniformPath path) throws StorageException {
        byte[] key = this.serializeKey(commit, path);
        return this.deserializeValue(key, this.store.get(key));
    }

    public SetMap<CommitDescriptor, UniformPath> getCodePathsByCommits(List<? extends CommitDescriptor> commits, String path) throws StorageException {
        return this.getCodePathsByCommits(commits, UniformPathCompatibilityUtil.convert((String)path));
    }

    public SetMap<CommitDescriptor, UniformPath> getCodePathsByCommits(List<? extends CommitDescriptor> commits, UniformPath pathPrefix) throws StorageException {
        ListMap<CommitDescriptor, RepositoryLogFileEntry> entriesForCommits = this.getEntriesForCommits(commits);
        SetMap result = new SetMap();
        for (Map.Entry entryForCommit : entriesForCommits) {
            for (RepositoryLogFileEntry entry : (List)entryForCommit.getValue()) {
                if (!RepositoryLogFileIndex.isRelevantEntry(pathPrefix, entry)) continue;
                result.add((Object)((CommitDescriptor)entryForCommit.getKey()), (Object)entry.getUniformPath());
            }
        }
        return result;
    }

    private static boolean isRelevantEntry(UniformPath uniformPath, RepositoryLogFileEntry entry) {
        return uniformPath.hasDescendant(entry.getUniformPath()) && (entry.getCommitType() == ECommitType.CODE_COMMIT || entry.getUniformPath().isNonCodePath() && entry.getCommitType() == ECommitType.EXTERNAL_ANALYSIS);
    }

    public List<RepositoryLogFileEntry> getEntriesByCommit(CommitDescriptor commit) throws StorageException {
        return this.getEntriesByCommits(List.of(commit));
    }

    public List<RepositoryLogFileEntry> getEntriesByDeltaKeys(List<byte[]> keys, CommitDescriptor schedulingCommit) throws StorageException {
        List values = this.store.get(keys);
        ArrayList<RepositoryLogFileEntry> result = new ArrayList<RepositoryLogFileEntry>(keys.size());
        CollectionUtils.forEachWithException(keys, (Collection)values, (key, value) -> result.addAll(this.deserializeValue((byte[])key, (byte[])value, schedulingCommit).values()));
        return result;
    }

    public List<RepositoryLogFileEntry> getEntriesByCommitAndEntryTypes(CommitDescriptor commit, EnumSet<UniformPath.EType> types) throws StorageException {
        List<RepositoryLogFileEntry> entries = this.getEntriesByCommit(commit);
        return CollectionUtils.filter(entries, entry -> types.contains(entry.getUniformPath().getType()));
    }

    public List<RepositoryLogFileEntry> getEntriesByCommits(List<? extends CommitDescriptor> commits) throws StorageException {
        return (List)this.getEntriesForCommits(commits).getValues();
    }

    public CommitDescriptor getOldestCommitForPath(List<? extends CommitDescriptor> commits, String path) throws StorageException {
        return (CommitDescriptor)Collections.min(this.getCodePathsByCommits(commits, path).getKeys());
    }

    public void performRollback(Map<String, Long> timestampByBranch, UUID rollbackId) throws StorageException {
        List deleteKeys = Collections.synchronizedList(new ArrayList());
        for (Map.Entry<String, Long> entry : timestampByBranch.entrySet()) {
            this.store.scanKeys(this.serializeKeyPrefix(new CommitDescriptor(entry.getKey(), entry.getValue() + 1L)), this.serializeKeyPrefix(new CommitDescriptor(entry.getKey(), Long.MAX_VALUE)), (key, value) -> deleteKeys.add(key));
        }
        this.store.remove(deleteKeys);
    }

    @TestOnly
    List<RepositoryLogFileEntry> getAllValues() throws StorageException {
        PairList allEntries = this.store.getEntriesStartingWith(ByteArrayUtils.EMPTY_ARRAY);
        ArrayList<RepositoryLogFileEntry> result = new ArrayList<RepositoryLogFileEntry>();
        for (Pair entry : allEntries) {
            byte[] value;
            byte[] key = (byte[])entry.getFirst();
            Map<ECommitType, RepositoryLogFileEntry> logEntries = this.deserializeValue(key, value = (byte[])entry.getSecond());
            if (logEntries == null) continue;
            result.addAll(logEntries.values());
        }
        return result;
    }
}

