/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store;

import com.teamscale.index.repository.artifact_store.ArtifactStoreItemData;
import com.teamscale.index.repository.artifact_store.ArtifactStoreRepositoryInfoBase;
import com.teamscale.index.repository.artifact_store.ExtractionFailedException;
import com.teamscale.index.repository.artifact_store.IArtifactStoreCommitResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.collections.Pair;
import org.jspecify.annotations.NonNull;

class LatestArchivesOnBranchCollector
implements AutoCloseable {
    private static final int EXCEPTION_COLLECTION_LIMIT = 10;
    private final List<ArtifactStoreItemData> archiveFiles;
    private final ArtifactStoreRepositoryInfoBase info;
    private final String branchName;
    private final List<String> archivePaths = new ArrayList<String>();
    private final Collection<String> extractionErrors = new ArrayList<String>();
    private final IArtifactStoreCommitResolver commitResolver;
    private final Logger logger;
    private long latestTimestamp = 0L;

    private LatestArchivesOnBranchCollector(List<ArtifactStoreItemData> archiveFiles, ArtifactStoreRepositoryInfoBase info, String branchName, IArtifactStoreCommitResolver commitResolver, Logger logger) {
        this.archiveFiles = archiveFiles;
        this.info = info;
        this.branchName = branchName;
        this.commitResolver = commitResolver;
        this.logger = logger;
    }

    public static List<String> collect(String connectorIdentifier, List<ArtifactStoreItemData> archiveFiles, ArtifactStoreRepositoryInfoBase info, String branchName, Logger logger) throws RepositoryException {
        try (LatestArchivesOnBranchCollector collector = new LatestArchivesOnBranchCollector(archiveFiles, info, branchName, info.createCommitResolver(connectorIdentifier), logger);){
            List<String> list = collector.collect();
            return list;
        }
    }

    private List<String> collect() throws RepositoryException {
        for (ArtifactStoreItemData archiveFile : this.archiveFiles) {
            this.extractArchivePath(archiveFile);
        }
        if (!this.extractionErrors.isEmpty()) {
            this.logExtractionErrors();
        }
        return this.archivePaths;
    }

    private void extractArchivePath(ArtifactStoreItemData archiveFile) throws RepositoryException {
        Optional<String> pathBranch = this.getPathBranch(archiveFile.getFullPath()).filter(this.branchName::equals);
        if (pathBranch.isEmpty()) {
            return;
        }
        Optional<Pair<String, CommitDescriptor>> revisionAndTimestamp = this.commitResolver.resolveRevisionAndCommit(archiveFile, pathBranch.get());
        if (revisionAndTimestamp.isEmpty()) {
            return;
        }
        long currentTimestamp = ((CommitDescriptor)revisionAndTimestamp.get().getSecond()).getTimestamp();
        if (currentTimestamp < this.latestTimestamp) {
            return;
        }
        if (currentTimestamp > this.latestTimestamp) {
            this.archivePaths.clear();
            this.latestTimestamp = currentTimestamp;
        }
        this.archivePaths.add(archiveFile.getFullPath());
    }

    private @NonNull Optional<String> getPathBranch(String fullPath) throws RepositoryException {
        try {
            return Optional.of(this.info.determineBranchName(fullPath, this.branchName));
        }
        catch (ExtractionFailedException e) {
            if (this.extractionErrors.size() < 10) {
                this.extractionErrors.add(e.getMessage());
            }
            return Optional.empty();
        }
    }

    private void logExtractionErrors() {
        Consumer<Message> warnOrErrorLogger;
        if (this.archivePaths.isEmpty()) {
            this.logger.error("No files matched the given patterns. Maybe the connector is not configured correctly?");
            warnOrErrorLogger = arg_0 -> ((Logger)this.logger).error(arg_0);
        } else {
            warnOrErrorLogger = arg_0 -> ((Logger)this.logger).warn(arg_0);
        }
        warnOrErrorLogger.accept((Message)new ParameterizedMessage("Some extractions failed (only showing the first {} messages):\n{}", (Object)10, (Object)String.join((CharSequence)"\n", this.extractionErrors)));
    }

    @Override
    public void close() throws RepositoryException {
        this.commitResolver.close();
    }
}

