/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store.artifactory;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.index.repository.artifact_store.ArtifactStoreUtils;
import com.teamscale.index.repository.artifact_store.artifactory.ArtifactoryRepositoryInfo;
import com.teamscale.index.repository.artifact_store.artifactory.SimpleArtifactoryClient;
import com.teamscale.index.repository.retrievers.IFilesRetriever;
import java.util.Collection;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.RepositoryException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class ArtifactoryFilesRetriever
implements IFilesRetriever {
    private final @Nullable ProjectConfiguration projectConfiguration;
    private final @NonNull ConnectorConfiguration connectorConfiguration;
    private final @NonNull ExternalCredentials credentials;
    private final @Nullable CommitTreeIndex foreignCommitTreeIndex;
    private final @NonNull Logger logger;

    public ArtifactoryFilesRetriever(@Nullable ProjectConfiguration projectConfiguration, @NonNull ConnectorConfiguration connectorConfiguration, @NonNull ExternalCredentials credentials, @Nullable CommitTreeIndex foreignCommitTreeIndex, @NonNull Logger logger) {
        this.projectConfiguration = projectConfiguration;
        this.connectorConfiguration = connectorConfiguration;
        this.credentials = credentials;
        this.foreignCommitTreeIndex = foreignCommitTreeIndex;
        this.logger = logger;
    }

    @Override
    public @NonNull Collection<@NonNull String> fetchFiles() throws RepositoryException, ProjectConfigurationException {
        String publicContextPath = this.connectorConfiguration.getOptionValue("Public Context Path");
        SimpleArtifactoryClient client = new SimpleArtifactoryClient(this.credentials, publicContextPath, this.logger);
        ArtifactoryRepositoryInfo info = ArtifactStoreUtils.createArtifactoryRepositoryInfo(this.connectorConfiguration, this.foreignCommitTreeIndex);
        return ArtifactStoreUtils.fetchFilesFromArtifactStore(this.projectConfiguration, this.connectorConfiguration, info, client);
    }
}

