/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store.artifactory;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.IProfilingMonitor;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.rest.client.Retrofit;
import com.teamscale.core.rest.client.converter.IBodyConverterProfilingMonitor;
import com.teamscale.core.rest.client.retry.HttpRequestRetryPolicy;
import com.teamscale.index.external.input.external_storage.IOutgoingExternalStorageFile;
import com.teamscale.index.repository.TypeSpecificBodyConverterProfilingMonitor;
import com.teamscale.index.repository.artifact_store.ArtifactStoreItemData;
import com.teamscale.index.repository.artifact_store.ItemQueryResultData;
import com.teamscale.index.repository.artifact_store.SimpleArtifactStoreClientBase;
import com.teamscale.index.repository.artifact_store.artifactory.ArtifactoryAqlUtils;
import com.teamscale.index.repository.artifact_store.artifactory.ArtifactoryArchiveIndex;
import com.teamscale.index.repository.artifact_store.artifactory.ArtifactoryRepositoryInfo;
import com.teamscale.index.repository.artifact_store.artifactory.IArtifactoryApi;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.net.ssl.SSLException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.http.ConnectionClosedException;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.function.BiConsumerWithTwoExceptions;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public class SimpleArtifactoryClient
extends SimpleArtifactStoreClientBase<ArtifactoryRepositoryInfo> {
    private final String baseUri;
    private final String username;
    private final String password;
    private static final String ROOT_FOLDER = ".";
    private static final Map<Class<? extends IOException>, Function<IOException, Boolean>> RETRY_EXCEPTION_TYPES_WITH_MESSAGE_FILTER = Set.of(InterruptedIOException.class, UnknownHostException.class, ConnectException.class, SSLException.class, ConnectionClosedException.class).stream().collect(Collectors.toMap(e -> e, e -> HttpRequestRetryPolicy.RETRY_ALL_MESSAGES_FILTER));
    private final IArtifactoryApi artifactory;

    public SimpleArtifactoryClient(ExternalCredentials credentials, String publicContextPath, Logger interactionLogger) {
        this(credentials, publicContextPath, interactionLogger, IProfilingMonitor.EMPTY);
    }

    public SimpleArtifactoryClient(ExternalCredentials credentials, String publicContextPath, Logger interactionLogger, IProfilingMonitor profilingMonitor) {
        this.username = credentials.username;
        this.password = credentials.password;
        this.baseUri = SimpleArtifactoryClient.correctBaseUri(credentials.uri, publicContextPath);
        this.artifactory = (IArtifactoryApi)SimpleArtifactoryClient.configureAuthenticationMode(Retrofit.builder((String)this.baseUri), credentials.username, credentials.password).withDeserializationProfilingMonitor((IBodyConverterProfilingMonitor)new TypeSpecificBodyConverterProfilingMonitor(profilingMonitor, Set.of(ItemQueryResultData.class))).withReadTimeout(TIMEOUT.toSeconds()).withInteractionLogger(interactionLogger).withRetryPolicy(new HttpRequestRetryPolicy(RETRY_EXCEPTION_TYPES_WITH_MESSAGE_FILTER)).create(IArtifactoryApi.class);
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    private static String correctBaseUri(String baseUri, String publicContextPath) {
        baseUri = StringUtils.ensureEndsWith((String)baseUri, (String)UniformPathUtils.SEPARATOR);
        baseUri = StringUtils.ensureEndsWith((String)baseUri, (String)StringUtils.ensureEndsWith((String)publicContextPath, (String)UniformPathUtils.SEPARATOR));
        return baseUri;
    }

    private static Retrofit.Builder configureAuthenticationMode(Retrofit.Builder builder, @Nullable String username, String passwordOrToken) {
        if (StringUtils.isEmpty((String)username)) {
            return builder.withBearerAuthentication(passwordOrToken);
        }
        return builder.withBasicAuthentication(username, passwordOrToken, null);
    }

    public boolean repositoryExists(String repositoryName) throws ServiceCallException {
        RepositoryData[] repositories = this.artifactory.getRepositories();
        return Arrays.stream(repositories).anyMatch(repository -> repositoryName.equals(repository.key));
    }

    @Override
    public void forEachEntryInArchive(String repository, String path, BiConsumerWithTwoExceptions<ArchiveInputStream<?>, ArchiveEntry, IOException, StorageException> consumer) throws RepositoryException, StorageException {
        try (ResponseBody response = this.artifactory.getEntriesForPath(repository, path);){
            SimpleArtifactoryClient.forEachEntryInArchiveStream(path, response.byteStream(), consumer);
        }
        catch (ServiceCallException | IOException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public ItemQueryResultData findItems(ArtifactoryRepositoryInfo info, int maxCacheAgeSeconds) throws RepositoryException {
        try {
            long changedSinceTimestamp = SimpleArtifactoryClient.getTimestampForChangeQuery(info);
            String aqlQuery = ArtifactoryAqlUtils.createAqlQuery(info, changedSinceTimestamp);
            long queryTimestamp = System.currentTimeMillis();
            ItemQueryResultData resultData = this.artifactory.searchItems(SimpleArtifactoryClient.createAqlRequestBody(aqlQuery));
            info.artifactoryArchiveIndex.setLastScanTimestamp(queryTimestamp, changedSinceTimestamp == 0L);
            List<ArtifactStoreItemData> itemData = SimpleArtifactoryClient.filterDuplicateItems(resultData);
            if (changedSinceTimestamp == 0L) {
                return ItemQueryResultData.forFullScanWithAllKeys(itemData);
            }
            return ItemQueryResultData.forIncrementalScanWithAddedKeys(itemData);
        }
        catch (ServiceCallException | StorageException e) {
            throw new RepositoryException(e);
        }
    }

    private static RequestBody createAqlRequestBody(String aqlQuery) {
        return RequestBody.create((String)aqlQuery, (MediaType)MediaType.parse((String)"text/plain; charset=utf-8"));
    }

    @Override
    public void putFile(String repositoryName, IOutgoingExternalStorageFile archive) {
        throw new UnsupportedOperationException("This action is currently not supported for Artifactory.");
    }

    @Override
    public void deleteFile(String repositoryOrBucketName, String path) {
        throw new UnsupportedOperationException("This action is currently not supported for Artifactory.");
    }

    private static long getTimestampForChangeQuery(ArtifactoryRepositoryInfo info) throws StorageException {
        OptionalLong lastScan;
        ArtifactoryArchiveIndex index = info.artifactoryArchiveIndex;
        OptionalLong lastFullScan = index.getLastFullScanTimestamp();
        if (lastFullScan.isEmpty()) {
            return 0L;
        }
        long fullScanIntervalSeconds = info.getFullScanIntervalInSeconds();
        if (fullScanIntervalSeconds >= 0L) {
            Instant lastFullScanInstant = Instant.ofEpochMilli(lastFullScan.getAsLong());
            Instant nextFullScan = lastFullScanInstant.plus(Duration.ofSeconds(fullScanIntervalSeconds));
            if (Instant.now().isAfter(nextFullScan)) {
                return 0L;
            }
        }
        if ((lastScan = index.getLastScanTimestamp()).isEmpty()) {
            return 0L;
        }
        return lastScan.getAsLong();
    }

    @Override
    public Set<String> fetchBranches(ArtifactoryRepositoryInfo info) throws RepositoryException, ProjectConfigurationException {
        String branchExtractionFormat = info.getBranchExtractionPattern();
        Pattern branchExtractionPattern = Pattern.compile(branchExtractionFormat);
        String aql = ArtifactoryAqlUtils.makeFetchBranchesQuery(info.getRepositoryOrBucketName());
        try {
            ItemQueryResultData resultData = this.artifactory.searchItems(SimpleArtifactoryClient.createAqlRequestBody(aql));
            return SimpleArtifactoryClient.filterAndSortBranches(branchExtractionFormat, branchExtractionPattern, resultData);
        }
        catch (PatternSyntaxException e) {
            throw new ProjectConfigurationException("Branch extraction (option) pattern '" + branchExtractionFormat + "' is invalid. " + e.getMessage(), (Throwable)e);
        }
        catch (ServiceCallException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public void testConnection(String repositoryOrBucketName, String uploadPathPrefix) {
        throw new UnsupportedOperationException("This action is currently not supported for Artifactory.");
    }

    private static Set<String> filterAndSortBranches(String branchExtractionFormat, Pattern branchExtractionPattern, ItemQueryResultData resultData) {
        Set<Object> uniqueBranches;
        if (!branchExtractionFormat.isEmpty()) {
            uniqueBranches = new HashSet();
            resultData.forEach((Consumer<? super ArtifactStoreItemData>)((Consumer<ArtifactStoreItemData>)itemDatum -> SimpleArtifactoryClient.filterBranch(branchExtractionPattern, uniqueBranches, itemDatum)));
        } else {
            uniqueBranches = resultData.stream().filter(itemDatum -> !itemDatum.name.equals(ROOT_FOLDER)).map(itemDatum -> itemDatum.name).collect(Collectors.toSet());
        }
        return new TreeSet<String>(uniqueBranches);
    }

    private static void filterBranch(Pattern pattern, Set<String> uniqueBranches, ArtifactStoreItemData itemDatum) {
        if (itemDatum.name.equals(ROOT_FOLDER)) {
            return;
        }
        String fullPath = UniformPathUtils.concatenate((String[])new String[]{itemDatum.path, itemDatum.name});
        Matcher matcher = pattern.matcher(fullPath);
        if (matcher.matches() && matcher.groupCount() > 0) {
            uniqueBranches.add(matcher.group(1));
        }
    }

    static class RepositoryData {
        public String key;

        RepositoryData() {
        }
    }
}

