/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store.revision_interpretation;

import com.teamscale.index.repository.artifact_store.revision_interpretation.BranchNameDependentRevisionInterpretationBase;
import com.teamscale.index.repository.artifact_store.revision_interpretation.ERevisionType;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;
import org.jspecify.annotations.NonNull;

final class RevisionIsTimestampInterpretation
extends BranchNameDependentRevisionInterpretationBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String TIMESTAMP_SECONDS = "seconds";
    private static final String TIMESTAMP_MILLIS = "millis";
    private final long factor;

    private RevisionIsTimestampInterpretation(long factor) {
        this.factor = factor;
    }

    @Override
    public Optional<CommitDescriptor> interpretRevisionWithBranchName(String revision, @NonNull String branchName) {
        try {
            return Optional.of(new CommitDescriptor(branchName, Long.parseLong(revision) * this.factor));
        }
        catch (NumberFormatException e) {
            LOGGER.atWarn().withThrowable((Throwable)e).log("Could not parse timestamp '{}'.", (Object)revision);
            return Optional.empty();
        }
    }

    public static RevisionIsTimestampInterpretation create(String granularity) throws RepositoryException {
        long factor = switch (granularity) {
            case TIMESTAMP_SECONDS -> 1000L;
            case TIMESTAMP_MILLIS -> 1L;
            default -> throw new RepositoryException("Invalid timestamp parameter '%s'.".formatted(granularity));
        };
        return new RevisionIsTimestampInterpretation(factor);
    }

    @Override
    public ERevisionType getRevisionType() {
        return ERevisionType.TIMESTAMP;
    }
}

