/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.base;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.GlobalIndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.index.repository.IRepositoryConnection;
import com.teamscale.index.repository.base.RepositoryConnectorBase;
import java.util.Optional;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;

public abstract class AccountBasedRepositoryConnectorBase<C extends IRepositoryConnection>
extends RepositoryConnectorBase<C> {
    @StepParameter(value="account-identifier", optional=true)
    protected String accountIdentifier;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_ONLY)
    public ExternalCredentialsIndex externalCredentialsIndex;

    public ExternalCredentials getExternalCredentials() throws RepositoryException {
        try {
            Optional<ExternalCredentials> externalCredentials = AccountBasedRepositoryConnectorBase.getExternalCredentials(this.accountIdentifier, this.externalCredentialsIndex);
            return externalCredentials.orElseThrow(() -> new RepositoryException("Account doesn't exist: " + this.accountIdentifier));
        }
        catch (StorageException e) {
            throw new RepositoryException("Failed to read external accounts: " + this.accountIdentifier, (Throwable)e);
        }
    }

    private static Optional<ExternalCredentials> getExternalCredentials(String accountIdentifier, ExternalCredentialsIndex externalCredentialsIndex) throws StorageException {
        return Optional.ofNullable(externalCredentialsIndex.getExternalCredentials(accountIdentifier));
    }
}

