/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.errors.GitAPIException;

public class LsRemoteGitProxy
implements AutoCloseable {
    private final String repositoryIdentifier;
    private final boolean createDummyRepo;
    private File dummyPath;
    private Git git;

    public LsRemoteGitProxy(String repositoryIdentifier, boolean createLocalDummy) {
        this.repositoryIdentifier = repositoryIdentifier;
        this.createDummyRepo = createLocalDummy;
    }

    public LsRemoteCommand lsRemote() throws GitAPIException, IOException {
        if (this.createDummyRepo) {
            return this.lsRemoteWithDummyRepo();
        }
        return Git.lsRemoteRepository();
    }

    private LsRemoteCommand lsRemoteWithDummyRepo() throws GitAPIException, IOException {
        if (this.git == null) {
            String dummyName = this.repositoryIdentifier + String.valueOf(UUID.randomUUID());
            this.dummyPath = new File(FileSystemUtils.concatenatePaths((String)FileSystemUtils.getTmpDir().getCanonicalPath(), (String[])new String[]{dummyName}));
            Files.createDirectories(this.dummyPath.toPath(), new FileAttribute[0]);
            this.git = Git.init().setDirectory(this.dummyPath).call();
        }
        return this.git.lsRemote();
    }

    @Override
    public void close() throws Exception {
        if (this.createDummyRepo && this.dummyPath != null) {
            FileSystemUtils.deleteRecursively((File)this.dummyPath);
        }
    }
}

