/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.common;

import com.teamscale.index.merge_request.comments.RepositoryPathMapper;
import com.teamscale.index.merge_request.comments.comments.IReviewComment;
import com.teamscale.index.merge_request.comments.comments.TestGapReviewComment;
import com.teamscale.index.repository.git.common.CommitVotingTriggerBase;
import com.teamscale.index.repository.git.common.VotingConnectorUtils;
import com.teamscale.index.testgap.ETestGapState;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jetbrains.annotations.VisibleForTesting;

public final class CcpCommentUtils {
    private static final Pattern FINDINGS_ID_PATTERN = Pattern.compile("id=([a-zA-z\\d]*)");
    private static final Pattern ALL_WHITESPACE = Pattern.compile("\\s+", 32);
    private static final Pattern TEST_GAP_MARKDOWN_COMMENT_PATTERN = Pattern.compile("\\*\\*\\[Test\\sGap]\\*\\*.+\\[\\(view\\sin\\sTeamscale\\)]\\(.+\\)");
    public static final String COMMENT_LINE_CHANGED_FORMAT_STRING = "(comment was moved to visible diff, actual start line: %d)";
    @VisibleForTesting
    public static final String YELLOW_FINDING_EMOJI = "&#x26A0; ";
    private static final String DEPRECATED_YELLOW_FINDING_EMOJI = "&#9888; ";
    private static final String RED_FINDING_EMOJI = "&#x26D4; ";
    private static final String DEPRECATED_RED_FINDING_EMOJI = "&#9940; ";
    private static final String COMMIT_ALERT_EMOJI = "&#x2757; ";
    private static final String DEPRECATED_COMMIT_ALERT_EMOJI = "&#10071; ";
    public static final String TEAMSCALE_LOGO_ALT_TEXT = "Teamscale's logo";
    private static final Map<String, String> UNICODE_DECIMAL_TO_HEX = new HashMap<String, String>();

    public static Optional<String> extractFindingIdFromComment(String commentText) {
        Matcher findingsMatcher = FINDINGS_ID_PATTERN.matcher(commentText);
        if (findingsMatcher.find()) {
            return Optional.of(findingsMatcher.group(1));
        }
        return Optional.empty();
    }

    public static Optional<String> extractNormalizedTestGapComment(String commentText) {
        if (CcpCommentUtils.isMarkdownTeamscaleTestGapComment(commentText)) {
            return Optional.of(CcpCommentUtils.normalizeCommentText(commentText));
        }
        return Optional.empty();
    }

    public static String normalizeCommentText(String commentText) {
        commentText = commentText.replace("**[New]**", "");
        return ALL_WHITESPACE.matcher(commentText).replaceAll("");
    }

    public static boolean isMarkdownTeamscaleTestGapComment(String commentText) {
        Matcher testGapsMatcher = TEST_GAP_MARKDOWN_COMMENT_PATTERN.matcher(commentText);
        return testGapsMatcher.find();
    }

    public static boolean isTeamscaleTestGapSummaryComment(String commentText) {
        return commentText.startsWith("* ") && CcpCommentUtils.isMarkdownTeamscaleTestGapComment(commentText);
    }

    public static boolean isTeamscaleBadgeComment(String commentText) {
        return commentText.startsWith("[![Teamscale's logo](");
    }

    public static String createInlineCommentMarkdownContent(List<IReviewComment> reviewComments, int lineInDiff) {
        return CcpCommentUtils.createInlineCommentMarkdownContent(reviewComments, true, lineInDiff);
    }

    public static String createInlineCommentMarkdownContent(List<IReviewComment> reviewComments, boolean emojiSupport, int lineInMergeRequestDiff) {
        StringBuilder builder = new StringBuilder();
        for (IReviewComment reviewComment : reviewComments) {
            if (emojiSupport) {
                CcpCommentUtils.appendEmoji(reviewComment, builder);
            }
            builder.append(reviewComment.getMarkdownText());
            if (reviewComment.getStartLine() != lineInMergeRequestDiff) {
                builder.append(" *").append(String.format(COMMENT_LINE_CHANGED_FORMAT_STRING, reviewComment.getStartLine())).append("*");
            }
            builder.append("  \n");
        }
        return builder.toString();
    }

    private static void appendEmoji(IReviewComment reviewComment, StringBuilder builder) {
        if ("Commit Alerts".equals(reviewComment.getCategory())) {
            builder.append(COMMIT_ALERT_EMOJI);
            return;
        }
        if ("Test Gaps".equals(reviewComment.getCategory())) {
            return;
        }
        if (reviewComment.getAssessment() == ETrafficLightColor.YELLOW) {
            builder.append(YELLOW_FINDING_EMOJI);
        } else {
            builder.append(RED_FINDING_EMOJI);
        }
    }

    public static String createTestGapSummaryCommentMarkdownContent(CommitVotingTriggerBase.SchedulingParameters schedulingParams, List<RepositoryPathMapper.RepositoryReviewComment> testGapComments, MergeRequestIdentifier mergeRequestIdentifier) {
        CCSMAssert.isNotEmpty(testGapComments, (String)"There must be test gap comments to create the test gap summary markdown comment.");
        int testGapCommentsLimit = VotingConnectorUtils.getDetailedLineCommentsLimitForTestGaps(schedulingParams.connector());
        List testGapCommentsToBeListed = CollectionUtils.limit(testGapComments, (int)testGapCommentsLimit);
        Map<ETestGapState, Long> remainingTestGapsMap = new HashMap<ETestGapState, Long>();
        if (testGapCommentsToBeListed.size() < testGapComments.size()) {
            List<RepositoryPathMapper.RepositoryReviewComment> remainingTestGaps = testGapComments.subList(testGapCommentsToBeListed.size(), testGapComments.size());
            remainingTestGapsMap = remainingTestGaps.stream().map(c -> (TestGapReviewComment)c.getComment()).collect(Collectors.groupingBy(TestGapReviewComment::getTestGapState, Collectors.counting()));
        }
        StringBuilder builder = new StringBuilder();
        for (IReviewComment comment : testGapCommentsToBeListed) {
            builder.append("* ");
            builder.append(comment.getLocation()).append(": ");
            builder.append(comment.getMarkdownText()).append("\n");
        }
        String remainingText = CcpCommentUtils.createRemainingTestGapsLinkText(remainingTestGapsMap);
        String linkText = schedulingParams.linkProvider().createMergeRequestDetailsLink(mergeRequestIdentifier);
        builder.append("\n").append("[").append(remainingText).append("]").append("(").append(linkText).append(")");
        return builder.toString();
    }

    private static String createRemainingTestGapsLinkText(Map<ETestGapState, Long> remainingTestGapsMap) {
        if (remainingTestGapsMap.isEmpty()) {
            return "View all test gaps in Teamscale.";
        }
        long untestedChangedMethods = Optional.ofNullable(remainingTestGapsMap.get((Object)ETestGapState.UNTESTED_CHANGE)).orElse(0L);
        long untestedAddedMethods = Optional.ofNullable(remainingTestGapsMap.get((Object)ETestGapState.UNTESTED_ADDITION)).orElse(0L);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("See other ");
        if (untestedChangedMethods > 0L) {
            stringBuilder.append(untestedChangedMethods).append(" changed ");
            if (untestedAddedMethods > 0L) {
                stringBuilder.append("and ");
            }
        }
        if (untestedAddedMethods > 0L) {
            stringBuilder.append(untestedAddedMethods).append(" added ");
        }
        stringBuilder.append(" untested ");
        stringBuilder.append(StringUtils.pluralize((String)"method", (int)((int)(untestedAddedMethods + untestedChangedMethods))));
        stringBuilder.append(".");
        return stringBuilder.toString();
    }

    public static boolean isTeamscaleFindingsComment(String commentText) {
        return commentText != null && StringUtils.startsWithOneOf((String)commentText, (String[])new String[]{RED_FINDING_EMOJI, DEPRECATED_RED_FINDING_EMOJI, YELLOW_FINDING_EMOJI, DEPRECATED_YELLOW_FINDING_EMOJI});
    }

    public static boolean isDeletableTeamscaleComment(String commentText) {
        return CcpCommentUtils.isTeamscaleFindingsComment(commentText) || CcpCommentUtils.isMarkdownTeamscaleTestGapComment(commentText);
    }

    @VisibleForTesting
    public static boolean isCommitAlertComment(String commentText) {
        return commentText != null && StringUtils.startsWithOneOf((String)commentText, (String[])new String[]{COMMIT_ALERT_EMOJI, DEPRECATED_COMMIT_ALERT_EMOJI});
    }

    public static boolean isTeamscaleComment(String commentText) {
        return CcpCommentUtils.isTeamscaleFindingsComment(commentText) || CcpCommentUtils.isMarkdownTeamscaleTestGapComment(commentText) || CcpCommentUtils.isCommitAlertComment(commentText);
    }

    public static String convertEscapedMarkdownRelevantSymbolsToHexUnicode(String s) {
        return StringUtils.replaceFromMap((String)s, UNICODE_DECIMAL_TO_HEX);
    }

    public static TextRegionLocation toTextRegionLocation(ElementLocation elementLocation) {
        if (elementLocation instanceof TextRegionLocation) {
            return (TextRegionLocation)elementLocation;
        }
        return new TextRegionLocation(elementLocation.getUniformPath(), 0, 0, 1, 1);
    }

    private CcpCommentUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    static {
        UNICODE_DECIMAL_TO_HEX.put("&#35;", "&#x23;");
        UNICODE_DECIMAL_TO_HEX.put("&#42;", "&#x2A;");
        UNICODE_DECIMAL_TO_HEX.put("&#95;", "&#x5F;");
        UNICODE_DECIMAL_TO_HEX.put("&#126;", "&#x7E;");
        UNICODE_DECIMAL_TO_HEX.put("&#91;", "&#x5B;");
        UNICODE_DECIMAL_TO_HEX.put("&#93;", "&#x5D;");
        UNICODE_DECIMAL_TO_HEX.put("&#33;", "&#x21;");
        UNICODE_DECIMAL_TO_HEX.put("&#96;", "&#x60;");
    }
}

