/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.common;

import com.teamscale.commons.links.TeamscaleCommitLinkProvider;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.committree.CommitTree;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.committree.CommitTreeNode;
import com.teamscale.core.committree.CommitTreeRevision;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.core.config.TeamscaleSystemProperties;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.options.BaseUrlOption;
import com.teamscale.core.runtime.impl.progress.BranchAnalysisStateIndex;
import com.teamscale.core.runtime.impl.rollback.PostRevisionAnalysisTriggerBase;
import com.teamscale.index.commit_alert.CommitAlert;
import com.teamscale.index.commit_alert.CommitAlerts;
import com.teamscale.index.external.update.ExternalResultsPartitionLastUpdateIndex;
import com.teamscale.index.merge_request.MergeRequest;
import com.teamscale.index.merge_request.comments.ReviewCommentEngineParameters;
import com.teamscale.index.merge_request.comments.ReviewCommentResolutionReasonParameters;
import com.teamscale.index.merge_request.voting.PostponedVotingIndex;
import com.teamscale.index.merge_request.voting.VotingException;
import com.teamscale.index.merge_request.voting.VotingRecord;
import com.teamscale.index.merge_request.voting.VotingRecordIndex;
import com.teamscale.index.merge_request.voting.VotingRecorder;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.repository.RepositoryOriginalPathIndex;
import com.teamscale.index.repository.git.common.BuildCompletenessStatus;
import com.teamscale.index.repository.git.common.CcpIntegrationFeatureEnablements;
import com.teamscale.index.repository.git.common.CommitsOnBranchCache;
import com.teamscale.index.repository.git.common.ExternalUploadsVotingCondition;
import com.teamscale.index.repository.git.common.IVotingInput;
import com.teamscale.index.repository.git.common.VotingRequirementsChecker;
import com.teamscale.index.repository.git.common.merge_request_statistics.IMergeRequestStatisticsCollector;
import com.teamscale.index.testgap.assessment.AssessedTgaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.core.cancel.ExecutionCanceledException;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class CommitVotingTriggerBase<VOTING_INPUT extends IVotingInput>
extends PostRevisionAnalysisTriggerBase {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String FINDINGS_LINE_COMMENT_LIMIT_WARNING = "There are %s added findings. This number exceeds the set limit for findings to be shown as individual comments. Please navigate to [Teamscale](%s) instead for more findings details.";
    protected static final String TEST_GAPS_LINE_COMMENT_LIMIT_WARNING = "There are %s test gaps. This number exceeds the set limit for test gaps to be shown as individual comments. Please navigate to [Teamscale](%s) instead for more test gap details.";
    private static final VotingRecorder.VotingResult SKIPPED_VOTING_WITHOUT_TIMESTAMP = new VotingRecorder.VotingResult(VotingRecord.EVotingState.SKIPPED, null, Collections.emptyList());
    protected BranchAnalysisStateIndex analysisStateIndex;
    protected MetaIndex metaIndex;
    protected RepositoryLogIndex repositoryLogIndex;
    protected ServerOptionIndex serverOptionIndex;
    protected VotingRecordIndex votingRecordIndex;
    protected CommitDescriptorIndex commitDescriptorIndex;
    private ExternalResultsPartitionLastUpdateIndex externalResultsPartitionLastUpdateIndex;
    private ExternalUploadsVotingCondition externalUploadsArePresentForVoting;
    private PostponedVotingIndex postponedVotingIndex;
    protected CommitsOnBranchCache commitsOnBranchCache;
    protected RepositoryOriginalPathIndex.RepositoryOriginalPathView repositoryPathView;
    private CommitTree commitTree;

    public final void execute() throws StorageException {
        CommitDescriptor schedulingCommit = Objects.requireNonNull(this.jobDescriptor.getSchedulingCommit());
        LOGGER.debug("Executing voting trigger '{}' for commit '{}'.", new Supplier[]{() -> ((Object)((Object)this)).getClass().getSimpleName(), () -> schedulingCommit});
        this.openIndexes(schedulingCommit);
        this.commitsOnBranchCache = new CommitsOnBranchCache(this.commitDescriptorIndex);
        ProjectInfo projectInfo = ((ProjectIndex)this.openGlobalStorageSystem().openGlobalIndex(ProjectIndex.class)).resolveProject((IProjectId)this.getProjectId());
        new VotingRecorder(projectInfo.getPrimaryPublicId(), this.votingRecordIndex, this.repositoryLogIndex, this.externalResultsPartitionLastUpdateIndex, schedulingCommit).record(() -> this.execute(schedulingCommit));
    }

    protected void handleVotingException(SchedulingParameters schedulingParameters, MergeRequest mergeRequest, VotingException votingException) throws ExecutionCanceledException {
    }

    protected ExternalUploadsVotingCondition getExternalUploadsVotingCondition() {
        return this.externalUploadsArePresentForVoting;
    }

    protected abstract MergeRequest getMergeRequest(VOTING_INPUT var1);

    protected abstract List<CommitTreeNode> getCommitTreeNodes(VOTING_INPUT var1) throws StorageException;

    @VisibleForTesting
    public long calculateTimeToVote(VOTING_INPUT input) throws StorageException {
        MergeRequest mergeRequest = this.getMergeRequest(input);
        LOGGER.debug("Calculating time to vote for merge request with ID {}.", (Object)mergeRequest.identifier);
        long latestVote = this.getTimestampOfLatestVoteOrCreationDate(mergeRequest);
        LOGGER.debug("Timestamp of latest vote or creation date of merge request: {}", (Object)latestVote);
        List<CommitTreeNode> commitTreeNodes = this.getCommitTreeNodes(input);
        CCSMAssert.isNotNull(commitTreeNodes, (String)"List should not be null as we lazy loaded it during voting input calculation.");
        Optional<CommitTreeNode> earliestVotableNode = commitTreeNodes.stream().filter(node -> node.getBranchName().equals(mergeRequest.sourceBranch)).filter(node -> node.getDiscoveryTimestamp() >= latestVote).min(Comparator.comparingLong(CommitTreeNode::getDiscoveryTimestamp));
        long timeToVoteEnd = DateTimeUtils.now().toEpochMilli();
        long earliestVotableChange = earliestVotableNode.map(CommitTreeNode::getDiscoveryTimestamp).orElse(Long.MAX_VALUE);
        LOGGER.debug("The oldest commit tree node which needs to be voted on has a timestamp of {}", (Object)earliestVotableChange);
        if (earliestVotableNode.isPresent()) {
            CommitTreeNode commitTreeNode = earliestVotableNode.get();
            LOGGER.debug("The oldest commit tree node we vote for is {}", (Object)commitTreeNode);
            RepositoryLogEntryAggregate entry = (RepositoryLogEntryAggregate)this.repositoryLogIndex.getEntry(new CommitDescriptor(commitTreeNode.getBranchName(), commitTreeNode.getOriginalTimestamp()));
            if (entry != null && entry.getCommitTypes().stream().anyMatch(type -> type != ECommitType.CODE_COMMIT)) {
                long timeToVote = timeToVoteEnd - commitTreeNode.getDiscoveryTimestamp();
                LOGGER.debug("The oldest commit tree node which needs to be voted on was updated with a non-code commit. We report a time to vote of {} ms, which is the difference of the current time and the time of discovery for the upload.", (Object)timeToVote);
                return timeToVote;
            }
        }
        return CommitVotingTriggerBase.calculateTimeToVote(mergeRequest, latestVote, timeToVoteEnd, earliestVotableChange);
    }

    private static long calculateTimeToVote(MergeRequest mergeRequest, long latestVote, long timeToVoteEnd, long earliestVotableChange) {
        long latestMergeRequestUpdate = mergeRequest.votingRelevantChangeTimestamps.stream().mapToLong(Long::longValue).filter(l -> l >= latestVote).min().orElse(latestVote);
        long lastRelevantUpdate = Math.max(latestVote, latestMergeRequestUpdate);
        LOGGER.debug("The latest update to the merge request was recorded at {}. This is the maximum value of our latest vote and the latest change to the merge request.", (Object)lastRelevantUpdate);
        long timeToVoteStart = Math.min(lastRelevantUpdate, earliestVotableChange);
        long timeToVote = timeToVoteEnd - timeToVoteStart;
        LOGGER.debug("The earliest time we could have voted on this merge request was {}. This is the minimum value of the last update to the merge request/our latest vote AND the discovery time of the earliest commit we vote on. We report a time to vote of {}", (Object)timeToVoteStart, (Object)timeToVote);
        return timeToVote;
    }

    private long getTimestampOfLatestVoteOrCreationDate(MergeRequest mergeRequest) throws StorageException {
        VotingRecord latestVotingRecord = this.votingRecordIndex.getNewestRecordForBranch(mergeRequest.sourceBranch);
        if (latestVotingRecord.state != VotingRecord.EVotingState.UNVOTED) {
            return latestVotingRecord.getTimestamp().orElseThrow(() -> new AssertionError((Object)("All VotingRecords which are not " + VotingRecord.EVotingState.UNVOTED.name() + " should have a voting timestamp.")));
        }
        return Objects.requireNonNullElse(mergeRequest.getCreatedAt(), -1L);
    }

    private VotingRecorder.VotingResult execute(CommitDescriptor schedulingCommit) throws StorageException, VotingException, ExecutionCanceledException, ServiceCallException {
        try {
            this.skipVotingIfPossible(schedulingCommit);
        }
        catch (VotingException e) {
            RepositoryLogEntryAggregate repositoryLogEntry = (RepositoryLogEntryAggregate)this.repositoryLogIndex.getEntry(schedulingCommit);
            Optional<ConnectorConfiguration> votingConnector = this.getVotingConnector(repositoryLogEntry);
            if (votingConnector.isPresent() && !CcpIntegrationFeatureEnablements.isAnyIntegrationEnabled(votingConnector.get())) {
                LOGGER.debug("Skipped voting because of the following exception but didn't record its reason because the voting integration is disabled and we prefer skipping due to that.", (Throwable)e);
                throw VotingException.Skipped.integrationDisabled(schedulingCommit, votingConnector.get());
            }
            throw e;
        }
        PairList<ParentedCommitDescriptor, RepositoryLogEntryAggregate> latestRelevantCommits = this.getLatestRelevantCommitsOnBranch(schedulingCommit);
        LOGGER.debug("Candidate commits for voting on {}: {}", (Object)schedulingCommit, latestRelevantCommits);
        if (latestRelevantCommits.isEmpty()) {
            LOGGER.debug("No analyzed commits found for voting on {}. This may happen during a rollback.", (Object)schedulingCommit);
            throw VotingException.Skipped.notYetAnalyzed(schedulingCommit);
        }
        VotingRecorder.VotingResult state = this.computeVotingStateForCommit(schedulingCommit, latestRelevantCommits);
        LOGGER.debug("Final voting state for commit {}: {}", (Object)this.jobDescriptor.getSchedulingCommit(), (Object)state);
        return state;
    }

    protected void skipVotingIfPossible(CommitDescriptor schedulingCommit) throws StorageException, VotingException {
        if (!VotingRequirementsChecker.isCommitRelevantForVoting(schedulingCommit) || !this.isRelevantCommit(schedulingCommit) || CommitVotingTriggerBase.isExcludedSourceBranch(schedulingCommit.getBranchName())) {
            throw VotingException.Skipped.irrelevantCommit(schedulingCommit);
        }
    }

    private static boolean isExcludedSourceBranch(@NonNull String branchName) {
        Boolean canSkip = TeamscaleSystemProperties.EXCLUDED_MERGE_REQUEST_SOURCE_BRANCHES.getValue().map(excludedBranches -> excludedBranches.contains(branchName)).orElse(false);
        if (canSkip.booleanValue()) {
            LOGGER.info("Skipping to vote because the branch of the currently analyzed commit is excluded by the system property {}.", (Object)TeamscaleSystemProperties.EXCLUDED_MERGE_REQUEST_SOURCE_BRANCHES.getName());
        }
        return canSkip;
    }

    private VotingRecorder.VotingResult computeVotingStateForCommit(CommitDescriptor schedulingCommit, PairList<ParentedCommitDescriptor, RepositoryLogEntryAggregate> latestRelevantCommits) throws StorageException, VotingException, ExecutionCanceledException, ServiceCallException {
        ArrayList<VotingException> votingExceptions = new ArrayList<VotingException>();
        for (Pair latestCommitAndLogEntry : latestRelevantCommits) {
            try {
                VotingRecorder.VotingResult state = this.getVotingStateForLogEntry(schedulingCommit, (Pair<ParentedCommitDescriptor, RepositoryLogEntryAggregate>)latestCommitAndLogEntry);
                if (state.votingState() == VotingRecord.EVotingState.SKIPPED) continue;
                return state;
            }
            catch (VotingException votingException) {
                votingExceptions.add(votingException);
            }
        }
        CommitVotingTriggerBase.throwAccumulatedExceptionsIfNotEmpty(votingExceptions);
        return new VotingRecorder.VotingResult(VotingRecord.EVotingState.SKIPPED, null, Collections.emptyList());
    }

    private static <T extends Exception> void throwAccumulatedExceptionsIfNotEmpty(Collection<T> exceptions) throws T {
        Optional<T> accumulatedException = exceptions.stream().reduce((earlierException, laterException) -> {
            laterException.addSuppressed((Throwable)earlierException);
            return laterException;
        });
        if (accumulatedException.isPresent()) {
            throw (Exception)accumulatedException.get();
        }
    }

    private VotingRecorder.VotingResult getVotingStateForLogEntry(CommitDescriptor schedulingCommit, Pair<ParentedCommitDescriptor, RepositoryLogEntryAggregate> latestCommitAndLogEntry) throws StorageException, VotingException, ExecutionCanceledException, ServiceCallException {
        RepositoryLogEntryAggregate latestLogEntry = (RepositoryLogEntryAggregate)latestCommitAndLogEntry.getSecond();
        Optional<ConnectorConfiguration> connector = this.getVotingConnector(latestLogEntry);
        if (connector.isEmpty()) {
            LOGGER.debug(() -> "Not using commit " + String.valueOf(latestCommitAndLogEntry) + " for voting on " + String.valueOf(this.jobDescriptor.getSchedulingCommit()) + " as no voting connector was found!");
            return SKIPPED_VOTING_WITHOUT_TIMESTAMP;
        }
        SchedulingParameters schedulingParameters = this.initSchedulingParameters(schedulingCommit, latestCommitAndLogEntry, connector.get());
        return this.processLatestCommitForRepository(schedulingParameters);
    }

    private SchedulingParameters initSchedulingParameters(CommitDescriptor schedulingCommit, Pair<ParentedCommitDescriptor, RepositoryLogEntryAggregate> latestCommitAndLogEntry, ConnectorConfiguration connector) throws StorageException {
        TeamscaleCommitLinkProvider linkProvider = new TeamscaleCommitLinkProvider(BaseUrlOption.getBaseUrl((ServerOptionIndex)this.serverOptionIndex), this.getPrimaryPublicId(), schedulingCommit);
        return new SchedulingParameters(schedulingCommit, (ParentedCommitDescriptor)latestCommitAndLogEntry.getFirst(), (RepositoryLogEntryAggregate)latestCommitAndLogEntry.getSecond(), connector, linkProvider);
    }

    protected abstract ERepositoryConnector getRepositoryConnector();

    protected Optional<ConnectorConfiguration> getVotingConnector(@Nullable RepositoryLogEntryAggregate repositoryLogEntry) throws StorageException {
        if (repositoryLogEntry == null) {
            return Optional.empty();
        }
        List relevantVotingConnectors = ConnectorUtils.getRepositoryConnectors((MetaIndex)this.metaIndex, (ERepositoryConnector)this.getRepositoryConnector());
        CCSMAssert.isFalse((boolean)relevantVotingConnectors.isEmpty(), () -> "Unable to find voting connector of type " + String.valueOf(this.getRepositoryConnector()) + " in project configuration.");
        return relevantVotingConnectors.stream().filter(connector -> repositoryLogEntry.containsRepositoryIdentifier(connector.getIdentifier())).findAny();
    }

    private VotingRecorder.VotingResult processLatestCommitForRepository(SchedulingParameters schedulingParameters) throws StorageException, VotingException, ExecutionCanceledException, ServiceCallException {
        this.verifyNotCanceled();
        this.repositoryPathView = ((RepositoryOriginalPathIndex)this.openIndexInProject(RepositoryOriginalPathIndex.class, HistoryAccessOption.readTimestamp((String)schedulingParameters.schedulingCommit.getBranchName(), (long)schedulingParameters.schedulingCommit.getTimestamp()))).createView(schedulingParameters.connector.getIdentifier());
        this.initializeForSchedulingParameters(schedulingParameters);
        Pair<MergeRequest, VOTING_INPUT> mergeRequestAndVotingInput = this.calculateVotingInput(schedulingParameters);
        IVotingInput input = (IVotingInput)mergeRequestAndVotingInput.getSecond();
        this.persistVotingInput(input);
        Long timeToVote = this.calculateTimeToVote(input);
        BuildCompletenessStatus buildCompletenessStatusAndBuildJobs = this.getBuildCompletenessStatus(input);
        IMergeRequestStatisticsCollector mergeRequestROILogger = IMergeRequestStatisticsCollector.create(this.getIndexLayer(), this.getProjectId(), input);
        MergeRequestIdentifier identifier = ((MergeRequest)mergeRequestAndVotingInput.getFirst()).identifier;
        try {
            this.checkVotingRequirements(schedulingParameters, identifier, buildCompletenessStatusAndBuildJobs);
            VotingRecord.EVotingState votingState = this.performVoting(schedulingParameters, input);
            mergeRequestROILogger.logVote(votingState);
            VotingRecorder.VotingResult votingResult = new VotingRecorder.VotingResult(votingState, timeToVote, buildCompletenessStatusAndBuildJobs.relevantBuildJobs());
            return votingResult;
        }
        catch (VotingException e) {
            e.getRecord().setTimeToVote(timeToVote);
            mergeRequestROILogger.logVotingException(e);
            this.onVotingException(schedulingParameters, (MergeRequest)mergeRequestAndVotingInput.getFirst(), e);
            throw e;
        }
        finally {
            this.postponedVotingIndex.removePostponedVote(identifier);
        }
    }

    private void onVotingException(SchedulingParameters schedulingParameters, MergeRequest mergeRequest, VotingException votingException) {
        try {
            this.handleVotingException(schedulingParameters, mergeRequest, votingException);
        }
        catch (ExecutionCanceledException ex) {
            LOGGER.error(LoggingUtils.INTERACTION, "Voting exception handler failed. Some state on the external system was probably not cleaned up.", (Throwable)ex);
        }
    }

    protected BuildCompletenessStatus getBuildCompletenessStatus(VOTING_INPUT input) {
        return new BuildCompletenessStatus(false, Collections.emptyList());
    }

    protected void initializeForSchedulingParameters(SchedulingParameters schedulingParameters) throws StorageException, ServiceCallException {
    }

    private void checkVotingRequirements(SchedulingParameters schedulingParams, MergeRequestIdentifier identifier, BuildCompletenessStatus buildCompletenessStatusAndBuildJobs) throws VotingException {
        CommitDescriptor commit = schedulingParams.schedulingCommit;
        try {
            new VotingRequirementsChecker(this.getPrimaryPublicId(), this.indexLayer.openGlobalStorageSystem(), (ProjectStorageSystem)this.indexLayer.openProjectStorageSystem((IProjectId)this.getProjectId())).checkVotingRequirements(Boolean.parseBoolean(this.jobDescriptor.getParameter()), commit, identifier, schedulingParams.connector, schedulingParams.latestCommitForConnector, buildCompletenessStatusAndBuildJobs, this.externalUploadsArePresentForVoting);
        }
        catch (StorageException e) {
            throw new VotingException.Error(commit, (Throwable)e);
        }
    }

    protected abstract Pair<MergeRequest, VOTING_INPUT> calculateVotingInput(SchedulingParameters var1) throws VotingException, StorageException;

    protected abstract void persistVotingInput(VOTING_INPUT var1) throws StorageException, VotingException;

    public static boolean isNotLatestCommitOnBranch(CommitDescriptor schedulingCommit, CommitTree commitTree) {
        String latestRevision = (String)commitTree.getLatestContainedRevisionForBranch(schedulingCommit.getBranchName()).orElseThrow();
        ICommitTreeNode node = Objects.requireNonNull(commitTree.getNodeByRevision(new CommitTreeRevision(latestRevision, schedulingCommit.getBranchName())));
        return node.getAdjustedTimestamp().orElseThrow() > schedulingCommit.getTimestamp();
    }

    protected final CommitTree getCommitTree(ConnectorConfiguration connector) throws StorageException {
        if (this.commitTree != null) {
            return this.commitTree;
        }
        String commitTreeIndexName = CommitTreeIndex.getIndexNameForRepository((String)connector.getIdentifier());
        this.commitTree = ((CommitTreeIndex)this.openNamedIndexInProject(commitTreeIndexName, CommitTreeIndex.class, null)).loadTree();
        return this.commitTree;
    }

    protected void openIndexes(CommitDescriptor schedulingCommit) throws StorageException {
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readTimestamp((String)schedulingCommit.getBranchName(), (long)schedulingCommit.getTimestamp());
        this.externalResultsPartitionLastUpdateIndex = (ExternalResultsPartitionLastUpdateIndex)this.openIndexInProject(ExternalResultsPartitionLastUpdateIndex.class, historyAccessOption);
        this.analysisStateIndex = (BranchAnalysisStateIndex)this.openIndexInProject(BranchAnalysisStateIndex.class);
        this.commitDescriptorIndex = (CommitDescriptorIndex)this.openIndexInProject(CommitDescriptorIndex.class);
        this.metaIndex = (MetaIndex)this.openIndexInProject(MetaIndex.class);
        this.repositoryLogIndex = (RepositoryLogIndex)this.openIndexInProject(RepositoryLogIndex.class);
        this.serverOptionIndex = (ServerOptionIndex)this.openGlobalIndex(ServerOptionIndex.class);
        ProjectStorageSystem projectStorage = this.openProjectStorageSystem();
        this.votingRecordIndex = (VotingRecordIndex)projectStorage.openProjectIndex(VotingRecordIndex.class, null);
        this.externalUploadsArePresentForVoting = new ExternalUploadsVotingCondition(projectStorage, schedulingCommit);
        this.postponedVotingIndex = (PostponedVotingIndex)projectStorage.openProjectIndex(PostponedVotingIndex.class, null);
    }

    protected boolean isRelevantCommit(CommitDescriptor commit) throws StorageException {
        return true;
    }

    private PairList<ParentedCommitDescriptor, RepositoryLogEntryAggregate> getLatestRelevantCommitsOnBranch(CommitDescriptor schedulingCommit) throws StorageException, VotingException {
        List<ParentedCommitDescriptor> commitsOnBranch = this.commitsOnBranchCache.getCommitsOnBranchFromCache(schedulingCommit.getBranchName());
        if (commitsOnBranch.isEmpty()) {
            return PairList.emptyPairList();
        }
        VotingException.Skipped skipException = null;
        List repositoryLogEntries = this.repositoryLogIndex.getEntries(commitsOnBranch);
        PairList latestRelevantCommitOnBranchByRepositoryIdentifier = new PairList();
        for (int i = 0; i < commitsOnBranch.size(); ++i) {
            ParentedCommitDescriptor commit = commitsOnBranch.get(i);
            RepositoryLogEntryAggregate repositoryLogEntry = (RepositoryLogEntryAggregate)repositoryLogEntries.get(i);
            if (commit.getTimestamp() > schedulingCommit.getTimestamp()) {
                skipException = VotingException.Skipped.moreRecentCommitsOnBranch(schedulingCommit);
                continue;
            }
            if (repositoryLogEntry == null) {
                skipException = VotingException.Skipped.repositoryLogEntryMissing(schedulingCommit);
                continue;
            }
            if (!this.isRelevantLogEntry(repositoryLogEntry)) {
                skipException = VotingException.Skipped.noMergeRequestExists(schedulingCommit);
                continue;
            }
            latestRelevantCommitOnBranchByRepositoryIdentifier.add((Object)commit, (Object)repositoryLogEntry);
        }
        if (latestRelevantCommitOnBranchByRepositoryIdentifier.isEmpty()) {
            throw (VotingException.Skipped)Objects.requireNonNull(skipException);
        }
        return latestRelevantCommitOnBranchByRepositoryIdentifier.reversed();
    }

    protected abstract boolean isRelevantLogEntry(RepositoryLogEntryAggregate var1) throws StorageException;

    protected abstract VotingRecord.EVotingState performVoting(SchedulingParameters var1, VOTING_INPUT var2) throws StorageException, VotingException, ExecutionCanceledException, ServiceCallException;

    public static void logCommentedFindingsForCommit(CommitDescriptor sourceCommit, List<TrackedFinding> commentedFindings) {
        LOGGER.info(LoggingUtils.INTERACTION, () -> "Commenting the following findings for " + String.valueOf(sourceCommit) + ":\n" + commentedFindings.stream().map(TrackedFinding::toStringWithId).collect(Collectors.joining("\n")));
    }

    public static void logCommentedAlertsForCommit(CommitDescriptor sourceCommit, CommitAlerts commitAlerts) {
        LOGGER.info(LoggingUtils.INTERACTION, () -> "Commenting the following alerts for " + String.valueOf(sourceCommit) + ":\n" + commitAlerts.getCommitAlerts().stream().map(CommitAlert::getMessage).collect(Collectors.joining("\n")));
    }

    protected static void logCommentedTestGapsForCommit(CommitDescriptor sourceCommit, List<AssessedTgaData.AssessedMethodData> untestedMethods) {
        LOGGER.info(LoggingUtils.INTERACTION, () -> "Commenting the following test gaps for " + String.valueOf(sourceCommit) + ":\n" + untestedMethods.stream().map(AssessedTgaData.AssessedMethodData::getMethodName).collect(Collectors.joining(",")));
    }

    protected ReviewCommentEngineParameters createReviewCommentTriggerParameters(CommitDescriptor commit) throws StorageException {
        return ReviewCommentEngineParameters.create(commit, this.openProjectStorageSystem());
    }

    protected ReviewCommentResolutionReasonParameters createReviewCommentResolutionReasonParameters(CommitDescriptor commit) throws StorageException {
        return ReviewCommentResolutionReasonParameters.create(BaseUrlOption.getBaseUrl((ServerOptionIndex)this.serverOptionIndex), this.getPrimaryPublicId(), commit, this.openProjectStorageSystem(), this.indexLayer.openGlobalStorageSystem());
    }

    public Set<String> getReadStores() {
        return CollectionUtils.unionSet((Collection)super.getReadStores(), (Collection[])new Collection[]{CollectionUtils.asHashSet((Object[])new String[]{"repository-log", "external-results-partition-last-update", "_meta"})});
    }

    public Set<String> getWriteStores() {
        return CollectionUtils.unionSet((Collection)super.getWriteStores(), (Collection[])new Collection[]{CollectionUtils.asHashSet((Object[])new String[]{"voting-records"})});
    }

    @VisibleForTesting
    public record SchedulingParameters(CommitDescriptor schedulingCommit, ParentedCommitDescriptor latestCommitForConnector, RepositoryLogEntryAggregate latestLogForConnector, ConnectorConfiguration connector, TeamscaleCommitLinkProvider linkProvider) {
        public HistoryAccessOption getHistoryAccessOption() {
            return HistoryAccessOption.readTimestamp((String)this.schedulingCommit.getBranchName(), (long)this.schedulingCommit.getTimestamp());
        }
    }

    public static enum EFindingsBadgePosition {
        TOP,
        BOTTOM;

    }
}

