/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.labeling;

import com.teamscale.index.repository.committree.IBranchRenameHandler;
import com.teamscale.index.repository.git.CommitGraphNode;
import com.teamscale.index.repository.git.CommitGraphTraversalUtils;
import com.teamscale.index.repository.git.GitMainRepository;
import com.teamscale.index.repository.git.gerrit.GerritUtils;
import com.teamscale.index.repository.git.labeling.GitBranchPrioritizer;
import com.teamscale.index.repository.git.labeling.IBranchLabeler;
import com.teamscale.index.repository.git.labeling.MergeMessageParser;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.IdentitySetMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.string.StringUtils;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class PathBuildingBranchLabeler
implements IBranchLabeler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<String> STRIPPED_PREFIXES = CollectionUtils.asHashSet((Object[])new String[]{"origin", "upstream", "remotes"});
    private static final String GIT_REF = "refs/";
    private static final String GIT_REF_HEADS = "refs/heads/";
    private static final String GIT_REF_REMOTES = "refs/remotes/";
    private static final int FIRST_PARENT_BONUS = 2;
    private final Map<String, String> branchNamesByCommitNameFromGitInfoIndex;
    private final Map<String, String> fixedCommitsToBranchName;
    private final SetMap<String, String> branchesToFixedCommits;
    private final Map<String, CommitGraphNode> nodesByName;
    private Map<String, String> branchNamesByHeadNodes;
    private final GitBranchPrioritizer branchPrioritizer;
    private final Predicate<String> isBranchNameIncludedPredicate;
    private final GitMainRepository repository;
    private final IBranchRenameHandler branchRenameHandler;
    private final Map<CommitGraphNode, Integer> nodeToWeight = new IdentityHashMap<CommitGraphNode, Integer>();
    private GitBranchPrioritizer.BranchNameSuggestions suggestions;
    private final MergeMessageParser mergeMessageParser = MergeMessageParser.createInstance();

    public PathBuildingBranchLabeler(Map<String, String> branchNamesByCommitNameFromGitInfoIndex, Map<String, String> fixedCommitsToBranchName, Map<String, CommitGraphNode> nodesByName, GitBranchPrioritizer branchPrioritizer, Predicate<String> isBranchNameIncludedPredicate, GitMainRepository repository) {
        this(branchNamesByCommitNameFromGitInfoIndex, fixedCommitsToBranchName, nodesByName, branchPrioritizer, isBranchNameIncludedPredicate, repository, null);
    }

    public PathBuildingBranchLabeler(Map<String, String> branchNamesByCommitNameFromGitInfoIndex, Map<String, String> fixedCommitsToBranchName, Map<String, CommitGraphNode> nodesByName, GitBranchPrioritizer branchPrioritizer, Predicate<String> isBranchNameIncludedPredicate, GitMainRepository repository, @Nullable IBranchRenameHandler branchRenameHandler) {
        this.branchNamesByCommitNameFromGitInfoIndex = branchNamesByCommitNameFromGitInfoIndex;
        this.fixedCommitsToBranchName = fixedCommitsToBranchName;
        this.branchesToFixedCommits = PathBuildingBranchLabeler.getBranchesToFixedCommits(fixedCommitsToBranchName);
        this.nodesByName = nodesByName;
        this.branchPrioritizer = branchPrioritizer;
        this.isBranchNameIncludedPredicate = isBranchNameIncludedPredicate;
        this.repository = repository;
        this.branchRenameHandler = branchRenameHandler;
        this.branchNamesByCommitNameFromGitInfoIndex.entrySet().removeIf(entry -> !this.isBranchNameIncluded((String)entry.getValue()));
    }

    private static SetMap<String, String> getBranchesToFixedCommits(Map<String, String> fixedCommitsToBranchName) {
        SetMap branchesWithFixedCommits = new SetMap();
        fixedCommitsToBranchName.forEach((key, value) -> branchesWithFixedCommits.add(value, key));
        return branchesWithFixedCommits;
    }

    @Override
    public void setBranchLabelsForCommits() throws RepositoryException {
        LOGGER.traceEntry();
        this.suggestions = this.createBranchNameSuggestions();
        this.setBranchesWithHeadCommit(this.extractBranchesWithHeadCommit(this.suggestions));
        this.doSetBranchLabelsForCommits();
    }

    @VisibleForTesting
    void forTestOnlySetBranchLabelsForCommits(PairList<String, String> branchesWithHeadCommit) throws RepositoryException {
        this.suggestions = this.createBranchNameSuggestions();
        this.setBranchesWithHeadCommit(branchesWithHeadCommit.inversed().toMap());
        this.doSetBranchLabelsForCommits();
    }

    private void setBranchesWithHeadCommit(Map<String, String> branchNamesByHeadNodes) {
        this.branchNamesByHeadNodes = new HashMap<String, String>(branchNamesByHeadNodes.size());
        branchNamesByHeadNodes.forEach((nodeName, branchName) -> {
            if (this.branchPrioritizer.isPrioritizedBranch((String)branchName) && this.suggestions.hasHigherImportance((String)branchName, this.fixedCommitsToBranchName.get(nodeName))) {
                this.fixedCommitsToBranchName.remove(nodeName);
            }
            if (this.isBranchNameIncluded((String)branchName)) {
                this.branchNamesByHeadNodes.put((String)nodeName, (String)branchName);
            }
        });
    }

    private void doSetBranchLabelsForCommits() {
        this.branchNamesByHeadNodes.forEach((commitId, branch) -> this.resetUnreachableFixedCommits(this.nodesByName.get(commitId), (String)branch));
        this.fixBranchNamesForFixedNodes();
        this.labelBranchesWithHeadCommit();
        this.labelUnknownNodesByBranchFrequency();
        this.storeLabelsInGitIndex();
    }

    private void labelBranchesWithHeadCommit() {
        LOGGER.traceEntry();
        Map<String, Integer> headPointerRootDistanceByBranch = this.determineHeadPointerRootDistance();
        LOGGER.trace(headPointerRootDistanceByBranch);
        HashSet ignoredHeads = new HashSet();
        List<Map.Entry> sortedNodeAndBranchNames = this.suggestions.sort(this.branchNamesByHeadNodes.entrySet(), Map.Entry::getValue, Comparator.comparing(branch -> headPointerRootDistanceByBranch.getOrDefault(branch, Integer.MAX_VALUE)));
        LOGGER.trace(sortedNodeAndBranchNames);
        sortedNodeAndBranchNames.forEach(nodeNameAndBranchName -> {
            CommitGraphNode node = this.nodesByName.get(nodeNameAndBranchName.getKey());
            if (node == null) {
                LOGGER.trace("Adding to ignored heads: {}", nodeNameAndBranchName);
                ignoredHeads.add(nodeNameAndBranchName);
            } else {
                String branchName = (String)nodeNameAndBranchName.getValue();
                CommitGraphNode startNode = this.weighBestPath(Collections.singleton(node), branchName);
                if (startNode != null) {
                    this.labelNodesOnBestPath(startNode, branchName, this.nodeToWeight);
                }
            }
        });
        if (!ignoredHeads.isEmpty()) {
            LOGGER.warn("Skipping labeling for branch pointers " + String.valueOf(ignoredHeads) + " which point to commits that are not known in Teamscale.\nThis should be a rare scenario, but it means that the branches likely will not show up in the Teamscale analysis. There are a number of possible scenarios that can cause this:\n- Bare clone of a repository, where not all origin branches are present locally.\n- Force pushing/rebasing a commit on a branch, without updating the corresponding branch pointer.\n- HEAD refs that are not connected to the main tree and only contain small, self contained subtrees.\nIn these cases it is safe to ignore this message. This message is meant for debugging purposes, as the exact cause of the problem is unclear. Labeling for the additional branch pointers will continue regardless.");
        }
    }

    private Map<String, Integer> determineHeadPointerRootDistance() {
        Collection<CommitGraphNode> nodes = this.nodesByName.values();
        HashMap<String, Integer> commitNameToDepth = new HashMap<String, Integer>();
        LinkedList<CommitGraphNode> nodesToProcess = new LinkedList<CommitGraphNode>();
        for (CommitGraphNode node : nodes) {
            if (!node.getParents().isEmpty()) continue;
            commitNameToDepth.put(node.getName(), 0);
            nodesToProcess.add(node);
        }
        while (!nodesToProcess.isEmpty()) {
            CommitGraphNode nextNode = (CommitGraphNode)nodesToProcess.poll();
            int childDepth = 1 + (Integer)commitNameToDepth.get(nextNode.getName());
            for (CommitGraphNode child : nextNode.getSuccessors()) {
                if (commitNameToDepth.containsKey(child.getName())) continue;
                commitNameToDepth.put(child.getName(), childDepth);
                nodesToProcess.add(child);
            }
        }
        HashMap<String, Integer> headPointerRootDistance = new HashMap<String, Integer>();
        for (Map.Entry<String, String> entry : this.branchNamesByHeadNodes.entrySet()) {
            String branch = entry.getValue();
            String commitName = entry.getKey();
            if (!commitNameToDepth.containsKey(commitName)) continue;
            headPointerRootDistance.put(branch, (Integer)commitNameToDepth.get(commitName));
        }
        return headPointerRootDistance;
    }

    private void labelUnknownNodesByBranchFrequency() {
        SetMap<String, CommitGraphNode> startNodesByBranch = this.suggestions.getBranchesToPossibleNodes();
        LOGGER.trace("branchNamesByHeadNodes: {}", this.branchNamesByHeadNodes);
        this.branchNamesByHeadNodes.forEach((ignored, branch) -> startNodesByBranch.removeCollection(branch));
        this.suggestions.sort((Collection<String>)startNodesByBranch.getKeys()).forEach(branch -> {
            CommitGraphNode startNode = this.weighBestPath(startNodesByBranch.getCollection(branch), (String)branch);
            if (startNode != null) {
                this.labelNodesOnBestPath(startNode, (String)branch, this.nodeToWeight);
            }
        });
    }

    private GitBranchPrioritizer.BranchNameSuggestions createBranchNameSuggestions() throws RepositoryException {
        LOGGER.traceEntry();
        IdentitySetMap branchNamesForNode = new IdentitySetMap();
        CounterSet branchNameFrequency = new CounterSet();
        for (CommitGraphNode node : this.nodesByName.values()) {
            Optional<String> branchName;
            if (node.hasBranchNameSet()) {
                LOGGER.trace("Adding branch name: node {}, name {}", (Object)node, (Object)node.getBranchName());
                branchNamesForNode.add((Object)node, (Object)node.getBranchName());
                node.setBranchName(null);
            }
            if (this.branchNamesByCommitNameFromGitInfoIndex.containsKey(node.getName())) {
                LOGGER.trace("Adding branch name: node {}, name {}", (Object)node, (Object)this.branchNamesByCommitNameFromGitInfoIndex.get(node.getName()));
                branchNamesForNode.add((Object)node, (Object)this.branchNamesByCommitNameFromGitInfoIndex.get(node.getName()));
            }
            if ((branchName = MergeMessageParser.createInstance().tryToGetBranchNameFromMergeMessage(node, this)).isPresent()) {
                LOGGER.trace("Adding branch name: node {}, name {}", (Object)node, (Object)branchName.get());
                branchNamesForNode.add((Object)node, (Object)branchName.get());
                branchNameFrequency.inc((Object)branchName.get());
                PathBuildingBranchLabeler.propagateExtractedBranchNameAlongLinearHistory(node, branchName.get(), (SetMap<CommitGraphNode, String>)branchNamesForNode, (CounterSet<String>)branchNameFrequency);
            }
            this.extractPossibleBranchNameAndBranchFrequencyFromCommitMessage(node, (SetMap<CommitGraphNode, String>)branchNamesForNode, (CounterSet<String>)branchNameFrequency);
        }
        Set<String> shadowedBranchNames = this.determineBranchesShadowedByRenames((UnmodifiableSet<String>)branchNameFrequency.getKeys());
        branchNameFrequency.removeAll(shadowedBranchNames);
        for (Map.Entry possibleBranchNamesForNode : branchNamesForNode) {
            ((Set)possibleBranchNamesForNode.getValue()).removeAll(shadowedBranchNames);
        }
        return (GitBranchPrioritizer.BranchNameSuggestions)LOGGER.traceExit((Object)this.branchPrioritizer.createSuggestions((SetMap<CommitGraphNode, String>)branchNamesForNode, this.getAllBranches(), (CounterSet<String>)branchNameFrequency));
    }

    private Set<String> determineBranchesShadowedByRenames(UnmodifiableSet<String> possibleBranchNames) {
        HashSet<String> shadowedBranches = new HashSet<String>();
        if (this.branchRenameHandler == null) {
            return shadowedBranches;
        }
        for (String unrenamedBranch : possibleBranchNames) {
            String renamedBranch;
            if (unrenamedBranch.equals(renamedBranch = this.branchRenameHandler.peekRenameBranch(unrenamedBranch)) || !possibleBranchNames.contains((Object)renamedBranch)) continue;
            shadowedBranches.add(renamedBranch);
            LOGGER.warn("Potential branch name overlap after renaming: '{}' is transformed to '{}' due to applicable branch transformation connector setting, but the resulting branch name already exists as a regular (non-transformed) branch name.\nRemoving '{}' from the set of considered branch names.", (Object)unrenamedBranch, (Object)renamedBranch, (Object)renamedBranch);
        }
        return shadowedBranches;
    }

    private static void propagateExtractedBranchNameAlongLinearHistory(CommitGraphNode node, String branchName, SetMap<CommitGraphNode, String> branchNamesForNode, CounterSet<String> branchNameFrequency) {
        LOGGER.traceEntry("node: {}, \nname: {}, \nfrequencies: {}", new Object[]{node, branchName, branchNameFrequency});
        List<CommitGraphNode> linearHistory = CommitGraphTraversalUtils.getLongestLinearHistory(node);
        LOGGER.trace("Linear history: {}", linearHistory);
        linearHistory = PathBuildingBranchLabeler.shortenHistoryOnCherryPicks(linearHistory);
        LOGGER.trace("Shortened linear history: {}", linearHistory);
        for (CommitGraphNode commitGraphNode : linearHistory) {
            LOGGER.trace("Adding branch name: node {}, name {}", (Object)commitGraphNode, (Object)branchName);
            branchNamesForNode.add((Object)commitGraphNode, (Object)branchName);
            branchNameFrequency.inc((Object)branchName);
        }
        LOGGER.traceExit();
    }

    private static List<CommitGraphNode> shortenHistoryOnCherryPicks(@NonNull List<CommitGraphNode> linearHistory) {
        if (linearHistory.isEmpty()) {
            return linearHistory;
        }
        ZonedDateTime authorTime = linearHistory.get(0).getAuthorTime();
        for (int i = 0; i < linearHistory.size(); ++i) {
            CommitGraphNode node = linearHistory.get(i);
            if (!node.getAuthorTime().isAfter(authorTime)) continue;
            return linearHistory.subList(0, i);
        }
        return linearHistory;
    }

    private void fixBranchNamesForFixedNodes() {
        LOGGER.traceEntry();
        for (Map.Entry<String, String> entry : this.fixedCommitsToBranchName.entrySet()) {
            CommitGraphNode node = this.nodesByName.get(entry.getKey());
            LOGGER.trace((Object)node);
            if (node == null) continue;
            String branchName = entry.getValue();
            if (this.branchNamesByHeadNodes.containsKey(node.getName()) && this.suggestions.hasHigherImportance(this.branchNamesByHeadNodes.get(node.getName()), branchName)) {
                LOGGER.trace("branchNamesByHeadNodes: {}, hasHigherImportance: {}", (Object)this.branchNamesByHeadNodes.containsKey(node.getName()), (Object)this.suggestions.hasHigherImportance(this.branchNamesByHeadNodes.get(node.getName()), branchName));
                continue;
            }
            Set<String> branchNames = this.suggestions.getPossibleBranchNames(node);
            LOGGER.debug("Fixing branch name for node {} to branch {}", (Object)node.getName(), (Object)branchName);
            branchNames.clear();
            branchNames.add(branchName);
            node.setBranchName(branchName);
            LOGGER.traceExit();
        }
    }

    private boolean isBranchNameIncluded(String branchName) {
        LOGGER.traceEntry("branchName: {}", new Object[]{branchName});
        boolean isGerritBranch = GerritUtils.isGerritBranch(branchName);
        boolean isBranchNameIncluded = this.isBranchNameIncludedPredicate.test(branchName);
        LOGGER.trace("isGerritBranch: {}, isBranchNameIncluded: {}", (Object)isGerritBranch, (Object)isBranchNameIncluded);
        return (Boolean)LOGGER.traceExit((Object)(!isGerritBranch && isBranchNameIncluded ? 1 : 0));
    }

    private void extractPossibleBranchNameAndBranchFrequencyFromCommitMessage(CommitGraphNode node, SetMap<CommitGraphNode, String> branchNamesForNode, CounterSet<String> branchNameFrequency) {
        LOGGER.traceEntry();
        Pair<Optional<String>, Optional<String>> firstAndSecondParentBranchNames = this.mergeMessageParser.tryToExtractParentsFromMergeMessage(node.getCommitMessage(), this);
        LOGGER.trace(firstAndSecondParentBranchNames);
        if (((Optional)firstAndSecondParentBranchNames.getFirst()).isPresent()) {
            String firstParent = (String)((Optional)firstAndSecondParentBranchNames.getFirst()).get();
            branchNameFrequency.inc((Object)firstParent);
            LOGGER.trace("Adding branch name: node {}, name {}", (Object)node, (Object)firstParent);
            branchNamesForNode.add((Object)node, (Object)firstParent);
            if (node.getFirstParent() != null) {
                LOGGER.trace("Adding branch name: node {}, name {}", (Object)node.getFirstParent(), (Object)firstParent);
                branchNamesForNode.add((Object)node.getFirstParent(), (Object)firstParent);
                PathBuildingBranchLabeler.propagateExtractedBranchNameAlongLinearHistory(node.getFirstParent(), firstParent, branchNamesForNode, branchNameFrequency);
            }
        }
        if (((Optional)firstAndSecondParentBranchNames.getSecond()).isPresent()) {
            String secondParent = (String)((Optional)firstAndSecondParentBranchNames.getSecond()).get();
            branchNameFrequency.inc((Object)secondParent);
            UnmodifiableList<CommitGraphNode> parents = node.getParents();
            for (int i = 1; i < parents.size(); ++i) {
                LOGGER.trace("Adding branch name: node {}, name {}", parents.get(i), (Object)secondParent);
                branchNamesForNode.add((Object)((CommitGraphNode)parents.get(i)), (Object)secondParent);
                PathBuildingBranchLabeler.propagateExtractedBranchNameAlongLinearHistory((CommitGraphNode)parents.get(i), secondParent, branchNamesForNode, branchNameFrequency);
            }
        }
        LOGGER.traceExit();
    }

    private @Nullable CommitGraphNode weighBestPath(Collection<CommitGraphNode> possibleStartNodes, String branchName) {
        LOGGER.traceEntry("possibleStartNodes: {}, branchName: {}", new Object[]{possibleStartNodes, branchName});
        List<CommitGraphNode> unlabeledStartNodes = PathBuildingBranchLabeler.determineUnlabeledStartNodes(possibleStartNodes, branchName);
        LOGGER.trace(unlabeledStartNodes);
        if (unlabeledStartNodes.isEmpty()) {
            return null;
        }
        this.nodeToWeight.clear();
        Stack<CommitGraphNode> nodesToProcess = new Stack<CommitGraphNode>();
        nodesToProcess.addAll(unlabeledStartNodes);
        while (!nodesToProcess.isEmpty()) {
            CommitGraphNode nextNode = (CommitGraphNode)nodesToProcess.pop();
            if (this.nodeToWeight.containsKey(nextNode)) continue;
            boolean repushed = false;
            for (CommitGraphNode parent : nextNode.getParents()) {
                boolean isViableBranchName = this.suggestions.canBeLabeledWith(parent, branchName);
                boolean nodeWeightMapContainsParent = this.nodeToWeight.containsKey(parent);
                LOGGER.trace("isViableBranchName: {}, nodeWeightMapContainsParent: {}, repushed: {}", (Object)isViableBranchName, (Object)nodeWeightMapContainsParent, (Object)repushed);
                if (!isViableBranchName || nodeWeightMapContainsParent) continue;
                if (!repushed) {
                    nodesToProcess.push(nextNode);
                    repushed = true;
                }
                nodesToProcess.push(parent);
            }
            if (repushed) continue;
            this.determineAndStoreBestWeightPath(nextNode, branchName, this.nodeToWeight);
        }
        return PathBuildingBranchLabeler.determineBestStartNode(branchName, unlabeledStartNodes, this.nodeToWeight);
    }

    private static List<CommitGraphNode> determineUnlabeledStartNodes(Collection<CommitGraphNode> possibleStartNodes, String branchName) {
        if (CollectionUtils.isNullOrEmpty(possibleStartNodes)) {
            LOGGER.error("Encountered empty set of possible start nodes for branch '" + branchName + "' during branch labeling phase. This will prevent analysis of the branch.");
            return Collections.emptyList();
        }
        return possibleStartNodes.stream().filter(node -> node.isBranchNameUnsetOrEqualTo(branchName)).sorted(Comparator.comparing(CommitGraphNode::getName)).toList();
    }

    private static CommitGraphNode determineBestStartNode(String branchName, List<CommitGraphNode> unlabeledStartNodes, Map<CommitGraphNode, Integer> nodeToWeight) throws AssertionError {
        LOGGER.traceEntry();
        if (unlabeledStartNodes.isEmpty()) {
            CCSMAssert.fail((String)("Possible start node for branch '" + branchName + "' must exist for non-empty set of possible start node candidates: " + String.valueOf(unlabeledStartNodes)));
        }
        CommitGraphNode bestStartNode = unlabeledStartNodes.get(0);
        int maxWeight = nodeToWeight.get(bestStartNode);
        LOGGER.trace("bestStartNode: {}, maxWeight: {}", (Object)bestStartNode, (Object)maxWeight);
        for (int i = 1; i < unlabeledStartNodes.size(); ++i) {
            CommitGraphNode node = unlabeledStartNodes.get(i);
            int weight = nodeToWeight.get(node);
            if (weight <= maxWeight) continue;
            maxWeight = weight;
            bestStartNode = node;
        }
        return (CommitGraphNode)LOGGER.traceExit((Object)bestStartNode);
    }

    private void determineAndStoreBestWeightPath(CommitGraphNode node, String branchName, Map<CommitGraphNode, Integer> nodeToWeight) {
        LOGGER.traceEntry();
        UnmodifiableList<CommitGraphNode> parents = node.getParents();
        int bestParentWeight = 0;
        for (CommitGraphNode parent : parents) {
            boolean parentHasSameOrEmptyBranchName = parent.isBranchNameUnsetOrEqualTo(branchName);
            boolean suggestionHasHigherImportanceThanCurrentBranchName = this.suggestions.hasHigherImportance(branchName, parent.getBranchName());
            LOGGER.trace("parent: {}, parentHasSameOrEmptyBranchName: {}, suggestionHasHigherImportanceThanCurrentBranchName: {}", (Object)parent, (Object)parentHasSameOrEmptyBranchName, (Object)suggestionHasHigherImportanceThanCurrentBranchName);
            if (!parentHasSameOrEmptyBranchName && !suggestionHasHigherImportanceThanCurrentBranchName) continue;
            bestParentWeight = Math.max(bestParentWeight, nodeToWeight.get(parent));
        }
        LOGGER.trace((Object)bestParentWeight);
        CommitGraphNode firstParent = node.getFirstParent();
        if (firstParent != null && firstParent.isBranchNameUnsetOrEqualTo(branchName) && parents.size() > 1) {
            bestParentWeight = Math.max(bestParentWeight, 2 + nodeToWeight.get(firstParent));
            LOGGER.trace((Object)bestParentWeight);
        }
        int ownWeight = this.determineNodeWeight(node, branchName);
        int bestPathWeight = ownWeight + bestParentWeight;
        nodeToWeight.put(node, bestPathWeight);
    }

    private int determineNodeWeight(CommitGraphNode node, String branchName) {
        LOGGER.traceEntry();
        boolean isFixedCommit = this.fixedCommitsToBranchName.containsKey(node.getName());
        if (isFixedCommit && branchName.equals(node.getBranchName())) {
            return (Integer)LOGGER.traceExit((Object)30);
        }
        String nameFromIndex = this.branchNamesByCommitNameFromGitInfoIndex.get(node.getName());
        if (branchName.equals(nameFromIndex)) {
            return (Integer)LOGGER.traceExit((Object)20);
        }
        Set<String> possibleBranchNames = this.suggestions.getPossibleBranchNames(node);
        if (possibleBranchNames.contains(branchName)) {
            return (Integer)LOGGER.traceExit((Object)10);
        }
        if (possibleBranchNames.isEmpty()) {
            return (Integer)LOGGER.traceExit((Object)1);
        }
        if (isFixedCommit && this.suggestions.hasHigherImportance(branchName, node.getBranchName()) || this.suggestions.hasHigherImportance(branchName, nameFromIndex)) {
            return (Integer)LOGGER.traceExit((Object)0);
        }
        for (String possibleBranchName : possibleBranchNames) {
            if (!this.suggestions.hasHigherImportance(branchName, possibleBranchName)) continue;
            return (Integer)LOGGER.traceExit((Object)0);
        }
        return (Integer)LOGGER.traceExit((Object)-20);
    }

    private void resetUnreachableFixedCommits(CommitGraphNode startNode, String branchName) {
        LOGGER.traceEntry();
        if (startNode == null) {
            LOGGER.debug("Encountered a missing start node for branch '{}'.", (Object)branchName);
            LOGGER.trace("Fixed nodes on branch '{}': \n{}", new Supplier[]{() -> branchName, () -> String.join((CharSequence)"\n", this.branchesToFixedCommits.getCollectionOrEmpty((Object)branchName))});
            return;
        }
        Set fixedCommitsOnBranch = (Set)this.branchesToFixedCommits.getCollection((Object)branchName);
        if (fixedCommitsOnBranch == null || fixedCommitsOnBranch.isEmpty()) {
            return;
        }
        Set<String> reachableCommits = PathBuildingBranchLabeler.getCommitsReachableFrom(startNode);
        List<String> commitsToReset = fixedCommitsOnBranch.stream().filter(fixedCommit -> !reachableCommits.contains(fixedCommit)).toList();
        LOGGER.trace(commitsToReset);
        Set<String> successorSetOffCommitsToReset = this.getCommitSucceedingCommitsToReset(commitsToReset);
        successorSetOffCommitsToReset.forEach(commit -> {
            this.fixedCommitsToBranchName.remove(commit);
            fixedCommitsOnBranch.remove(commit);
            if (this.nodesByName.containsKey(commit)) {
                this.nodesByName.get(commit).setBranchName(null);
                this.suggestions.removePossibleBranchForCommit(this.nodesByName.get(commit), branchName);
            }
        });
        LOGGER.traceExit();
    }

    private Set<String> getCommitSucceedingCommitsToReset(List<String> commitsToReset) {
        LOGGER.traceEntry();
        HashSet<String> allCommitsToReset = new HashSet<String>();
        ArrayDeque<String> successorsToVisit = new ArrayDeque<String>(commitsToReset);
        while (!successorsToVisit.isEmpty()) {
            String commitToVisit = successorsToVisit.pop();
            if (!this.nodesByName.containsKey(commitToVisit) || !allCommitsToReset.add(commitToVisit)) continue;
            CommitGraphNode node = this.nodesByName.get(commitToVisit);
            for (CommitGraphNode successor : node.getSuccessors()) {
                successorsToVisit.addLast(successor.getName());
            }
        }
        return (Set)LOGGER.traceExit(allCommitsToReset);
    }

    private static Set<String> getCommitsReachableFrom(CommitGraphNode startNode) {
        LOGGER.traceEntry("startNode: {}", new Object[]{startNode});
        HashSet<String> reachableCommits = new HashSet<String>();
        ArrayDeque<CommitGraphNode> queue = new ArrayDeque<CommitGraphNode>();
        queue.add(startNode);
        while (!queue.isEmpty()) {
            CommitGraphNode node = (CommitGraphNode)queue.pop();
            if (!reachableCommits.add(node.getName())) continue;
            queue.addAll((Collection<CommitGraphNode>)node.getParents());
        }
        return (Set)LOGGER.traceExit(reachableCommits);
    }

    private void labelNodesOnBestPath(CommitGraphNode node, String branchName, Map<CommitGraphNode, Integer> nodeToWeight) {
        LOGGER.traceEntry("node: {}, branchName: {}", new Object[]{node, branchName});
        CommitGraphNode nodeToLabelNext = node;
        while (!nodeToLabelNext.hasBranchNameSet() || this.suggestions.hasHigherImportance(branchName, nodeToLabelNext.getBranchName())) {
            CommitGraphNode maxWeightParent;
            if (this.isBranchNameIncluded(branchName)) {
                LOGGER.trace("Setting branch name: {} -> {}", (Object)nodeToLabelNext, (Object)branchName);
                nodeToLabelNext.setBranchName(branchName);
            }
            if ((maxWeightParent = this.getParentWithHighestWeight(branchName, nodeToWeight, nodeToLabelNext)) == null) {
                LOGGER.traceExit();
                return;
            }
            if (nodeToLabelNext.getFirstParent().isBranchNameUnsetOrEqualTo(branchName) && 2 + nodeToWeight.get(nodeToLabelNext.getFirstParent()) >= nodeToWeight.get(maxWeightParent)) {
                nodeToLabelNext = nodeToLabelNext.getFirstParent();
                LOGGER.trace("nodeToLabelNext: {}", (Object)nodeToLabelNext);
                continue;
            }
            nodeToLabelNext = maxWeightParent;
            LOGGER.trace("nodeToLabelNext: {}", (Object)nodeToLabelNext);
        }
    }

    private @Nullable CommitGraphNode getParentWithHighestWeight(String branchName, Map<CommitGraphNode, Integer> nodeToWeight, CommitGraphNode nodeToLabelNext) {
        LOGGER.traceEntry("nodeToLabelNext: {}, branchName: {}", new Object[]{nodeToLabelNext, branchName});
        CommitGraphNode highestWeightParent = null;
        int highestWeight = 0;
        for (CommitGraphNode parent : nodeToLabelNext.getParents()) {
            int parentWeight;
            if (!parent.isBranchNameUnsetOrEqualTo(branchName) && !this.suggestions.hasHigherImportance(branchName, parent.getBranchName()) || (parentWeight = nodeToWeight.get(parent).intValue()) <= highestWeight) continue;
            highestWeightParent = parent;
            highestWeight = parentWeight;
        }
        return (CommitGraphNode)LOGGER.traceExit(highestWeightParent);
    }

    public Map<String, String> extractBranchesWithHeadCommit() throws RepositoryException {
        return this.extractBranchesWithHeadCommit(this.createBranchNameSuggestions());
    }

    private Map<String, String> extractBranchesWithHeadCommit(GitBranchPrioritizer.BranchNameSuggestions suggestions) {
        LOGGER.traceEntry();
        List<Ref> branchRefsByFrequency = suggestions.getBranchHeadRefsByPriority();
        HashMap<String, String> branchNamesByHeadNodes = new HashMap<String, String>();
        for (Ref branchRef : branchRefsByFrequency) {
            String branchName;
            RefPeelResult peelResult = this.peelBranchRef(branchRef);
            if (peelResult == null || !this.isBranchNameIncluded(branchName = PathBuildingBranchLabeler.determineBranchName(peelResult.peeledBranchRef)) || branchNamesByHeadNodes.containsKey(peelResult.commitName)) continue;
            branchNamesByHeadNodes.put(peelResult.commitName, branchName);
        }
        return (Map)LOGGER.traceExit(branchNamesByHeadNodes);
    }

    private List<Ref> getAllBranches() throws RepositoryException {
        LOGGER.traceEntry();
        return (List)LOGGER.traceExit((Object)CollectionUtils.filter(this.repository.getAllBranches(true), branch -> !branch.isSymbolic()));
    }

    private RefPeelResult peelBranchRef(Ref branchRef) {
        LOGGER.traceEntry("branchRef: {}", new Object[]{branchRef});
        Ref peeledBranchRef = branchRef;
        try {
            String referencedCommitName = peeledBranchRef.getTarget().getObjectId().getName();
            LOGGER.trace(referencedCommitName);
            RefDatabase refDatabase = this.repository.getRepository().getRefDatabase();
            while ((peeledBranchRef = refDatabase.peel(peeledBranchRef)).getPeeledObjectId() != null) {
                String peeledCommitName = peeledBranchRef.getPeeledObjectId().getName();
                LOGGER.trace(peeledCommitName);
                if (peeledCommitName.equals(referencedCommitName)) break;
                referencedCommitName = peeledCommitName;
            }
            return (RefPeelResult)LOGGER.traceExit((Object)new RefPeelResult(referencedCommitName, peeledBranchRef));
        }
        catch (IOException e) {
            LOGGER.error("Unable to access Git ref or object space for " + String.valueOf(peeledBranchRef) + ". Skipping ref: " + String.valueOf(peeledBranchRef), (Throwable)e);
            return (RefPeelResult)LOGGER.traceExit((Object)null);
        }
    }

    static String determineBranchName(Ref branch) {
        LOGGER.traceEntry("branch: {}", new Object[]{branch});
        String name = branch.getName();
        if (name.startsWith(GIT_REF_HEADS)) {
            return (String)LOGGER.traceExit((Object)StringUtils.stripPrefix((String)name, (String)GIT_REF_HEADS));
        }
        if (name.startsWith(GIT_REF_REMOTES)) {
            return (String)LOGGER.traceExit((Object)StringUtils.stripPrefix((String)name, (String)GIT_REF));
        }
        return (String)LOGGER.traceExit((Object)StringUtils.getLastPart((String)branch.getName(), (char)'/'));
    }

    private void storeLabelsInGitIndex() {
        this.branchNamesByCommitNameFromGitInfoIndex.clear();
        this.nodesByName.values().stream().filter(CommitGraphNode::hasBranchNameSet).forEach(node -> this.branchNamesByCommitNameFromGitInfoIndex.put(node.getName(), node.getBranchName()));
    }

    @Override
    public String lookupBranchName(String branchName) {
        int slashIndex = branchName.indexOf(47);
        if (slashIndex < 0) {
            return branchName;
        }
        String prefix = branchName.substring(0, slashIndex);
        if (STRIPPED_PREFIXES.contains(prefix)) {
            return this.lookupBranchName(branchName.substring(slashIndex + 1));
        }
        return branchName;
    }

    public GitBranchPrioritizer.BranchNameSuggestions getSuggestions() {
        return this.suggestions;
    }

    private record RefPeelResult(String commitName, Ref peeledBranchRef) {
    }
}

