/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.scm_manager;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.index.repository.git.scm_manager.ScmManagerClient;
import java.net.URI;
import java.util.Optional;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.NonNull;

final class ScmManagerGitUtils {
    public static URI getRepositoryUri(@NonNull ExternalCredentials credentials, @NonNull ConnectorConfiguration connectorConfiguration, @NonNull Logger interactionLogger) throws RepositoryException, ProjectConfigurationException {
        try {
            String repositoryName = Optional.ofNullable(connectorConfiguration.getOptionValue("Repository name")).orElseThrow(() -> new ProjectConfigurationException("Repository name is null."));
            ScmManagerClient client = new ScmManagerClient(credentials, interactionLogger);
            return client.getRepositoryHttpCloneUri(PlatformRepositoryIdentifier.fromRepositoryName(repositoryName)).orElseThrow(() -> new ServiceCallException("Could not retrieve clone URL for repository: " + repositoryName));
        }
        catch (ServiceCallException e) {
            throw new RepositoryException("Cannot determine repository url: " + e.getMessage(), (Throwable)e);
        }
    }

    private ScmManagerGitUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

