/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.scm_manager;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.index.merge_request.EMergeRequestStatus;
import com.teamscale.index.merge_request.MergeRequestBuildJob;
import com.teamscale.index.merge_request.MergeRequestProvider;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.index.repository.git.scm_manager.ScmManagerClient;
import com.teamscale.index.repository.git.scm_manager.data.ScmManagerPullRequests;
import java.time.Instant;
import java.util.List;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class ScmManagerMergeRequestProvider
extends MergeRequestProvider<ScmManagerPullRequests.PullRequest, MergeRequestBuildJob> {
    private static final String STATUS_OPEN = "OPEN";
    private static final String STATUS_MERGED = "MERGED";
    private final PlatformRepositoryIdentifier repositoryIdentifier;
    private final ScmManagerClient client;

    public ScmManagerMergeRequestProvider(String repositoryName, ScmManagerClient client) {
        super(null, null);
        this.repositoryIdentifier = PlatformRepositoryIdentifier.fromRepositoryName(repositoryName);
        this.client = client;
    }

    @Override
    public  @Nullable ScmManagerPullRequests.PullRequest getPlatformMergeRequest(long id) throws ServiceCallException {
        return this.client.getPullRequest(this.repositoryIdentifier, id);
    }

    @Override
    protected List<ScmManagerPullRequests.PullRequest> getAllOpenPlatformMergeRequests() throws ServiceCallException {
        return this.client.getOpenPullRequests(this.repositoryIdentifier);
    }

    @Override
    protected MergeRequestProvider.IMergeRequestAdapter createMergeRequestAdapter(ScmManagerPullRequests.PullRequest pullRequest) {
        return new ScmManagerMergeRequestAdapter(pullRequest);
    }

    @Override
    protected boolean isCrossRepositoryMergeRequest( @NonNull ScmManagerPullRequests.PullRequest pullRequest) {
        return false;
    }

    @Override
    public String getRepositoryName() {
        return this.repositoryIdentifier.asRepositoryName();
    }

    private class ScmManagerMergeRequestAdapter
    implements MergeRequestProvider.IMergeRequestAdapter {
        private final ScmManagerPullRequests.PullRequest pullRequest;

        private ScmManagerMergeRequestAdapter(ScmManagerPullRequests.PullRequest pullRequest) {
            this.pullRequest = pullRequest;
        }

        @Override
        public MergeRequestIdentifier getIdentifier() {
            return new MergeRequestIdentifier(ScmManagerMergeRequestProvider.this.repositoryIdentifier.asRepositoryName(), Long.parseLong(this.pullRequest.getId()));
        }

        @Override
        public EMergeRequestStatus getStatus() {
            return switch (this.pullRequest.getStatus()) {
                case ScmManagerMergeRequestProvider.STATUS_OPEN -> EMergeRequestStatus.OPEN;
                case ScmManagerMergeRequestProvider.STATUS_MERGED -> EMergeRequestStatus.MERGED;
                default -> EMergeRequestStatus.OTHER;
            };
        }

        @Override
        public String getTitle() {
            return this.pullRequest.getTitle();
        }

        @Override
        public String getSourceBranch() {
            return this.pullRequest.getSourceBranch();
        }

        @Override
        public String getCommit() {
            return this.pullRequest.getSourceRevision();
        }

        @Override
        public String getTargetBranch() {
            return this.pullRequest.getTargetBranch();
        }

        @Override
        public String getUrl() {
            return ScmManagerMergeRequestProvider.this.client.getPullRequestUrl(Long.parseLong(this.pullRequest.getId()), ScmManagerMergeRequestProvider.this.repositoryIdentifier.asRepositoryName());
        }

        @Override
        public Long getCreatedAt() {
            return Instant.parse(this.pullRequest.getCreationDate()).toEpochMilli();
        }

        @Override
        public Long getUpdatedAt() {
            String lastModified = this.pullRequest.getLastModified();
            if (lastModified != null) {
                return Instant.parse(lastModified).toEpochMilli();
            }
            return this.getCreatedAt();
        }
    }
}

