/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.svn;

import com.teamscale.index.repository.svn.SVNUtils;
import com.teamscale.index.repository.svn.SvnExternalTarget;
import com.teamscale.index.repository.svn.SvnQueryTaskBase;
import com.teamscale.index.repository.svn.SvnRepositoryExecutor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.pattern.IncludeExcludeAntPatternSupport;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.function.ConsumerWithException;
import org.conqat.lib.commons.string.StringUtils;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.io.SVNRepository;

public class SvnExternalsRetriever
extends SvnQueryTaskBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<SvnExternalTarget> externals = Collections.synchronizedList(new ArrayList());
    private final String workingCopyPath;
    private final String pathSuffix;
    private final IncludeExcludeAntPatternSupport externalsPatternSupport;
    protected final Predicate<String> canSubPathsBeIncluded;

    private SvnExternalsRetriever(String workingCopyPath, SVNRepository repository, String suffix, long revision, SvnRepositoryExecutor repositoryExecutor, IncludeExcludeAntPatternSupport externalsPatternSupport, Predicate<String> canSubPathsBeIncluded) {
        super(repository, revision, repositoryExecutor);
        this.workingCopyPath = workingCopyPath;
        this.pathSuffix = suffix;
        this.externalsPatternSupport = externalsPatternSupport;
        this.canSubPathsBeIncluded = canSubPathsBeIncluded;
    }

    public static List<SvnExternalTarget> getExternalsRemote(String workingCopyPath, SVNRepository repository, String suffix, long revision, boolean recursive, SvnRepositoryExecutor repositoryExecutor, IncludeExcludeAntPatternSupport externalsPatternSupport, Predicate<String> canSubPathsBeIncluded) throws SVNException {
        SvnExternalsRetriever retriever = new SvnExternalsRetriever(workingCopyPath, repository, suffix, revision, repositoryExecutor, externalsPatternSupport, canSubPathsBeIncluded);
        int recursionDepth = Integer.MAX_VALUE;
        if (!recursive) {
            recursionDepth = 0;
        }
        retriever.crawlExternals(suffix, recursionDepth);
        retriever.waitForTasks();
        return retriever.externals;
    }

    private void crawlExternals(String basePath, int recursionDepth) {
        String trimmedBasePath = SvnExternalTarget.trimSlashes(basePath);
        this.futures.add(this.repositoryExecutor.submit(repository -> this.crawlExternalsTask((SVNRepository)repository, trimmedBasePath, recursionDepth), this.repository));
    }

    private Void crawlExternalsTask(SVNRepository repository, String basePath, int recursionDepth) throws SVNException {
        ArrayList entries = new ArrayList();
        SVNProperties properties = new SVNProperties();
        try {
            repository.getDir(basePath, this.revision, properties, 1, entries);
        }
        catch (SVNException e) {
            LOGGER.warn("Found non existing external: " + basePath + " in " + repository.getLocation().toDecodedString() + " for revision " + this.revision);
            return null;
        }
        this.processExternals(properties.getStringValue("svn:externals"), basePath, repository);
        String workingCopyBasePath = this.convertToWorkingCopyPath(basePath);
        if (recursionDepth > 0 && this.externalsPatternSupport.canSubPathsBeIncluded(workingCopyBasePath) && this.canSubPathsBeIncluded.test(workingCopyBasePath)) {
            for (SVNDirEntry entry : entries) {
                Object path = entry.getName();
                if (!StringUtils.isEmpty((String)basePath)) {
                    path = basePath + "/" + (String)path;
                }
                if (entry.getKind() != SVNNodeKind.DIR) continue;
                this.crawlExternals((String)path, recursionDepth - 1);
            }
        }
        return null;
    }

    private void processExternals(String externals, String basePath, SVNRepository repository) throws SVNException {
        String workingCopyBasePath = this.convertToWorkingCopyPath(basePath);
        if (workingCopyBasePath.isEmpty()) {
            workingCopyBasePath = ".";
        }
        if (StringUtils.isEmpty((String)externals) || !this.externalsPatternSupport.isIncluded(workingCopyBasePath) || !this.canSubPathsBeIncluded.test(workingCopyBasePath)) {
            return;
        }
        SVNURL containingUrl = repository.getLocation().appendPath(basePath, false);
        try {
            this.parseExternals(containingUrl, externals, repository);
        }
        catch (SVNException e) {
            LOGGER.warn("Ignoring invalid svn:externals properties at " + containingUrl.toDecodedString() + " in revision " + this.revision + ".");
        }
    }

    private String convertToWorkingCopyPath(String serverPath) {
        String uniformPath = StringUtils.stripPrefix((String)StringUtils.stripPrefix((String)serverPath, (String)this.pathSuffix), (String)"/");
        return UniformPathUtils.concatenate((String[])new String[]{this.workingCopyPath, uniformPath});
    }

    private void parseExternals(SVNURL propertyContainingUrl, String externalsValue, SVNRepository repository) throws SVNException {
        for (SVNExternal svnExternal : SVNExternal.parseExternals(null, (String)externalsValue)) {
            SVNUtils.runWithRetry(() -> this.parseExternal(svnExternal, propertyContainingUrl, repository), e -> LOGGER.warn("Had error while resolving external '" + String.valueOf(svnExternal) + "' in " + String.valueOf(propertyContainingUrl) + " at revision " + this.revision + ". Retrying to see if this is a temporary failure."), (ConsumerWithException<SVNException, SVNException>)((ConsumerWithException)e -> LOGGER.warn("Had error while resolving external '" + String.valueOf(svnExternal) + "' in " + String.valueOf(propertyContainingUrl) + " at revision " + this.revision + ". Skipping external.")));
        }
    }

    private void parseExternal(SVNExternal svnExternal, SVNURL propertyContainingUrl, SVNRepository repository) throws SVNException {
        SVNURL resolvedUrl = svnExternal.resolveURL(repository.getLocation(), propertyContainingUrl);
        String localPath = UniformPathUtils.concatenate((String[])new String[]{propertyContainingUrl.toString(), svnExternal.getPath()}).replace(repository.getLocation().appendPath(this.pathSuffix, false).toDecodedString(), "");
        String externalRootUrl = SvnExternalsRetriever.getRepositoryRootUrl(repository.getAuthenticationManager(), resolvedUrl);
        String repositorySuffix = resolvedUrl.toString().replace(externalRootUrl, "");
        long fixedRevision = svnExternal.getPegRevision().getNumber();
        if (fixedRevision < 0L) {
            fixedRevision = 0L;
        }
        this.externals.add(new SvnExternalTarget(localPath, externalRootUrl, repositorySuffix, fixedRevision));
    }

    private static String getRepositoryRootUrl(ISVNAuthenticationManager authManager, SVNURL repositoryUrl) throws SVNException {
        SVNRepository repository = SVNUtils.createRepository(repositoryUrl, null, null);
        repository.setAuthenticationManager(authManager);
        String result = SVNUtils.determineRepositoryRoot(repository, true).toDecodedString();
        repository.closeSession();
        return result;
    }
}

