/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper;

import com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.PolarionLogHandler;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.SerializerFactory;
import javax.xml.rpc.encoding.TypeMapping;
import org.apache.axis.ConfigurationException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.EngineConfigurationFactory;
import org.apache.axis.Handler;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.configuration.BasicClientConfig;
import org.apache.axis.configuration.SimpleProvider;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.ser.BeanDeserializerFactory;
import org.apache.axis.encoding.ser.BeanSerializerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class PolarionEngineConfigurationFactory
implements EngineConfigurationFactory {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Object LOCK = new Object();
    private static final String POLARION_TYPE_PACKAGE = "com.polarion.alm.ws.client.types";
    private static final UnmodifiableList<Class<?>> POLARION_TYPES = PolarionEngineConfigurationFactory.getPolarionTypes();

    private static UnmodifiableList<Class<?>> getPolarionTypes() {
        try (ScanResult scanResult = new ClassGraph().acceptPackages(new String[]{POLARION_TYPE_PACKAGE}).scan();){
            UnmodifiableList unmodifiableList = CollectionUtils.asUnmodifiable((List)scanResult.getAllStandardClasses().loadClasses());
            return unmodifiableList;
        }
    }

    public static EngineConfigurationFactory newFactory(Object param) {
        return new PolarionEngineConfigurationFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EngineConfiguration getClientEngineConfig() {
        Object object = LOCK;
        synchronized (object) {
            BasicClientConfig cfg = new BasicClientConfig();
            PolarionEngineConfigurationFactory.registerPolarionTypeMapping((EngineConfiguration)cfg);
            PolarionEngineConfigurationFactory.registerRequestResponseLogger((SimpleProvider)cfg);
            return cfg;
        }
    }

    private static void registerPolarionTypeMapping(EngineConfiguration cfg) {
        TypeMapping typeMapping;
        try {
            typeMapping = cfg.getTypeMappingRegistry().getTypeMapping(null);
        }
        catch (ConfigurationException e) {
            CCSMAssert.fail((String)"Unable to obtain TypeMapping", (Throwable)e);
            return;
        }
        for (Class polarionType : POLARION_TYPES) {
            TypeDesc typeDesc = TypeDesc.getTypeDescForClass((Class)polarionType);
            if (typeDesc == null) {
                LOGGER.warn("Unable to obtain TypeDesc for {}", (Object)polarionType);
                continue;
            }
            QName xmlType = typeDesc.getXmlType();
            if (typeMapping.isRegistered(polarionType, xmlType)) continue;
            typeMapping.register(polarionType, xmlType, (SerializerFactory)BeanSerializerFactory.createFactory(BeanSerializerFactory.class, (Class)polarionType, (QName)xmlType), (DeserializerFactory)BeanDeserializerFactory.createFactory(BeanDeserializerFactory.class, (Class)polarionType, (QName)xmlType));
        }
    }

    private static void registerRequestResponseLogger(SimpleProvider cfg) {
        try {
            QName http = new QName(null, "http");
            Handler httpHandler = cfg.getTransport(http);
            SimpleTargetedChain httpChain = new SimpleTargetedChain(httpHandler);
            httpChain.addHandler((Handler)new PolarionLogHandler());
            cfg.deployTransport(http, (Handler)httpChain);
        }
        catch (ConfigurationException e) {
            LOGGER.error("Unable to register PolarionLogHandler.", (Throwable)e);
        }
    }

    public EngineConfiguration getServerEngineConfig() {
        throw new UnsupportedOperationException();
    }
}

