/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.importer;

import com.google.common.collect.Sets;
import com.polarion.alm.ws.client.types.Text;
import com.polarion.alm.ws.client.types.tracker.Module;
import com.polarion.alm.ws.client.types.tracker.WorkItem;
import com.teamscale.index.issues.IssueIndexBase;
import com.teamscale.index.issues.IssueTrackerSynchronizerBase;
import com.teamscale.index.issues.cleanup.WorkItemCleaner;
import com.teamscale.index.requirements_tracing.index.SpecItemIndex;
import com.teamscale.index.requirements_tracing.index.SpecItemLatestRevisionCacheIndex;
import com.teamscale.index.requirements_tracing.tools.polarion.client.exception.PolarionServerException;
import com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.PolarionExternalElementCache;
import com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.PolarionWorkItemHistoryProvider;
import com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.cache.PolarionLatestUpdateCacheSupport;
import com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.importer.PolarionImportConfiguration;
import com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.importer.PolarionWorkItemHandlerBase;
import com.teamscale.index.requirements_tracing.tools.polarion.model.polarion.EPolarionDefaultWorkItemField;
import com.teamscale.index.requirements_tracing.tools.polarion.model.polarion.PolarionDocumentLocation;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssueId;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.error.ExceptionUtils;
import org.conqat.lib.commons.string.StringUtils;

public class PolarionWorkItemImporter
extends PolarionWorkItemHandlerBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String workItemBaseUrl;
    private final PolarionDocumentLocation polarionDocumentLocation;
    private final PolarionExternalElementCache elementCache;
    private final Instant currentImportStart;
    private final IssueTrackerSynchronizerBase.WorkItemUpdateResult.Builder<SpecItem> resultBuilder;

    public PolarionWorkItemImporter(PolarionImportConfiguration configuration, Instant currentImportStart, IssueTrackerSynchronizerBase.WorkItemUpdateResult.Builder<SpecItem> resultBuilder) {
        super(configuration);
        this.polarionDocumentLocation = configuration.getPolarionDocumentLocation();
        this.workItemBaseUrl = configuration.getServiceClient().getCredentials().url() + "#/project/" + this.polarionDocumentLocation.getProjectId() + "/workitem?id=";
        this.elementCache = new PolarionExternalElementCache(configuration.getServiceClient());
        this.currentImportStart = currentImportStart;
        this.resultBuilder = resultBuilder;
    }

    public void importWorkItems(SpecItemIndex specItemIndex, SpecItemLatestRevisionCacheIndex specItemLatestRevisionCacheIndex, long lastScanTimestamp) throws PolarionServerException, StorageException, InterruptedException {
        try {
            List<Module> modules = this.extractMatchingModules((Collection)this.configuration.getServiceClient().getModules(this.polarionDocumentLocation.getProjectId(), this.polarionDocumentLocation.getLocation()).getWithException());
            this.performCleanupIfNecessary(specItemIndex, modules);
            this.importWorkItems(specItemIndex, specItemLatestRevisionCacheIndex, lastScanTimestamp, modules);
        }
        catch (PolarionServerException | InterruptedException e) {
            throw new PolarionServerException("Failed to retrieve polarion work items", e);
        }
    }

    private void importWorkItems(SpecItemIndex specItemIndex, SpecItemLatestRevisionCacheIndex specItemLatestRevisionCacheIndex, long lastScanTimestamp, List<Module> modules) throws InterruptedException, PolarionServerException, StorageException {
        Map possibleStatuses = (Map)this.configuration.getServiceClient().getWorkItemStatuses(this.polarionDocumentLocation.getProjectId()).getWithException();
        PolarionWorkItemHistoryProvider itemHistoryProvider = new PolarionWorkItemHistoryProvider(specItemIndex, specItemLatestRevisionCacheIndex, this.configuration.getServiceClient(), this.workItemBaseUrl, this.configuration, this.elementCache, this.resultBuilder);
        HashSet<TeamscaleIssueId> allUpdatedItemIds = new HashSet<TeamscaleIssueId>();
        HashSet<PolarionWorkItemHistoryProvider.LinkedWorkItemChange> linkedWorkItemChanges = new HashSet<PolarionWorkItemHistoryProvider.LinkedWorkItemChange>();
        boolean anyModuleHadSuccess = false;
        PairList failedModules = new PairList();
        for (Module module : modules) {
            try {
                List<WorkItem> updatedWorkItems = this.getUpdatedWorkItems(specItemIndex, module, this.currentImportStart, lastScanTimestamp);
                anyModuleHadSuccess = true;
                allUpdatedItemIds.addAll(updatedWorkItems.stream().map(workItem -> new TeamscaleIssueId(this.configuration.getConnectorId(), workItem.getId())).collect(Collectors.toSet()));
                linkedWorkItemChanges.addAll(itemHistoryProvider.createOrUpdateWorkItemHistories(updatedWorkItems, possibleStatuses));
            }
            catch (PolarionServerException e) {
                failedModules.add((Object)module, (Object)e);
            }
        }
        PolarionWorkItemImporter.handleFailedModules(anyModuleHadSuccess, (PairList<Module, PolarionServerException>)failedModules);
        itemHistoryProvider.generateLinkedWorkItemHistory(possibleStatuses, allUpdatedItemIds, linkedWorkItemChanges);
    }

    private static void handleFailedModules(boolean anyModuleHadSuccess, PairList<Module, PolarionServerException> failedModules) throws PolarionServerException {
        if (!failedModules.isEmpty()) {
            PolarionServerException firstPolarionException = (PolarionServerException)failedModules.getSecondList().stream().reduce(ExceptionUtils::withSuppressed).orElseThrow();
            if (anyModuleHadSuccess) {
                LOGGER.error("Failed to retrieve polarion work items for modules: {}", (Object)failedModules.extractFirstList().stream().map(Module::getId).collect(Collectors.joining(", ")), (Object)firstPolarionException);
            } else {
                throw firstPolarionException;
            }
        }
    }

    private void performCleanupIfNecessary(SpecItemIndex specItemIndex, List<Module> modules) throws PolarionServerException, StorageException {
        Map<TeamscaleIssueId, Long> deletedIds = new WorkItemCleaner<SpecItem>(specItemIndex, null, this.configuration.getConnectorId(), this.configuration.getCleanupStrategy()).performCleanupIfNecessary(this.currentImportStart, () -> {
            try {
                HashSet ids = new HashSet();
                for (Module module : modules) {
                    this.fetchWorkItems(module, null, new String[]{EPolarionDefaultWorkItemField.ID.getPolarionFieldName(), EPolarionDefaultWorkItemField.TYPE.getPolarionFieldName()}).map(WorkItem::getId).forEach(ids::add);
                }
                return ids;
            }
            catch (PolarionServerException | InterruptedException e) {
                throw new PolarionServerException("Failed to retrieve all polarion work items for deletion", e);
            }
        });
        this.resultBuilder.addDeletions(deletedIds);
    }

    private List<WorkItem> getUpdatedWorkItems(IssueIndexBase<SpecItem> specItemIndex, Module module, Instant currentImportStart, long lastScanTimestamp) throws StorageException, PolarionServerException, InterruptedException {
        String connectorId = this.configuration.getConnectorId();
        List<WorkItem> workItems = this.retrieveUpdatedWorkItems(module, lastScanTimestamp).toList();
        workItems = this.filterAndDeleteItemsInRecycleBin(workItems, module, currentImportStart, specItemIndex);
        workItems = new PolarionLatestUpdateCacheSupport(specItemIndex, connectorId).determineWorkItemsUpdatedAfterLatestPolling(workItems);
        return workItems;
    }

    private List<WorkItem> filterAndDeleteItemsInRecycleBin(List<WorkItem> workItems, Module module, Instant currentImportStart, IssueIndexBase<SpecItem> specItemIndex) throws StorageException {
        String content = Optional.ofNullable(module.getHomePageContent()).map(Text::getContent).orElse("");
        Matcher matcher = this.configuration.getWorkItemLinkPattern().matcher(content);
        HashSet<String> foundIds = new HashSet<String>();
        while (matcher.find()) {
            String workItemId = matcher.group("workItemId");
            if (StringUtils.isEmpty((String)workItemId)) continue;
            foundIds.add(workItemId);
        }
        ArrayList<WorkItem> foundItems = new ArrayList<WorkItem>();
        ArrayList<TeamscaleIssueId> deletedItems = new ArrayList<TeamscaleIssueId>();
        for (WorkItem workItem : workItems) {
            if (foundIds.contains(workItem.getId())) {
                foundItems.add(workItem);
                continue;
            }
            deletedItems.add(new TeamscaleIssueId(this.configuration.getConnectorId(), workItem.getId()));
        }
        Set<TeamscaleIssueId> existingDeletedItems = specItemIndex.getContainedKeys(deletedItems);
        this.resultBuilder.addDeletions(existingDeletedItems, currentImportStart.toEpochMilli());
        return foundItems;
    }

    private List<Module> extractMatchingModules(Collection<Module> modules) {
        ArrayList<Module> matchingModules = new ArrayList<Module>();
        for (String documentNameRegex : Sets.newHashSet(this.polarionDocumentLocation.getDocumentNameRegexps())) {
            Pattern documentNamePattern = Pattern.compile(documentNameRegex, 2);
            matchingModules.addAll(modules.stream().filter(module -> module.getId() != null).filter(module -> documentNamePattern.matcher(module.getId()).matches()).toList());
        }
        return matchingModules;
    }
}

