/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.teamscale.core.utils.UnresolvedCommitDescriptorUtils;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.QueryParam;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.factory.IFactory;
import org.jspecify.annotations.NonNull;

public class TimeIntervalBasedServiceQueryOptions {
    public static final String BASELINE_TIMESTAMP_PARAMETER_NAME = "baseline";
    public static final String BASELINE_TIMESTAMP_PARAMETER_DESC = "The baseline commit (inclusive). This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided or \"HEAD\" to refer to the most recent commit. This can optionally be prefixed by the name of the branch, followed by a colon (by default, we use the default branch). You can append a \"p1\" to resolve to the immediate parent of the most recent commit at the given branch/timestamp. p2 would resolve to the parent of the immediate parent and so on. In merge commits, the parent resolution considers only the first parent. You can append \"e\" to include the potential external report uploads of the commit. A parameter value that uses all features would be \"master:1601637680000p1e\"";
    public static final String END_TIMESTAMP_PARAMETER_NAME = "end";
    public static final String END_TIMESTAMP_PARAMETER_DESC = "The end commit (inclusive). This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided or \"HEAD\" to refer to the most recent commit. This can optionally be prefixed by the name of the branch, followed by a colon (by default, we use the default branch). You can append a \"p1\" to resolve to the immediate parent of the most recent commit at the given branch/timestamp. p2 would resolve to the parent of the immediate parent and so on. In merge commits, the parent resolution considers only the first parent. You can append \"e\" to include the potential external report uploads of the commit. A parameter value that uses all features would be \"master:1601637680000p1e\"";
    @Parameter(description="The end commit (inclusive). This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided or \"HEAD\" to refer to the most recent commit. This can optionally be prefixed by the name of the branch, followed by a colon (by default, we use the default branch). You can append a \"p1\" to resolve to the immediate parent of the most recent commit at the given branch/timestamp. p2 would resolve to the parent of the immediate parent and so on. In merge commits, the parent resolution considers only the first parent. You can append \"e\" to include the potential external report uploads of the commit. A parameter value that uses all features would be \"master:1601637680000p1e\"")
    @QueryParam(value="end")
    private UnresolvedCommitDescriptor endCommit;
    @Parameter(description="The baseline commit (inclusive). This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided or \"HEAD\" to refer to the most recent commit. This can optionally be prefixed by the name of the branch, followed by a colon (by default, we use the default branch). You can append a \"p1\" to resolve to the immediate parent of the most recent commit at the given branch/timestamp. p2 would resolve to the parent of the immediate parent and so on. In merge commits, the parent resolution considers only the first parent. You can append \"e\" to include the potential external report uploads of the commit. A parameter value that uses all features would be \"master:1601637680000p1e\"")
    @QueryParam(value="baseline")
    private UnresolvedCommitDescriptor baselineCommit;

    @JsonCreator
    public TimeIntervalBasedServiceQueryOptions() {
    }

    public TimeIntervalBasedServiceQueryOptions(@NonNull UnresolvedCommitDescriptor endCommit, @NonNull UnresolvedCommitDescriptor baselineCommit) {
        this.endCommit = endCommit;
        this.baselineCommit = baselineCommit;
    }

    public CommitDescriptor resolveEndCommit(IFactory<ProjectStorageSystem, StorageException> projectStorageSystemFactory) throws StorageException {
        return UnresolvedCommitDescriptorUtils.resolve((UnresolvedCommitDescriptor)this.endCommit, projectStorageSystemFactory);
    }

    public CommitDescriptor resolveBaselineCommit(IFactory<ProjectStorageSystem, StorageException> projectStorageSystemFactory) throws StorageException {
        return UnresolvedCommitDescriptorUtils.resolve((UnresolvedCommitDescriptor)this.baselineCommit, projectStorageSystemFactory);
    }

    public UnresolvedCommitDescriptor getEndCommit() {
        return this.endCommit;
    }

    public UnresolvedCommitDescriptor getBaselineCommit() {
        return this.baselineCommit;
    }
}

