/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.metrics.code_scopes;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.metrics.MetricsIndex;
import com.teamscale.index.resource.VirtualFileSystemContainerIndexSynchronizerBase;
import org.conqat.lib.commons.uniformpath.UniformPath;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class CodeScopesContainerIndexSynchronizer
extends VirtualFileSystemContainerIndexSynchronizerBase {
    @DeltaSource(value=MetricsIndex.class, indexName="code-scopes-metrics")
    private KeyDelta codeScopesMetricsDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="code-scopes-metrics")
    private MetricsIndex codeScopesMetricsIndex;

    @Override
    protected MetricsIndex getMetricsIndex() {
        return this.codeScopesMetricsIndex;
    }

    @Override
    protected KeyDelta getMetricsDelta() {
        return this.codeScopesMetricsDelta;
    }

    @Override
    protected String cleanKey(String key) {
        UniformPath path = UniformPath.parse((String)key);
        if (!path.isCodeScopesPath()) {
            throw new IllegalArgumentException("Unexpected key '%s', expected a code-scope path".formatted(key));
        }
        if (path.getPathSegments().size() > 1) {
            return path.resolveToCodePath().toString();
        }
        return key;
    }
}

