/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.path_lookup;

import com.teamscale.index.resource.path_lookup.IPathMatchingPlausibilityCheck;
import org.jspecify.annotations.Nullable;

public class PathLookupOptions {
    private final @Nullable IPathMatchingPlausibilityCheck plausibilityCheck;
    private final boolean ignorePlausibilityCheckIfFiltersOutAllPaths;
    private final boolean excludePathsWhereOnlyFileNameMatches;

    private PathLookupOptions(@Nullable IPathMatchingPlausibilityCheck plausibilityCheck, boolean ignorePlausibilityCheckIfFiltersOutAllPaths, boolean excludePathsWhereOnlyFileNameMatches) {
        this.plausibilityCheck = plausibilityCheck;
        this.ignorePlausibilityCheckIfFiltersOutAllPaths = ignorePlausibilityCheckIfFiltersOutAllPaths;
        this.excludePathsWhereOnlyFileNameMatches = excludePathsWhereOnlyFileNameMatches;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PathLookupOptions defaults() {
        return PathLookupOptions.builder().build();
    }

    public static PathLookupOptions includePathsWhereOnlyFileNameMatches() {
        return PathLookupOptions.builder().includePathsWhereOnlyFileNameMatches().build();
    }

    public static PathLookupOptions withPlausibilityCheck(IPathMatchingPlausibilityCheck plausibilityCheck) {
        return PathLookupOptions.builder().withPlausibilityCheck(plausibilityCheck).build();
    }

    public @Nullable IPathMatchingPlausibilityCheck getPlausibilityCheck() {
        return this.plausibilityCheck;
    }

    public boolean shouldIgnorePlausibilityCheckIfFiltersOutAllPaths() {
        return this.ignorePlausibilityCheckIfFiltersOutAllPaths;
    }

    public boolean shouldExcludePathsWhereOnlyFileNameMatches() {
        return this.excludePathsWhereOnlyFileNameMatches;
    }

    public static class Builder {
        private IPathMatchingPlausibilityCheck plausibilityCheck = null;
        private boolean ignorePlausibilityCheckIfAllPathsFiltered = true;
        private boolean excludePathsWhereOnlyFileNameMatches = true;

        public Builder includePathsWhereOnlyFileNameMatches() {
            this.excludePathsWhereOnlyFileNameMatches = false;
            return this;
        }

        public Builder acceptEmptyResultIfPlausibilityCheckFiltersAllPaths() {
            this.ignorePlausibilityCheckIfAllPathsFiltered = false;
            return this;
        }

        public Builder withPlausibilityCheck(IPathMatchingPlausibilityCheck plausibilityCheck) {
            this.plausibilityCheck = plausibilityCheck;
            return this;
        }

        public PathLookupOptions build() {
            return new PathLookupOptions(this.plausibilityCheck, this.ignorePlausibilityCheckIfAllPathsFiltered, this.excludePathsWhereOnlyFileNameMatches);
        }
    }
}

