/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.retrieval_strategy;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.directory.TrendIndexBase;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.BinaryOperator;
import java.util.stream.Stream;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

class CombiningMetricRetrievalStrategy
implements IMetricRetrievalStrategy {
    private final Collection<IMetricRetrievalStrategy> strategies;

    public CombiningMetricRetrievalStrategy(Collection<IMetricRetrievalStrategy> strategies) {
        this.strategies = strategies;
    }

    @Override
    public MetricDirectorySchema getMetricDirectorySchema(HistoryAccessOption historyAccess) throws StorageException {
        return (MetricDirectorySchema)this.mergeForEachStrategy(strategy -> strategy.getMetricDirectorySchema(historyAccess), CombiningMetricRetrievalStrategy::mergeSchema);
    }

    private static MetricDirectorySchema mergeSchema(MetricDirectorySchema one, MetricDirectorySchema two) {
        if (one == null) {
            return two;
        }
        if (two == null) {
            return one;
        }
        LinkedHashMap<String, MetricDirectorySchemaEntry> entriesByName = new LinkedHashMap<String, MetricDirectorySchemaEntry>();
        Iterator entryIter = Stream.of(one, two).map(MetricDirectorySchema::getAllEntries).flatMap(Collection::stream).iterator();
        while (entryIter.hasNext()) {
            MetricDirectorySchemaEntry schemaEntry = (MetricDirectorySchemaEntry)entryIter.next();
            MetricDirectorySchemaEntry previousSchemaEntry = entriesByName.put(schemaEntry.getName(), schemaEntry);
            if (previousSchemaEntry == null) continue;
            throw new IllegalStateException("Got schema entry with same name (%s) in multiple schemas: %s and %s".formatted(schemaEntry.getName(), one, two));
        }
        return new MetricDirectorySchema(entriesByName.values());
    }

    @Override
    public MetricDirectorySchema getMetricDirectorySchema() throws StorageException {
        return (MetricDirectorySchema)this.mergeForEachStrategy(IMetricRetrievalStrategy::getMetricDirectorySchema, CombiningMetricRetrievalStrategy::mergeSchema);
    }

    @Override
    public MetricDirectorySchemaEntry getMetricDirectorySchemaEntry(String metricName) throws StorageException {
        for (IMetricRetrievalStrategy strategy : this.strategies) {
            MetricDirectorySchemaEntry schemaEntry = strategy.getMetricDirectorySchemaEntry(metricName);
            if (schemaEntry == null) continue;
            return schemaEntry;
        }
        return null;
    }

    @Override
    public MetricDirectoryEntry getMetricDirectoryEntry(UniformPath uniformPath, HistoryAccessOption historyAccessOption) throws StorageException {
        HashMap<IMetricRetrievalStrategy, MetricDirectoryEntry> entriesByStrategy = new HashMap<IMetricRetrievalStrategy, MetricDirectoryEntry>();
        for (IMetricRetrievalStrategy strategy : this.strategies) {
            MetricDirectoryEntry strategyEntry = strategy.getMetricDirectoryEntry(uniformPath, historyAccessOption);
            if (strategyEntry == null) continue;
            entriesByStrategy.put(strategy, strategyEntry);
        }
        MetricDirectorySchema compositeSchema = this.getMetricDirectorySchema(historyAccessOption);
        return this.composeCompositeEntry(uniformPath.toString(), compositeSchema, entriesByStrategy);
    }

    @Override
    public List<MetricDirectoryEntry> getMetricDirectoryEntries(List<String> uniformPathPrefixes, HistoryAccessOption historyAccessOption) throws StorageException {
        Map<String, Map<IMetricRetrievalStrategy, MetricDirectoryEntry>> entryByUniformPathAndStrategy = this.getMetricEntriesByPathAndStrategy(uniformPathPrefixes, historyAccessOption);
        MetricDirectorySchema compositeSchema = this.getMetricDirectorySchema(historyAccessOption);
        ArrayList<MetricDirectoryEntry> result = new ArrayList<MetricDirectoryEntry>();
        for (String path : entryByUniformPathAndStrategy.keySet()) {
            Map<IMetricRetrievalStrategy, MetricDirectoryEntry> entriesByStrategy = entryByUniformPathAndStrategy.get(path);
            result.add(this.composeCompositeEntry(path, compositeSchema, entriesByStrategy));
        }
        return result;
    }

    private @NonNull MetricDirectoryEntry composeCompositeEntry(String path, MetricDirectorySchema compositeSchema, Map<IMetricRetrievalStrategy, MetricDirectoryEntry> entriesByStrategy) throws StorageException {
        MetricDirectoryEntry compositeEntry = new MetricDirectoryEntry(path, compositeSchema);
        HashMap<String, Object[]> compositeEntryChildMetrics = new HashMap<String, Object[]>();
        int valueOffset = 0;
        for (IMetricRetrievalStrategy strategy : this.strategies) {
            @Nullable MetricDirectoryEntry strategyEntry = entriesByStrategy.get(strategy);
            if (strategyEntry != null) {
                for (int i = 0; i < strategyEntry.getValues().length; ++i) {
                    compositeEntry.setValue(valueOffset + i, strategyEntry.getValueWithoutNullAssert(i));
                }
                UnmodifiableMap strategyChildEntriesMap = strategyEntry.getChildMetricsMap();
                for (Map.Entry entry : strategyChildEntriesMap.entrySet()) {
                    Object[] newCompositeMetrics;
                    Object[] strategyPathChildMetrics = (Object[])entry.getValue();
                    Object[] compositeMetrics = (Object[])compositeEntryChildMetrics.get(entry.getKey());
                    if (compositeMetrics == (newCompositeMetrics = this.writeMetricsInto(compositeMetrics, strategyPathChildMetrics, compositeSchema, valueOffset))) continue;
                    compositeEntryChildMetrics.put((String)entry.getKey(), newCompositeMetrics);
                }
            }
            MetricDirectorySchema strategySchema = strategy.getMetricDirectorySchema();
            valueOffset += strategySchema.size();
        }
        compositeEntry.setChildMetrics(compositeEntryChildMetrics);
        return compositeEntry;
    }

    private @NonNull Map<String, Map<IMetricRetrievalStrategy, MetricDirectoryEntry>> getMetricEntriesByPathAndStrategy(List<String> uniformPathPrefixes, HistoryAccessOption historyAccessOption) throws StorageException {
        HashMap<String, Map<IMetricRetrievalStrategy, MetricDirectoryEntry>> entryByUniformPathAndStrategy = new HashMap<String, Map<IMetricRetrievalStrategy, MetricDirectoryEntry>>();
        for (IMetricRetrievalStrategy strategy : this.strategies) {
            List<MetricDirectoryEntry> entries = strategy.getMetricDirectoryEntries(uniformPathPrefixes, historyAccessOption);
            for (MetricDirectoryEntry entry : entries) {
                Map strategyEntryMap = entryByUniformPathAndStrategy.computeIfAbsent(entry.getUniformPath(), key -> new HashMap());
                strategyEntryMap.put(strategy, entry);
            }
        }
        return entryByUniformPathAndStrategy;
    }

    private Object[] writeMetricsInto(Object[] compositeValues, @Nullable Object[] strategyValues, MetricDirectorySchema compositeSchema, int valueOffset) {
        if (compositeValues == null) {
            compositeValues = new Object[compositeSchema.size()];
        } else if (compositeValues.length < compositeSchema.size()) {
            Object[] newCompositeValues = new Object[compositeSchema.size()];
            System.arraycopy(compositeValues, 0, newCompositeValues, 0, compositeValues.length);
            compositeValues = newCompositeValues;
        }
        System.arraycopy(strategyValues, 0, compositeValues, valueOffset, strategyValues.length);
        return compositeValues;
    }

    @Override
    public List<TrendIndexBase.TrendEntry<Object[]>> extractMetricHistory(UniformPath uniformPath, CommitDescriptor start, CommitDescriptor end) throws StorageException {
        TreeMap<Long, Map<IMetricRetrievalStrategy, Object[]>> trendByTimestampAndStrategy = new TreeMap<Long, Map<IMetricRetrievalStrategy, Object[]>>();
        for (IMetricRetrievalStrategy strategy : this.strategies) {
            List<TrendIndexBase.TrendEntry<Object[]>> trendEntries = strategy.extractMetricHistory(uniformPath, start, end);
            for (TrendIndexBase.TrendEntry<Object[]> trendEntry : trendEntries) {
                long timestamp = trendEntry.timestamp();
                trendByTimestampAndStrategy.computeIfAbsent(timestamp, ignored -> new IdentityHashMap()).put(strategy, (Object[])trendEntry.value());
            }
        }
        return this.mergeTrends(uniformPath, end.getBranchName(), trendByTimestampAndStrategy);
    }

    private List<TrendIndexBase.TrendEntry<Object[]>> mergeTrends(UniformPath path, String branch, NavigableMap<Long, Map<IMetricRetrievalStrategy, Object[]>> trendByTimestampAndStrategy) throws StorageException {
        ArrayList<TrendIndexBase.TrendEntry<Object[]>> result = new ArrayList<TrendIndexBase.TrendEntry<Object[]>>(trendByTimestampAndStrategy.size());
        Iterator iterator = trendByTimestampAndStrategy.keySet().iterator();
        while (iterator.hasNext()) {
            long timestamp = (Long)iterator.next();
            TrendIndexBase.TrendEntry<Object[]> trendEntry = this.getMergedTrendEntryForTimestamp(path, branch, trendByTimestampAndStrategy, timestamp);
            result.add(trendEntry);
        }
        return result;
    }

    private TrendIndexBase.TrendEntry<Object[]> getMergedTrendEntryForTimestamp(UniformPath path, String branch, NavigableMap<Long, Map<IMetricRetrievalStrategy, Object[]>> trendByTimestampAndStrategy, long timestamp) throws StorageException {
        TrendIndexBase.TrendEntry<Object[]> trendEntry = null;
        for (IMetricRetrievalStrategy strategy : this.strategies) {
            Object[] metricsForStrategy = CombiningMetricRetrievalStrategy.getMetricsForStrategyAndTimestamp(path, branch, trendByTimestampAndStrategy, timestamp, strategy);
            trendEntry = CombiningMetricRetrievalStrategy.mergeTrends(trendEntry, (TrendIndexBase.TrendEntry<Object[]>)new TrendIndexBase.TrendEntry(timestamp, (Object)metricsForStrategy));
        }
        return trendEntry;
    }

    private static Object[] getMetricsForStrategyAndTimestamp(UniformPath path, String branch, NavigableMap<Long, Map<IMetricRetrievalStrategy, Object[]>> trendByTimestampAndStrategy, long timestamp, IMetricRetrievalStrategy strategy) throws StorageException {
        Map metricsPerStrategy = (Map)trendByTimestampAndStrategy.get(timestamp);
        Object[] metricsForStrategy = (Object[])metricsPerStrategy.get(strategy);
        if (metricsForStrategy == null) {
            Map.Entry<Long, Map<IMetricRetrievalStrategy, Object[]>> lowerTrend = trendByTimestampAndStrategy.lowerEntry(timestamp);
            metricsForStrategy = lowerTrend != null ? lowerTrend.getValue().get(strategy) : strategy.getMetricDirectoryEntry(path, HistoryAccessOption.readTimestamp((String)branch, (long)timestamp)).getValues();
            metricsPerStrategy.put(strategy, metricsForStrategy);
        }
        return metricsForStrategy;
    }

    private static TrendIndexBase.TrendEntry<Object[]> mergeTrends(TrendIndexBase.TrendEntry<Object[]> one, TrendIndexBase.TrendEntry<Object[]> two) {
        if (one == null) {
            return two;
        }
        if (two == null) {
            return one;
        }
        return new TrendIndexBase.TrendEntry(one.timestamp(), (Object)MetricRetrievalStrategyUtils.concatArrays((Object[])one.value(), (Object[])two.value()));
    }

    private <T> T mergeForEachStrategy(FunctionWithException<IMetricRetrievalStrategy, T, StorageException> retriever, BinaryOperator<T> merger) throws StorageException {
        Object current = null;
        for (IMetricRetrievalStrategy strategy : this.strategies) {
            Object next = retriever.apply((Object)strategy);
            current = merger.apply(current, next);
        }
        return current;
    }
}

