/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.clones;

import java.util.Map;
import java.util.Optional;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkOutPort;

public class BlockNormalizer {
    private final Map<String, String> blockNormalizationLabelsById;

    public BlockNormalizer(Map<String, String> blockNormalizationLabelsById) {
        this.blockNormalizationLabelsById = blockNormalizationLabelsById;
    }

    public String getNormalizationLabel(SimulinkLine line) {
        StringBuilder builder = new StringBuilder();
        SimulinkOutPort srcPort = line.getSrcPort();
        if (srcPort == null) {
            builder.append("null");
        } else {
            builder.append(this.getNormalizationLabel(srcPort.getBlock())).append(":").append(BlockNormalizer.getOutPortNormalization(srcPort));
        }
        builder.append(" -> ");
        SimulinkInPort dstPort = line.getDstPort();
        if (dstPort == null) {
            builder.append("null");
        } else {
            builder.append(this.getNormalizationLabel(dstPort.getBlock())).append(":").append(BlockNormalizer.getInPortNormalization(dstPort));
        }
        return builder.toString();
    }

    public String getNormalizationLabel(SimulinkBlock block) {
        String type = block.getResolvedType();
        StringBuilder builder = new StringBuilder(type);
        String normalizationLabel = this.blockNormalizationLabelsById.get(block.getId());
        if (normalizationLabel != null) {
            builder.append("::").append(normalizationLabel);
        } else {
            BlockNormalizer.getCharacteristicParameterName(type).ifPresent(name -> builder.append("::").append(block.getParameter(name)));
        }
        return builder.toString();
    }

    private static Optional<String> getCharacteristicParameterName(String blockType) {
        switch (blockType) {
            case "Logic": 
            case "Math": 
            case "RelationalOperator": 
            case "Trigonometry": {
                return Optional.of("Operator");
            }
            case "Fcn": {
                return Optional.of("Expr");
            }
            case "Demux": {
                return Optional.of("Ports");
            }
            case "Constant": {
                return Optional.of("Value");
            }
            case "MATLABFcn": {
                return Optional.of("MATLABFcn");
            }
            case "S-Function": {
                return Optional.of("FunctionName");
            }
            case "SignalGenerator": {
                return Optional.of("WaveForm");
            }
        }
        return Optional.empty();
    }

    private static String getOutPortNormalization(SimulinkOutPort srcPort) {
        switch (srcPort.getBlock().getResolvedType()) {
            case "BusCreator": {
                return "any";
            }
        }
        return srcPort.getIndex();
    }

    private static String getInPortNormalization(SimulinkInPort dstPort) {
        switch (dstPort.getBlock().getResolvedType()) {
            case "Sum": {
                return dstPort.obtainLabelData().getText();
            }
            case "BusSelector": 
            case "Logic": 
            case "Product": {
                return "any";
            }
        }
        return dstPort.getIndex();
    }
}

