/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.structure;

import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.structure.ShallowParsedLongestStatementListAnalyzer;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import eu.cqse.check.framework.util.tokens.TokenUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.resource.text.filter.util.StringOffsetTransformer;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.region.Region;
import org.conqat.lib.commons.region.RegionSet;
import org.conqat.lib.commons.region.SimpleRegion;
import org.conqat.lib.commons.string.StringUtils;

public class FindingsBasedMethodAssessor {
    private final boolean slocBased;
    private static final Logger LOGGER = LogManager.getLogger();
    private final Set<String> invalidFilesWarned = new HashSet<String>();

    public FindingsBasedMethodAssessor(boolean slocBased) {
        this.slocBased = slocBased;
    }

    public PairList<String, Serializable> computeAssessmentMetricValues(List<TokenElementInfo> elements, ListMap<String, IndexFinding> allFindings) {
        PairList assessmentMetrics = new PairList();
        for (TokenElementInfo element : elements) {
            List findings = (List)allFindings.getCollectionOrEmpty((Object)element.getUniformPath());
            Assessment assessment = this.determineAssessment(element, findings, element.getLanguage().isCppOrC());
            assessmentMetrics.add((Object)element.getUniformPath(), (Object)assessment);
        }
        return assessmentMetrics;
    }

    private Assessment determineAssessment(TokenElementInfo element, Collection<IndexFinding> findings, boolean computePreprocessorAware) {
        Map<ETrafficLightColor, RegionSet> findingColorRegions = FindingsBasedMethodAssessor.determineFindingColorRegions(element, findings);
        Assessment assessment = new Assessment();
        HashSet<Integer> coveredLines = new HashSet<Integer>();
        if (computePreprocessorAware) {
            for (ShallowEntity method : ShallowEntityTraversalUtils.listMethodsNonRecursive(element.getShallowEntitiesWithPreprocessorTokens())) {
                this.updateAssessmentForMethodPreprocessorAware(assessment, method, findingColorRegions, element, coveredLines);
            }
        } else {
            for (ShallowEntity method : ShallowEntityTraversalUtils.listMethodsNonRecursive(element.getShallowEntitiesWithoutPreprocessorTokens())) {
                this.updateAssessmentForMethod(assessment, method, findingColorRegions, element, coveredLines);
            }
        }
        return assessment;
    }

    private static Map<ETrafficLightColor, RegionSet> determineFindingColorRegions(TokenElementInfo element, Collection<IndexFinding> findings) {
        EnumMap<ETrafficLightColor, RegionSet> findingColorRegions = new EnumMap<ETrafficLightColor, RegionSet>(ETrafficLightColor.class);
        StringOffsetTransformer transformer = new StringOffsetTransformer((List)element.getFilterDeletions());
        for (IndexFinding finding : findings) {
            if (!(finding.getLocation() instanceof TextRegionLocation)) continue;
            TextRegionLocation location = (TextRegionLocation)finding.getLocation();
            ETrafficLightColor color = finding.getAssessment();
            RegionSet regions = (RegionSet)findingColorRegions.get(color);
            if (regions == null) {
                regions = new RegionSet();
                findingColorRegions.put(color, regions);
            }
            regions.add(new Region(transformer.getFilteredOffset(location.getRawStartOffset()), transformer.getFilteredOffset(location.getRawEndOffset())));
        }
        return findingColorRegions;
    }

    private void updateAssessmentForMethod(Assessment assessment, ShallowEntity method, Map<ETrafficLightColor, RegionSet> findingColorRegions, TokenElementInfo element, Set<Integer> coveredLines) {
        UnmodifiableList methodChildren = method.getChildren();
        if (methodChildren.isEmpty()) {
            return;
        }
        List childMethods = ShallowEntityTraversalUtils.listMethodsNonRecursive((List)methodChildren);
        childMethods = CollectionUtils.filter((Collection)childMethods, m -> !ShallowParsingUtils.isLambdaMethod((ShallowEntity)m));
        this.updateAssessmentForChildMethods(assessment, findingColorRegions, childMethods, element, coveredLines);
        int methodStartTokenIndex = method.getStartTokenIndex();
        int size = 0;
        ETrafficLightColor methodColor = ETrafficLightColor.GREEN;
        int firstChildTokenIndex = ((ShallowEntity)methodChildren.get(0)).getStartTokenIndex();
        for (ShallowEntity childMethod : childMethods) {
            List<IToken> tokens = this.safeSubList((List<IToken>)method.includedTokens(), firstChildTokenIndex - methodStartTokenIndex, childMethod.getStartTokenIndex() - methodStartTokenIndex, element);
            size += this.determineSize(tokens, coveredLines);
            methodColor = ETrafficLightColor.getDominantColor((ETrafficLightColor)methodColor, (ETrafficLightColor)FindingsBasedMethodAssessor.determineColor(tokens, findingColorRegions));
            firstChildTokenIndex = childMethod.getEndTokenIndex();
        }
        int lastChildTokenIndex = ((ShallowEntity)CollectionUtils.getLast((List)methodChildren)).getEndTokenIndex();
        List<IToken> tokens = this.safeSubList((List<IToken>)method.includedTokens(), firstChildTokenIndex - methodStartTokenIndex, lastChildTokenIndex - methodStartTokenIndex, element);
        methodColor = ETrafficLightColor.getDominantColor((ETrafficLightColor)methodColor, (ETrafficLightColor)FindingsBasedMethodAssessor.determineColor(tokens, findingColorRegions));
        assessment.add(methodColor, size += this.determineSize(tokens, coveredLines));
    }

    private void updateAssessmentForMethodPreprocessorAware(Assessment assessment, ShallowEntity method, Map<ETrafficLightColor, RegionSet> findingColorRegions, TokenElementInfo element, Set<Integer> coveredLines) {
        UnmodifiableList methodChildren = method.getChildren();
        if (methodChildren.isEmpty()) {
            return;
        }
        if (!method.hasChildren() && !TokenStreamUtils.endsWith((List)method.includedTokens(), (ETokenType[])new ETokenType[]{ETokenType.LBRACE, ETokenType.RBRACE})) {
            return;
        }
        Optional<Pair<IToken, IToken>> bodyStartEndTokens = ShallowParsedLongestStatementListAnalyzer.getBodyStartEndBraceTokens(method);
        if (!bodyStartEndTokens.isPresent()) {
            LOGGER.warn("Method-Length Assessment: Could not determine start/end of method " + method.getName() + " in " + element.getUniformPath());
            return;
        }
        IToken lastStartToken = (IToken)bodyStartEndTokens.get().getFirst();
        IToken firstEndToken = (IToken)bodyStartEndTokens.get().getSecond();
        List<IToken> nonPreprocessedTokens = FindingsBasedMethodAssessor.getTokensBetween(lastStartToken, firstEndToken, element.getTokens());
        int size = this.determineSize(nonPreprocessedTokens, coveredLines);
        ETrafficLightColor methodColor = FindingsBasedMethodAssessor.determineColor(nonPreprocessedTokens, findingColorRegions);
        assessment.add(methodColor, size);
    }

    private static List<IToken> getTokensBetween(IToken startToken, IToken endToken, List<IToken> tokens) {
        int bodyStartTokenIndex = TokenStreamUtils.indexOfByOffset(tokens, (int)startToken.getOffset()) + 1;
        int bodyEndTokenIndex = TokenStreamUtils.indexOfByOffset(tokens, (int)endToken.getOffset()) - 1;
        if (bodyStartTokenIndex == -1 || bodyEndTokenIndex == -1 || bodyStartTokenIndex > bodyEndTokenIndex) {
            return Collections.emptyList();
        }
        return tokens.subList(bodyStartTokenIndex, bodyEndTokenIndex);
    }

    private List<IToken> safeSubList(List<IToken> tokens, int fromIndex, int toIndex, TokenElementInfo element) {
        boolean hadInvalid = false;
        if (fromIndex < 0) {
            fromIndex = 0;
            hadInvalid = true;
        }
        if (toIndex > tokens.size()) {
            toIndex = tokens.size();
            hadInvalid = true;
        }
        if (toIndex < fromIndex) {
            toIndex = 0;
            fromIndex = 0;
            hadInvalid = true;
        }
        if (hadInvalid && this.invalidFilesWarned.add(element.getUniformPath())) {
            LOGGER.warn("Encountered invalid token index in " + element.getUniformPath() + ". This is likely due to a non-compiling file.");
        }
        return tokens.subList(fromIndex, toIndex);
    }

    private void updateAssessmentForChildMethods(Assessment assessment, Map<ETrafficLightColor, RegionSet> findingColorRegions, List<ShallowEntity> childMethods, TokenElementInfo element, Set<Integer> coveredLines) {
        for (ShallowEntity childMethod : childMethods) {
            this.updateAssessmentForMethod(assessment, childMethod, findingColorRegions, element, coveredLines);
        }
    }

    private int determineSize(List<IToken> tokens, Set<Integer> coveredLines) {
        if (tokens.isEmpty()) {
            return 0;
        }
        if (this.slocBased) {
            return TokenUtils.countSloc(tokens, coveredLines);
        }
        IToken lastToken = (IToken)CollectionUtils.getLast(tokens);
        int firstLine = tokens.get(0).getLineNumber();
        int lastLine = lastToken.getLineNumber() + StringUtils.countLines((String)lastToken.getText());
        int size = 0;
        for (int line = firstLine; line < lastLine; ++line) {
            if (!coveredLines.add(line)) continue;
            ++size;
        }
        return size;
    }

    private static ETrafficLightColor determineColor(List<IToken> tokens, Map<ETrafficLightColor, RegionSet> findingColorRegions) {
        if (tokens.isEmpty()) {
            return ETrafficLightColor.GREEN;
        }
        Region tokenRegion = new Region(tokens.get(0).getOffset(), ((IToken)CollectionUtils.getLast(tokens)).getEndOffset());
        for (ETrafficLightColor color : ETrafficLightColor.values()) {
            RegionSet regions = findingColorRegions.get(color);
            if (regions == null || !regions.containsAny((SimpleRegion)tokenRegion)) continue;
            return color;
        }
        return ETrafficLightColor.GREEN;
    }
}

