/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap;

import com.teamscale.index.testgap.AssociatedMethodTestInfo;
import com.teamscale.index.testgap.CachedPartitionsStoreFeature;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testgap.PartitionLastUpdatedStoreFeature;
import com.teamscale.index.testgap.RawMethodLastTestedStoreFeature;
import com.teamscale.index.testgap.RawMethodLastTestedValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Index(name="tga-last-tested", options={EStorageOption.BRANCHED, EStorageOption.ABBREVIATE_STRINGS}, valueClasses={String.class})
public class MethodLastTestedIndex
extends IndexBase
implements IProjectIndex {
    private static final byte[] PARTITION_UPLOAD_KEY_PREFIX = new byte[]{-1};
    private static final byte[] PARTITION_UPDATE_KEY_PREFIX = new byte[]{-2};
    public static final String INDEX_NAME = "tga-last-tested";
    private final CachedPartitionsStoreFeature cachedPartitionsStoreFeature;
    private final PartitionLastUpdatedStoreFeature partitionLastUploadStoreFeature;
    private final PartitionLastUpdatedStoreFeature partitionLastUpdatedStoreFeature;
    private final RawMethodLastTestedStoreFeature rawMethodLastTestedStoreFeature;

    public MethodLastTestedIndex(IStore store) {
        super(store);
        this.cachedPartitionsStoreFeature = new CachedPartitionsStoreFeature(store);
        this.partitionLastUploadStoreFeature = new PartitionLastUpdatedStoreFeature(store, PARTITION_UPLOAD_KEY_PREFIX);
        this.partitionLastUpdatedStoreFeature = new PartitionLastUpdatedStoreFeature(store, PARTITION_UPDATE_KEY_PREFIX);
        this.rawMethodLastTestedStoreFeature = new RawMethodLastTestedStoreFeature(store);
    }

    public List<String> getPartitions() throws StorageException {
        return this.cachedPartitionsStoreFeature.getPartitions();
    }

    public Set<String> getPartitionsUpdatedAfter(long baselineTimestamp) throws StorageException {
        HashSet<String> partitionsFromLastUpdateIndex = new HashSet<String>();
        List<String> allPartitions = this.getPartitions();
        for (Map.Entry<String, CommitDescriptor> partitionWithLastUpdate : this.partitionLastUpdatedStoreFeature.getPartitionToLastUploadMap(allPartitions).entrySet()) {
            if (partitionWithLastUpdate.getValue().getTimestamp() < baselineTimestamp) continue;
            partitionsFromLastUpdateIndex.add(partitionWithLastUpdate.getKey());
        }
        return CollectionUtils.intersectionSet(allPartitions, (Collection[])new Collection[]{partitionsFromLastUpdateIndex});
    }

    public void addPartitions(Collection<String> partitions) throws StorageException {
        this.cachedPartitionsStoreFeature.addPartitions(partitions);
    }

    public void setPartitionsLastUpload(String partition, CommitDescriptor lastUpdatedCommit) throws StorageException {
        this.setPartitionsLastUpload((PairList<String, CommitDescriptor>)PairList.from((Object)partition, (Object)lastUpdatedCommit));
    }

    public void setPartitionsLastUpload(PairList<String, CommitDescriptor> partitionsAndLastUpdatedCommit) throws StorageException {
        this.partitionLastUploadStoreFeature.setPartitionsLastUpdated(partitionsAndLastUpdatedCommit);
        this.partitionLastUpdatedStoreFeature.setPartitionsLastUpdated(partitionsAndLastUpdatedCommit);
    }

    public Map<String, CommitDescriptor> getPartitionToLastUploadMap() throws StorageException {
        return this.partitionLastUploadStoreFeature.getPartitionToLastUploadMap(this.getPartitions());
    }

    public Map<String, CommitDescriptor> getPartitionToLastUploadMap(Collection<String> partitions) throws StorageException {
        return this.partitionLastUploadStoreFeature.getPartitionToLastUploadMap(partitions);
    }

    public void removeByUniformPath(List<String> uniformPaths) throws StorageException {
        if (uniformPaths.isEmpty()) {
            return;
        }
        this.rawMethodLastTestedStoreFeature.removeByUniformPath(this.getPartitions(), uniformPaths);
    }

    @TestOnly
    public List<AssociatedMethodTestInfo> getTimestampsForMethodKey(MethodLocation key) throws StorageException {
        if (key == null) {
            return CollectionUtils.emptyList();
        }
        return this.getTimestampsForMethodKeys(Collections.singleton(key));
    }

    private List<AssociatedMethodTestInfo> getAssociatedMethodTestInfos(PairList<AccessKey, RawMethodLastTestedValue> pathsAndCommits, Collection<String> partitions) throws StorageException {
        Map<String, CommitDescriptor> latestTimestampByPartition = this.getPartitionToLastUploadMap(partitions);
        ArrayList<AssociatedMethodTestInfo> associatedTestInfos = new ArrayList<AssociatedMethodTestInfo>();
        for (int i = 0; i < pathsAndCommits.size(); ++i) {
            AccessKey key = (AccessKey)pathsAndCommits.getFirst(i);
            CommitDescriptor lastTestUploadCommit = MethodLastTestedIndex.resolveTestCommitInfo((RawMethodLastTestedValue)pathsAndCommits.getSecond(i), latestTimestampByPartition, key);
            if (lastTestUploadCommit == null) continue;
            AssociatedMethodTestInfo associatedTestInfo = new AssociatedMethodTestInfo(key.partition, key.uniformPath, key.region.getStart(), key.region.getEnd(), lastTestUploadCommit);
            associatedTestInfos.add(associatedTestInfo);
        }
        return associatedTestInfos;
    }

    private static @Nullable CommitDescriptor resolveTestCommitInfo(@Nullable RawMethodLastTestedValue rawMethodLastTestedValue, Map<String, CommitDescriptor> latestTimestampByPartition, AccessKey key) throws StorageException {
        if (rawMethodLastTestedValue == null) {
            return null;
        }
        if (rawMethodLastTestedValue.latest()) {
            CommitDescriptor lastTestUploadCommit = latestTimestampByPartition.get(key.partition);
            if (lastTestUploadCommit == null) {
                throw new StorageException("No latest timestamp provided for partition " + key.partition + ", which was requested!");
            }
            if (rawMethodLastTestedValue.uploadOrMergeCommit() == null) {
                return lastTestUploadCommit;
            }
            return CommitDescriptor.max((CommitDescriptor)lastTestUploadCommit, (CommitDescriptor)rawMethodLastTestedValue.uploadOrMergeCommit());
        }
        return rawMethodLastTestedValue.uploadOrMergeCommit();
    }

    public void setLastTestedTimestamps(PairList<AccessKey, CommitDescriptor> keysAndTimestamps, long currentTimestamp) throws StorageException {
        this.addPartitions(CollectionUtils.mapDistinct((Collection)keysAndTimestamps.extractFirstList(), key -> key.partition));
        this.rawMethodLastTestedStoreFeature.setLastTestedTimestamps((PairList<AccessKey, RawMethodLastTestedValue>)keysAndTimestamps.mapSecond(commit -> {
            if (commit.getTimestamp() == currentTimestamp) {
                return RawMethodLastTestedValue.LATEST;
            }
            return new RawMethodLastTestedValue(false, (CommitDescriptor)commit);
        }));
    }

    public void setLastMergedTimestamps(PairList<AccessKey, CommitDescriptor> keysAndTimestamps) throws StorageException {
        this.addPartitions(CollectionUtils.mapDistinct((Collection)keysAndTimestamps.extractFirstList(), key -> key.partition));
        this.partitionLastUpdatedStoreFeature.setPartitionsLastUpdated(MethodLastTestedIndex.extractPartitionToLastUpdated(keysAndTimestamps));
        this.rawMethodLastTestedStoreFeature.setLastMergedTimestamps(keysAndTimestamps);
    }

    private static @NonNull PairList<String, CommitDescriptor> extractPartitionToLastUpdated(PairList<AccessKey, CommitDescriptor> keysAndTimestamps) {
        HashMap<String, CommitDescriptor> partitionLastMerged = new HashMap<String, CommitDescriptor>();
        for (Pair keysAndTimestamp : keysAndTimestamps) {
            String partition = ((AccessKey)keysAndTimestamp.getFirst()).partition;
            CommitDescriptor commit = (CommitDescriptor)keysAndTimestamp.getSecond();
            partitionLastMerged.merge(partition, commit, CommitDescriptor::max);
        }
        return PairList.fromMap(partitionLastMerged);
    }

    @TestOnly
    @Nullable RawMethodLastTestedValue getRawLastTestCommitForTesting(String partition, UniformPath uniformPath, OffsetBasedRegion region) throws StorageException {
        return this.rawMethodLastTestedStoreFeature.getRawLastTestCommitForTesting(partition, uniformPath, region);
    }

    public List<AssociatedMethodTestInfo> getTestInfosForPartitionsAndExactPath(List<String> partitions, String uniformPath) throws StorageException {
        PairList<AccessKey, RawMethodLastTestedValue> entries = this.rawMethodLastTestedStoreFeature.getTestInfosForPartitionsAndExactPath(partitions, uniformPath);
        return this.getAssociatedMethodTestInfos(entries, partitions);
    }

    @VisibleForTesting
    public List<AssociatedMethodTestInfo> getTestInfosForPartitionsAndExactPaths(List<String> partitions, List<String> uniformPaths) throws StorageException {
        PairList<AccessKey, RawMethodLastTestedValue> entries = this.rawMethodLastTestedStoreFeature.getTestInfosForPartitionsAndExactPaths(partitions, uniformPaths);
        return this.getAssociatedMethodTestInfos(entries, partitions);
    }

    public List<AssociatedMethodTestInfo> getTimestampsForMethodKeys(Collection<MethodLocation> methodKeys) throws StorageException {
        return this.getTestInfosForMethodLocationsInPartitions(this.getPartitions(), methodKeys);
    }

    public List<AssociatedMethodTestInfo> getTestInfosForMethodLocationsInPartitions(Collection<String> partitions, Collection<MethodLocation> methodLocations) throws StorageException {
        return this.getAssociatedMethodTestInfos(this.rawMethodLastTestedStoreFeature.getTestInfosForMethodLocationsInPartitions(partitions, methodLocations), partitions);
    }

    public List<AssociatedMethodTestInfo> getTestInfosForMethodLocationsInPartitions(SetMap<String, MethodLocation> methodLocationsByPartition) throws StorageException {
        PairList<AccessKey, RawMethodLastTestedValue> testInfosForMethodLocationsInPartitions = this.rawMethodLastTestedStoreFeature.getTestInfosForMethodLocationsInPartitions(methodLocationsByPartition);
        return this.getAssociatedMethodTestInfos(testInfosForMethodLocationsInPartitions, (Collection<String>)methodLocationsByPartition.getKeys());
    }

    public static class AccessKey {
        final String partition;
        final UniformPath uniformPath;
        final OffsetBasedRegion region;

        public AccessKey(String partition, UniformPath uniformPath, OffsetBasedRegion region) {
            this.partition = partition;
            this.uniformPath = uniformPath;
            this.region = region;
        }

        public String toString() {
            return "AccessKey{partition='" + this.partition + "', uniformPath='" + String.valueOf(this.uniformPath) + "', region=" + String.valueOf(this.region) + "}";
        }

        public int hashCode() {
            return Objects.hash(this.partition, this.uniformPath, this.region);
        }

        public boolean equals(Object obj) {
            if (obj instanceof AccessKey) {
                AccessKey other = (AccessKey)obj;
                return Objects.equals(this.partition, other.partition) && Objects.equals(this.uniformPath, other.uniformPath) && Objects.equals(this.region, other.region);
            }
            return false;
        }
    }
}

