/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.index.configuration.CodeScopeUtils;
import com.teamscale.index.resource.CodeScopesMappingIndex;
import java.util.Collection;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class TestGapEnablementChecker {
    private static final Logger LOGGER = LogManager.getLogger();
    private final CodeScopeAware<Boolean> tgaEnablement;
    private final Map<UniformPath, Boolean> tgaEnablementPerPath;

    public TestGapEnablementChecker(Collection<UniformPath> uniformPaths, CodeScopesMappingIndex codeScopesMappingIndex, CodeScopeAware<Boolean> tgaEnablementPerCodeScope) throws StorageException {
        this.tgaEnablement = tgaEnablementPerCodeScope;
        this.tgaEnablementPerPath = CodeScopeUtils.getValuesForPaths(uniformPaths, codeScopesMappingIndex, tgaEnablementPerCodeScope);
    }

    public boolean isTgaEnabled(UniformPath uniformPath) {
        if (!this.tgaEnablementPerPath.containsKey(uniformPath)) {
            LOGGER.error("Could not find code scope for uniform path '{}'. Falling back to TGA enablement in the default code scope.", (Object)uniformPath);
            return (Boolean)this.tgaEnablement.getValueForDefaultCodeScope();
        }
        return this.tgaEnablementPerPath.get(uniformPath);
    }
}

