/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.StepParameterObject;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.repository.CommitResolutionException;
import com.teamscale.index.testgap.MethodLastTestedSynchronizer;
import com.teamscale.index.testgap.TestInfoProcessorParameters;
import com.teamscale.index.testgap.TestInfoRegionUpdater;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class TestGapSynchronizer
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    @StepParameterObject
    private final TestInfoProcessorParameters parameters = new TestInfoProcessorParameters();
    @StepParameterObject
    private final MethodLastTestedSynchronizer testInfoSynchronizer = new MethodLastTestedSynchronizer();

    public void execute() throws StorageException, ExecutionException {
        this.getProfilingMonitor().startProfiling("update last tested timestamps");
        try {
            new TestInfoRegionUpdater(this.getSchedulingCommit(), this.parameters).updateLastTestedTimestamps();
        }
        catch (CommitResolutionException e) {
            LOGGER.error("Failed to update last tested timestamps.", (Throwable)e);
            return;
        }
        finally {
            this.getProfilingMonitor().stopProfiling("update last tested timestamps");
        }
        this.testInfoSynchronizer.process(this.getSchedulingCommit(), this.parameters, this.getProfilingMonitor(), (x$0, x$1, x$2) -> this.executeInParallelBatches(x$0, x$1, x$2));
    }
}

