/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.assessment;

import com.teamscale.index.testgap.ETestGapState;
import com.teamscale.index.testgap.assessment.AssessedTgaData;
import com.teamscale.index.testgap.assessment.ETgaAssessmentType;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class TgaAggregationUtils {
    public static CounterSet<ETestGapState> countStates(AssessedTgaData assessedTestGapData) {
        return TgaAggregationUtils.countStates(assessedTestGapData.getMethods());
    }

    public static CounterSet<ETestGapState> countStates(List<AssessedTgaData.AssessedMethodData> methods) {
        return TgaAggregationUtils.countStates(methods, AssessedTgaData.AssessedMethodData::getTestGapState);
    }

    public static CounterSet<ETestGapState> countStates(List<AssessedTgaData.AssessedMethodData> methods, ETgaAssessmentType assessmentType) {
        return TgaAggregationUtils.countStates(methods, (AssessedTgaData.AssessedMethodData method) -> method.getAssessment().getStateForAssessmentType(assessmentType));
    }

    public static CounterSet<ETestGapState> countStates(List<AssessedTgaData.AssessedMethodData> methods, Function<AssessedTgaData.AssessedMethodData, ETestGapState> stateGetter) {
        return new CounterSet((Collection)CollectionUtils.map(methods, stateGetter));
    }

    public static int countTestGaps(List<AssessedTgaData.AssessedMethodData> assessedTestGapData) {
        CounterSet<ETestGapState> stateCounter = TgaAggregationUtils.countStates(assessedTestGapData, ETgaAssessmentType.TEST_GAP);
        return TgaAggregationUtils.countTestGaps(stateCounter);
    }

    public static int countTestGaps(CounterSet<ETestGapState> stateCounter) {
        return stateCounter.getValue((Object)ETestGapState.UNTESTED_ADDITION) + stateCounter.getValue((Object)ETestGapState.UNTESTED_CHANGE);
    }

    public static double calculateUntestedAddedMethodsRatio(CounterSet<ETestGapState> stateCounter) {
        return TgaAggregationUtils.calculateRatio(ETestGapState.UNTESTED_ADDITION, stateCounter);
    }

    public static double calculateUntestedChangedMethodsRatio(CounterSet<ETestGapState> stateCounter) {
        return TgaAggregationUtils.calculateRatio(ETestGapState.UNTESTED_CHANGE, stateCounter);
    }

    private static double calculateRatio(ETestGapState untestedState, CounterSet<ETestGapState> stateCounter) {
        double divisor = TgaAggregationUtils.countTestGaps(stateCounter);
        if (divisor == 0.0) {
            return 0.0;
        }
        return (double)stateCounter.getValue((Object)untestedState) / divisor;
    }

    public static double calculateRatio(ETgaAssessmentType assessmentType, AssessedTgaData data) {
        return TgaAggregationUtils.calculateRatio(assessmentType, TgaAggregationUtils.countStates(data.getMethods(), assessmentType));
    }

    public static double calculateRatio(ETgaAssessmentType assessmentType, CounterSet<ETestGapState> stateCounter) {
        double ratioDivisor;
        double ratioDividend;
        if (assessmentType == ETgaAssessmentType.EXECUTION_ONLY) {
            ratioDividend = stateCounter.getValue((Object)ETestGapState.EXECUTED);
            ratioDivisor = stateCounter.getTotal();
        } else if (assessmentType == ETgaAssessmentType.CHURN) {
            ratioDividend = TgaAggregationUtils.countTestGaps(stateCounter);
            ratioDivisor = stateCounter.getTotal();
        } else {
            ratioDividend = TgaAggregationUtils.countTestGaps(stateCounter);
            ratioDivisor = ratioDividend + (double)stateCounter.getValue((Object)ETestGapState.TESTED_CHURN);
        }
        if (ratioDivisor == 0.0) {
            return 0.0;
        }
        return ratioDividend / ratioDivisor;
    }

    public static String getTestGapsFormatted(CounterSet<ETestGapState> testGapStates) {
        StringBuilder builder = new StringBuilder();
        int testGaps = TgaAggregationUtils.countTestGaps(testGapStates);
        builder.append(testGaps).append(" Test Gap");
        if (testGaps != 1) {
            builder.append("s");
        }
        builder.append(" (").append(StringUtils.formatAsPercentage((Number)TgaAggregationUtils.calculateRatio(ETgaAssessmentType.TEST_GAP, testGapStates))).append(")");
        if (!testGapStates.isEmpty()) {
            builder.append(" ");
            builder.append("tested changes: ").append(testGapStates.getValue((Object)ETestGapState.TESTED_CHURN)).append("|");
            builder.append("untested changes: ").append(testGapStates.getValue((Object)ETestGapState.UNTESTED_CHANGE)).append("|");
            builder.append("untested additions: ").append(testGapStates.getValue((Object)ETestGapState.UNTESTED_ADDITION));
        }
        return builder.toString();
    }

    private TgaAggregationUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

